/*
 * Decompiled with CFR 0.152.
 */
package org.apache.archiva.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractRepositoryConnectorConfiguration
implements Serializable {
    private String sourceRepoId;
    private String targetRepoId;
    private String proxyId;
    private List<String> blackListPatterns;
    private List<String> whiteListPatterns;
    private Map policies;
    private Map properties;
    private boolean disabled = false;

    public void addBlackListPattern(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("AbstractRepositoryConnectorConfiguration.addBlackListPatterns(string) parameter must be instanceof " + String.class.getName());
        }
        this.getBlackListPatterns().add(string);
    }

    public void addPolicy(Object key, String value) {
        this.getPolicies().put(key, value);
    }

    public void addProperty(Object key, String value) {
        this.getProperties().put(key, value);
    }

    public void addWhiteListPattern(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("AbstractRepositoryConnectorConfiguration.addWhiteListPatterns(string) parameter must be instanceof " + String.class.getName());
        }
        this.getWhiteListPatterns().add(string);
    }

    public List<String> getBlackListPatterns() {
        if (this.blackListPatterns == null) {
            this.blackListPatterns = new ArrayList<String>();
        }
        return this.blackListPatterns;
    }

    public Map getPolicies() {
        if (this.policies == null) {
            this.policies = new HashMap();
        }
        return this.policies;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        return this.properties;
    }

    public String getProxyId() {
        return this.proxyId;
    }

    public String getSourceRepoId() {
        return this.sourceRepoId;
    }

    public String getTargetRepoId() {
        return this.targetRepoId;
    }

    public List<String> getWhiteListPatterns() {
        if (this.whiteListPatterns == null) {
            this.whiteListPatterns = new ArrayList<String>();
        }
        return this.whiteListPatterns;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void removeBlackListPattern(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("AbstractRepositoryConnectorConfiguration.removeBlackListPatterns(string) parameter must be instanceof " + String.class.getName());
        }
        this.getBlackListPatterns().remove(string);
    }

    public void removeWhiteListPattern(String string) {
        if (!(string instanceof String)) {
            throw new ClassCastException("AbstractRepositoryConnectorConfiguration.removeWhiteListPatterns(string) parameter must be instanceof " + String.class.getName());
        }
        this.getWhiteListPatterns().remove(string);
    }

    public void setBlackListPatterns(List<String> blackListPatterns) {
        this.blackListPatterns = blackListPatterns;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public void setPolicies(Map policies) {
        this.policies = policies;
    }

    public void setProperties(Map properties) {
        this.properties = properties;
    }

    public void setProxyId(String proxyId) {
        this.proxyId = proxyId;
    }

    public void setSourceRepoId(String sourceRepoId) {
        this.sourceRepoId = sourceRepoId;
    }

    public void setTargetRepoId(String targetRepoId) {
        this.targetRepoId = targetRepoId;
    }

    public void setWhiteListPatterns(List<String> whiteListPatterns) {
        this.whiteListPatterns = whiteListPatterns;
    }

    public String getPolicy(String policyId, String defaultValue) {
        if (this.getPolicies() == null) {
            return null;
        }
        Object value = this.getPolicies().get(policyId);
        if (value == null) {
            return defaultValue;
        }
        return (String)value;
    }
}

