/*
 * $Id$
 */

package org.apache.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class V1RepositoryConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class V1RepositoryConfiguration
    extends ManagedRepositoryConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The URL for this repository.
     *           
     */
    private String url;

    /**
     * Field indexed.
     */
    private boolean indexed = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The URL for this repository.
     *           
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Get the indexed field.
     * 
     * @return boolean
     */
    public boolean isIndexed()
    {
        return this.indexed;
    } //-- boolean isIndexed()

    /**
     * Set the indexed field.
     * 
     * @param indexed
     */
    public void setIndexed( boolean indexed )
    {
        this.indexed = indexed;
    } //-- void setIndexed( boolean )

    /**
     * Set 
     *             The URL for this repository.
     *           
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )


}
