/*
 * $Id$
 */

package org.apache.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class RemoteRepositoryConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class RemoteRepositoryConfiguration
    extends AbstractRepositoryConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The URL for this repository.
     *           
     */
    private String url;

    /**
     * 
     *             The Username for this repository.
     *           
     */
    private String username;

    /**
     * 
     *             The Password for this repository.
     *           
     */
    private String password;

    /**
     * 
     *             Timeout in seconds for connections to this
     * repository
     *           .
     */
    private int timeout = 60;

    /**
     * 
     *             When to run the refresh task.
     *             Default is every sunday at 8H00.
     *           
     */
    private String refreshCronExpression = "0 0 08 ? * SUN";

    /**
     * 
     *             Activate download of remote index if
     * remoteIndexUrl is set too.
     *           
     */
    private boolean downloadRemoteIndex = false;

    /**
     * 
     *             Remote Index Url : if not starting with http
     * will be relative to the remote repository url.
     *           
     */
    private String remoteIndexUrl;

    /**
     * 
     *             Id of the networkProxy to use when downloading
     * remote index.
     *           
     */
    private String remoteDownloadNetworkProxyId;

    /**
     * 
     *             Timeout in seconds for download remote index.
     * Default is more long than artifact download.
     *           
     */
    private int remoteDownloadTimeout = 300;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The Password for this repository.
     *           
     * 
     * @return String
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword()

    /**
     * Get 
     *             When to run the refresh task.
     *             Default is every sunday at 8H00.
     *           
     * 
     * @return String
     */
    public String getRefreshCronExpression()
    {
        return this.refreshCronExpression;
    } //-- String getRefreshCronExpression()

    /**
     * Get 
     *             Id of the networkProxy to use when downloading
     * remote index.
     *           
     * 
     * @return String
     */
    public String getRemoteDownloadNetworkProxyId()
    {
        return this.remoteDownloadNetworkProxyId;
    } //-- String getRemoteDownloadNetworkProxyId()

    /**
     * Get 
     *             Timeout in seconds for download remote index.
     * Default is more long than artifact download.
     *           
     * 
     * @return int
     */
    public int getRemoteDownloadTimeout()
    {
        return this.remoteDownloadTimeout;
    } //-- int getRemoteDownloadTimeout()

    /**
     * Get 
     *             Remote Index Url : if not starting with http
     * will be relative to the remote repository url.
     *           
     * 
     * @return String
     */
    public String getRemoteIndexUrl()
    {
        return this.remoteIndexUrl;
    } //-- String getRemoteIndexUrl()

    /**
     * Get 
     *             Timeout in seconds for connections to this
     * repository
     *           .
     * 
     * @return int
     */
    public int getTimeout()
    {
        return this.timeout;
    } //-- int getTimeout()

    /**
     * Get 
     *             The URL for this repository.
     *           
     * 
     * @return String
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl()

    /**
     * Get 
     *             The Username for this repository.
     *           
     * 
     * @return String
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername()

    /**
     * Get 
     *             Activate download of remote index if
     * remoteIndexUrl is set too.
     *           
     * 
     * @return boolean
     */
    public boolean isDownloadRemoteIndex()
    {
        return this.downloadRemoteIndex;
    } //-- boolean isDownloadRemoteIndex()

    /**
     * Set 
     *             Activate download of remote index if
     * remoteIndexUrl is set too.
     *           
     * 
     * @param downloadRemoteIndex
     */
    public void setDownloadRemoteIndex( boolean downloadRemoteIndex )
    {
        this.downloadRemoteIndex = downloadRemoteIndex;
    } //-- void setDownloadRemoteIndex( boolean )

    /**
     * Set 
     *             The Password for this repository.
     *           
     * 
     * @param password
     */
    public void setPassword( String password )
    {
        this.password = password;
    } //-- void setPassword( String )

    /**
     * Set 
     *             When to run the refresh task.
     *             Default is every sunday at 8H00.
     *           
     * 
     * @param refreshCronExpression
     */
    public void setRefreshCronExpression( String refreshCronExpression )
    {
        this.refreshCronExpression = refreshCronExpression;
    } //-- void setRefreshCronExpression( String )

    /**
     * Set 
     *             Id of the networkProxy to use when downloading
     * remote index.
     *           
     * 
     * @param remoteDownloadNetworkProxyId
     */
    public void setRemoteDownloadNetworkProxyId( String remoteDownloadNetworkProxyId )
    {
        this.remoteDownloadNetworkProxyId = remoteDownloadNetworkProxyId;
    } //-- void setRemoteDownloadNetworkProxyId( String )

    /**
     * Set 
     *             Timeout in seconds for download remote index.
     * Default is more long than artifact download.
     *           
     * 
     * @param remoteDownloadTimeout
     */
    public void setRemoteDownloadTimeout( int remoteDownloadTimeout )
    {
        this.remoteDownloadTimeout = remoteDownloadTimeout;
    } //-- void setRemoteDownloadTimeout( int )

    /**
     * Set 
     *             Remote Index Url : if not starting with http
     * will be relative to the remote repository url.
     *           
     * 
     * @param remoteIndexUrl
     */
    public void setRemoteIndexUrl( String remoteIndexUrl )
    {
        this.remoteIndexUrl = remoteIndexUrl;
    } //-- void setRemoteIndexUrl( String )

    /**
     * Set 
     *             Timeout in seconds for connections to this
     * repository
     *           .
     * 
     * @param timeout
     */
    public void setTimeout( int timeout )
    {
        this.timeout = timeout;
    } //-- void setTimeout( int )

    /**
     * Set 
     *             The URL for this repository.
     *           
     * 
     * @param url
     */
    public void setUrl( String url )
    {
        this.url = url;
    } //-- void setUrl( String )

    /**
     * Set 
     *             The Username for this repository.
     *           
     * 
     * @param username
     */
    public void setUsername( String username )
    {
        this.username = username;
    } //-- void setUsername( String )


            public String toString()
            {
                return "RemoteRepositoryConfiguration id:'" + getId() + "',name:'" + getName() +"'";
            }


       
}
