/*
 * $Id$
 */

package org.apache.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class Configuration.
 * 
 * @version $Revision$ $Date$
 */
public class Configuration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * This is the version of the configuration format.
     */
    private String version;

    /**
     * Field repositories.
     */
    private java.util.List<V1RepositoryConfiguration> repositories;

    /**
     * Field repositoryGroups.
     */
    private java.util.List<RepositoryGroupConfiguration> repositoryGroups;

    /**
     * Field managedRepositories.
     */
    private java.util.List<ManagedRepositoryConfiguration> managedRepositories;

    /**
     * Field remoteRepositories.
     */
    private java.util.List<RemoteRepositoryConfiguration> remoteRepositories;

    /**
     * Field proxyConnectors.
     */
    private java.util.List<ProxyConnectorConfiguration> proxyConnectors;

    /**
     * Field networkProxies.
     */
    private java.util.List<NetworkProxyConfiguration> networkProxies;

    /**
     * Field legacyArtifactPaths.
     */
    private java.util.List<LegacyArtifactPath> legacyArtifactPaths;

    /**
     * 
     *             The repository scanning configuration.
     *           
     */
    private RepositoryScanningConfiguration repositoryScanning;

    /**
     * 
     *             The webapp configuration.
     *           
     */
    private WebappConfiguration webapp;

    /**
     * 
     *             The organisation info.
     *           
     */
    private OrganisationInformation organisationInfo;

    /**
     * 
     *             The NetworkConfiguration .
     *           
     */
    private NetworkConfiguration networkConfiguration;

    /**
     * Field modelEncoding.
     */
    private String modelEncoding = "UTF-8";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addLegacyArtifactPath.
     * 
     * @param legacyArtifactPath
     */
    public void addLegacyArtifactPath( LegacyArtifactPath legacyArtifactPath )
    {
        if ( !(legacyArtifactPath instanceof LegacyArtifactPath) )
        {
            throw new ClassCastException( "Configuration.addLegacyArtifactPaths(legacyArtifactPath) parameter must be instanceof " + LegacyArtifactPath.class.getName() );
        }
        getLegacyArtifactPaths().add( legacyArtifactPath );
    } //-- void addLegacyArtifactPath( LegacyArtifactPath )

    /**
     * Method addManagedRepository.
     * 
     * @param managedRepositoryConfiguration
     */
    public void addManagedRepository( ManagedRepositoryConfiguration managedRepositoryConfiguration )
    {
        if ( !(managedRepositoryConfiguration instanceof ManagedRepositoryConfiguration) )
        {
            throw new ClassCastException( "Configuration.addManagedRepositories(managedRepositoryConfiguration) parameter must be instanceof " + ManagedRepositoryConfiguration.class.getName() );
        }
        getManagedRepositories().add( managedRepositoryConfiguration );
    } //-- void addManagedRepository( ManagedRepositoryConfiguration )

    /**
     * Method addNetworkProxy.
     * 
     * @param networkProxyConfiguration
     */
    public void addNetworkProxy( NetworkProxyConfiguration networkProxyConfiguration )
    {
        if ( !(networkProxyConfiguration instanceof NetworkProxyConfiguration) )
        {
            throw new ClassCastException( "Configuration.addNetworkProxies(networkProxyConfiguration) parameter must be instanceof " + NetworkProxyConfiguration.class.getName() );
        }
        getNetworkProxies().add( networkProxyConfiguration );
    } //-- void addNetworkProxy( NetworkProxyConfiguration )

    /**
     * Method addProxyConnector.
     * 
     * @param proxyConnectorConfiguration
     */
    public void addProxyConnector( ProxyConnectorConfiguration proxyConnectorConfiguration )
    {
        if ( !(proxyConnectorConfiguration instanceof ProxyConnectorConfiguration) )
        {
            throw new ClassCastException( "Configuration.addProxyConnectors(proxyConnectorConfiguration) parameter must be instanceof " + ProxyConnectorConfiguration.class.getName() );
        }
        getProxyConnectors().add( proxyConnectorConfiguration );
    } //-- void addProxyConnector( ProxyConnectorConfiguration )

    /**
     * Method addRemoteRepository.
     * 
     * @param remoteRepositoryConfiguration
     */
    public void addRemoteRepository( RemoteRepositoryConfiguration remoteRepositoryConfiguration )
    {
        if ( !(remoteRepositoryConfiguration instanceof RemoteRepositoryConfiguration) )
        {
            throw new ClassCastException( "Configuration.addRemoteRepositories(remoteRepositoryConfiguration) parameter must be instanceof " + RemoteRepositoryConfiguration.class.getName() );
        }
        getRemoteRepositories().add( remoteRepositoryConfiguration );
    } //-- void addRemoteRepository( RemoteRepositoryConfiguration )

    /**
     * Method addRepositoryGroup.
     * 
     * @param repositoryGroupConfiguration
     */
    public void addRepositoryGroup( RepositoryGroupConfiguration repositoryGroupConfiguration )
    {
        if ( !(repositoryGroupConfiguration instanceof RepositoryGroupConfiguration) )
        {
            throw new ClassCastException( "Configuration.addRepositoryGroups(repositoryGroupConfiguration) parameter must be instanceof " + RepositoryGroupConfiguration.class.getName() );
        }
        getRepositoryGroups().add( repositoryGroupConfiguration );
    } //-- void addRepositoryGroup( RepositoryGroupConfiguration )

    /**
     * Method getLegacyArtifactPaths.
     * 
     * @return List
     */
    public java.util.List<LegacyArtifactPath> getLegacyArtifactPaths()
    {
        if ( this.legacyArtifactPaths == null )
        {
            this.legacyArtifactPaths = new java.util.ArrayList<LegacyArtifactPath>();
        }

        return this.legacyArtifactPaths;
    } //-- java.util.List<LegacyArtifactPath> getLegacyArtifactPaths()

    /**
     * Method getManagedRepositories.
     * 
     * @return List
     */
    public java.util.List<ManagedRepositoryConfiguration> getManagedRepositories()
    {
        if ( this.managedRepositories == null )
        {
            this.managedRepositories = new java.util.ArrayList<ManagedRepositoryConfiguration>();
        }

        return this.managedRepositories;
    } //-- java.util.List<ManagedRepositoryConfiguration> getManagedRepositories()

    /**
     * Method getModelEncoding.
     * 
     * @return the current encoding used when reading/writing this
     * model
     */
    public String getModelEncoding()
    {
        return modelEncoding;
    } //-- String getModelEncoding()

    /**
     * Get 
     *             The NetworkConfiguration .
     *           
     * 
     * @return NetworkConfiguration
     */
    public NetworkConfiguration getNetworkConfiguration()
    {
        return this.networkConfiguration;
    } //-- NetworkConfiguration getNetworkConfiguration()

    /**
     * Method getNetworkProxies.
     * 
     * @return List
     */
    public java.util.List<NetworkProxyConfiguration> getNetworkProxies()
    {
        if ( this.networkProxies == null )
        {
            this.networkProxies = new java.util.ArrayList<NetworkProxyConfiguration>();
        }

        return this.networkProxies;
    } //-- java.util.List<NetworkProxyConfiguration> getNetworkProxies()

    /**
     * Get 
     *             The organisation info.
     *           
     * 
     * @return OrganisationInformation
     */
    public OrganisationInformation getOrganisationInfo()
    {
        return this.organisationInfo;
    } //-- OrganisationInformation getOrganisationInfo()

    /**
     * Method getProxyConnectors.
     * 
     * @return List
     */
    public java.util.List<ProxyConnectorConfiguration> getProxyConnectors()
    {
        if ( this.proxyConnectors == null )
        {
            this.proxyConnectors = new java.util.ArrayList<ProxyConnectorConfiguration>();
        }

        return this.proxyConnectors;
    } //-- java.util.List<ProxyConnectorConfiguration> getProxyConnectors()

    /**
     * Method getRemoteRepositories.
     * 
     * @return List
     */
    public java.util.List<RemoteRepositoryConfiguration> getRemoteRepositories()
    {
        if ( this.remoteRepositories == null )
        {
            this.remoteRepositories = new java.util.ArrayList<RemoteRepositoryConfiguration>();
        }

        return this.remoteRepositories;
    } //-- java.util.List<RemoteRepositoryConfiguration> getRemoteRepositories()

    /**
     * Method getRepositories.
     * 
     * @return List
     */
    public java.util.List<V1RepositoryConfiguration> getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList<V1RepositoryConfiguration>();
        }

        return this.repositories;
    } //-- java.util.List<V1RepositoryConfiguration> getRepositories()

    /**
     * Method getRepositoryGroups.
     * 
     * @return List
     */
    public java.util.List<RepositoryGroupConfiguration> getRepositoryGroups()
    {
        if ( this.repositoryGroups == null )
        {
            this.repositoryGroups = new java.util.ArrayList<RepositoryGroupConfiguration>();
        }

        return this.repositoryGroups;
    } //-- java.util.List<RepositoryGroupConfiguration> getRepositoryGroups()

    /**
     * Get 
     *             The repository scanning configuration.
     *           
     * 
     * @return RepositoryScanningConfiguration
     */
    public RepositoryScanningConfiguration getRepositoryScanning()
    {
        return this.repositoryScanning;
    } //-- RepositoryScanningConfiguration getRepositoryScanning()

    /**
     * Get this is the version of the configuration format.
     * 
     * @return String
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion()

    /**
     * Get 
     *             The webapp configuration.
     *           
     * 
     * @return WebappConfiguration
     */
    public WebappConfiguration getWebapp()
    {
        return this.webapp;
    } //-- WebappConfiguration getWebapp()

    /**
     * Method removeLegacyArtifactPath.
     * 
     * @param legacyArtifactPath
     */
    public void removeLegacyArtifactPath( LegacyArtifactPath legacyArtifactPath )
    {
        if ( !(legacyArtifactPath instanceof LegacyArtifactPath) )
        {
            throw new ClassCastException( "Configuration.removeLegacyArtifactPaths(legacyArtifactPath) parameter must be instanceof " + LegacyArtifactPath.class.getName() );
        }
        getLegacyArtifactPaths().remove( legacyArtifactPath );
    } //-- void removeLegacyArtifactPath( LegacyArtifactPath )

    /**
     * Method removeManagedRepository.
     * 
     * @param managedRepositoryConfiguration
     */
    public void removeManagedRepository( ManagedRepositoryConfiguration managedRepositoryConfiguration )
    {
        if ( !(managedRepositoryConfiguration instanceof ManagedRepositoryConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeManagedRepositories(managedRepositoryConfiguration) parameter must be instanceof " + ManagedRepositoryConfiguration.class.getName() );
        }
        getManagedRepositories().remove( managedRepositoryConfiguration );
    } //-- void removeManagedRepository( ManagedRepositoryConfiguration )

    /**
     * Method removeNetworkProxy.
     * 
     * @param networkProxyConfiguration
     */
    public void removeNetworkProxy( NetworkProxyConfiguration networkProxyConfiguration )
    {
        if ( !(networkProxyConfiguration instanceof NetworkProxyConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeNetworkProxies(networkProxyConfiguration) parameter must be instanceof " + NetworkProxyConfiguration.class.getName() );
        }
        getNetworkProxies().remove( networkProxyConfiguration );
    } //-- void removeNetworkProxy( NetworkProxyConfiguration )

    /**
     * Method removeProxyConnector.
     * 
     * @param proxyConnectorConfiguration
     */
    public void removeProxyConnector( ProxyConnectorConfiguration proxyConnectorConfiguration )
    {
        if ( !(proxyConnectorConfiguration instanceof ProxyConnectorConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeProxyConnectors(proxyConnectorConfiguration) parameter must be instanceof " + ProxyConnectorConfiguration.class.getName() );
        }
        getProxyConnectors().remove( proxyConnectorConfiguration );
    } //-- void removeProxyConnector( ProxyConnectorConfiguration )

    /**
     * Method removeRemoteRepository.
     * 
     * @param remoteRepositoryConfiguration
     */
    public void removeRemoteRepository( RemoteRepositoryConfiguration remoteRepositoryConfiguration )
    {
        if ( !(remoteRepositoryConfiguration instanceof RemoteRepositoryConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeRemoteRepositories(remoteRepositoryConfiguration) parameter must be instanceof " + RemoteRepositoryConfiguration.class.getName() );
        }
        getRemoteRepositories().remove( remoteRepositoryConfiguration );
    } //-- void removeRemoteRepository( RemoteRepositoryConfiguration )

    /**
     * Method removeRepositoryGroup.
     * 
     * @param repositoryGroupConfiguration
     */
    public void removeRepositoryGroup( RepositoryGroupConfiguration repositoryGroupConfiguration )
    {
        if ( !(repositoryGroupConfiguration instanceof RepositoryGroupConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeRepositoryGroups(repositoryGroupConfiguration) parameter must be instanceof " + RepositoryGroupConfiguration.class.getName() );
        }
        getRepositoryGroups().remove( repositoryGroupConfiguration );
    } //-- void removeRepositoryGroup( RepositoryGroupConfiguration )

    /**
     * Set 
     *             The list of custom legacy path to artifact.
     *           
     * 
     * @param legacyArtifactPaths
     */
    public void setLegacyArtifactPaths( java.util.List<LegacyArtifactPath> legacyArtifactPaths )
    {
        this.legacyArtifactPaths = legacyArtifactPaths;
    } //-- void setLegacyArtifactPaths( java.util.List )

    /**
     * Set the list of repositories that this archiva instance
     * uses.
     * 
     * @param managedRepositories
     */
    public void setManagedRepositories( java.util.List<ManagedRepositoryConfiguration> managedRepositories )
    {
        this.managedRepositories = managedRepositories;
    } //-- void setManagedRepositories( java.util.List )

    /**
     * Set an encoding used for reading/writing the model.
     * 
     * @param modelEncoding
     */
    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    } //-- void setModelEncoding( String )

    /**
     * Set 
     *             The NetworkConfiguration .
     *           
     * 
     * @param networkConfiguration
     */
    public void setNetworkConfiguration( NetworkConfiguration networkConfiguration )
    {
        this.networkConfiguration = networkConfiguration;
    } //-- void setNetworkConfiguration( NetworkConfiguration )

    /**
     * Set 
     *             The list of network proxies to use for outgoing
     * requests.
     *           
     * 
     * @param networkProxies
     */
    public void setNetworkProxies( java.util.List<NetworkProxyConfiguration> networkProxies )
    {
        this.networkProxies = networkProxies;
    } //-- void setNetworkProxies( java.util.List )

    /**
     * Set 
     *             The organisation info.
     *           
     * 
     * @param organisationInfo
     */
    public void setOrganisationInfo( OrganisationInformation organisationInfo )
    {
        this.organisationInfo = organisationInfo;
    } //-- void setOrganisationInfo( OrganisationInformation )

    /**
     * Set the list of proxy connectors for this archiva instance.
     * 
     * @param proxyConnectors
     */
    public void setProxyConnectors( java.util.List<ProxyConnectorConfiguration> proxyConnectors )
    {
        this.proxyConnectors = proxyConnectors;
    } //-- void setProxyConnectors( java.util.List )

    /**
     * Set the list of repositories that this archiva can retrieve
     * from or publish to.
     * 
     * @param remoteRepositories
     */
    public void setRemoteRepositories( java.util.List<RemoteRepositoryConfiguration> remoteRepositories )
    {
        this.remoteRepositories = remoteRepositories;
    } //-- void setRemoteRepositories( java.util.List )

    /**
     * Set 
     *  @deprecated use managedRepositories or remoteRepositories
     * instead.
     *           
     * 
     * @param repositories
     */
    public void setRepositories( java.util.List<V1RepositoryConfiguration> repositories )
    {
        this.repositories = repositories;
    } //-- void setRepositories( java.util.List )

    /**
     * Set the list of repository groups.
     * 
     * @param repositoryGroups
     */
    public void setRepositoryGroups( java.util.List<RepositoryGroupConfiguration> repositoryGroups )
    {
        this.repositoryGroups = repositoryGroups;
    } //-- void setRepositoryGroups( java.util.List )

    /**
     * Set 
     *             The repository scanning configuration.
     *           
     * 
     * @param repositoryScanning
     */
    public void setRepositoryScanning( RepositoryScanningConfiguration repositoryScanning )
    {
        this.repositoryScanning = repositoryScanning;
    } //-- void setRepositoryScanning( RepositoryScanningConfiguration )

    /**
     * Set this is the version of the configuration format.
     * 
     * @param version
     */
    public void setVersion( String version )
    {
        this.version = version;
    } //-- void setVersion( String )

    /**
     * Set 
     *             The webapp configuration.
     *           
     * 
     * @param webapp
     */
    public void setWebapp( WebappConfiguration webapp )
    {
        this.webapp = webapp;
    } //-- void setWebapp( WebappConfiguration )


    private java.util.Map<String, java.util.List<String>> repositoryToGroupMap; 
    
    public java.util.Map<String, java.util.List<String>> getRepositoryToGroupMap()
    {
        if ( repositoryGroups != null )
        {
            java.util.Map<String, java.util.List<String>> map = new java.util.HashMap<String, java.util.List<String>>();
            
            for ( RepositoryGroupConfiguration group : (java.util.List<RepositoryGroupConfiguration>) repositoryGroups )
            {
                for ( String repositoryId : (java.util.List<String>) group.getRepositories() )
                {
                    java.util.List<String> groups = map.get( repositoryId );
                    if ( groups == null )
                    {
                        groups = new java.util.ArrayList<String>();
                        map.put( repositoryId, groups );
                    }
                    groups.add( group.getId() );
                }
            }
            
            repositoryToGroupMap = map;
        }
        return repositoryToGroupMap;
    }
    
    public java.util.Map<String, RepositoryGroupConfiguration> getRepositoryGroupsAsMap()
    {
        java.util.Map<String, RepositoryGroupConfiguration> map = new java.util.HashMap<String, RepositoryGroupConfiguration>();
        if ( repositoryGroups != null )
        {
            for ( RepositoryGroupConfiguration group : (java.util.List<RepositoryGroupConfiguration>) repositoryGroups )
            {
                map.put( group.getId(), group );
            }
        }
        return map;
    }
    
    public RepositoryGroupConfiguration findRepositoryGroupById( String id )
    {
        if ( repositoryGroups != null )
        {
            for ( RepositoryGroupConfiguration group : (java.util.List<RepositoryGroupConfiguration>) repositoryGroups )
            {
                if ( group.getId().equals( id ) )
                {
                    return group;
                }
            }
        }
        return null;
    }

    private java.util.Map<String, java.util.List<String>> groupToRepositoryMap;
    	
    public java.util.Map<String, java.util.List<String>> getGroupToRepositoryMap()
    {
    	if ( repositoryGroups != null && managedRepositories != null )
        {
            java.util.Map<String, java.util.List<String>> map = new java.util.HashMap<String, java.util.List<String>>();
            
            for ( ManagedRepositoryConfiguration repo : (java.util.List<ManagedRepositoryConfiguration>) managedRepositories )
            {
                for ( RepositoryGroupConfiguration group : (java.util.List<RepositoryGroupConfiguration>) repositoryGroups )
                {
                    if ( !group.getRepositories().contains( repo.getId() ) )
                    {
                        String groupId = group.getId();
                        java.util.List<String> repos = map.get( groupId );
                        if ( repos == null )
                        {
                            repos = new java.util.ArrayList<String>();
                            map.put( groupId, repos );
                        }
                        repos.add( repo.getId() );
                    }
                }
            }
            groupToRepositoryMap = map;
        }
        return groupToRepositoryMap;
    }
          
    public java.util.Map<String, NetworkProxyConfiguration> getNetworkProxiesAsMap()
    {
        java.util.Map<String, NetworkProxyConfiguration> map = new java.util.HashMap<String, NetworkProxyConfiguration>();
        if ( networkProxies != null )
        {
            for ( java.util.Iterator<NetworkProxyConfiguration> i = networkProxies.iterator(); i.hasNext(); )
            {
                NetworkProxyConfiguration proxy = i.next();
                map.put( proxy.getId(), proxy );
            }
        }
        return map;
    }

    public java.util.Map<String, java.util.List<ProxyConnectorConfiguration>> getProxyConnectorAsMap()
    {
        java.util.Map<String, java.util.List<ProxyConnectorConfiguration>> proxyConnectorMap =
            new java.util.HashMap<String, java.util.List<ProxyConnectorConfiguration>>();

        if( proxyConnectors != null )
        {
            java.util.Iterator<ProxyConnectorConfiguration> it = proxyConnectors.iterator();
            while ( it.hasNext() )
            {
                ProxyConnectorConfiguration proxyConfig = it.next();
                String key = proxyConfig.getSourceRepoId();

                java.util.List<ProxyConnectorConfiguration> connectors = proxyConnectorMap.get( key );
                if ( connectors == null )
                {
                    connectors = new java.util.ArrayList<ProxyConnectorConfiguration>();
                    proxyConnectorMap.put( key, connectors );
                }

                connectors.add( proxyConfig );
                java.util.Collections.sort( connectors,
                    org.apache.archiva.configuration.functors.ProxyConnectorConfigurationOrderComparator.getInstance() );
            }
        }

        return proxyConnectorMap;
    }

    public java.util.Map<String, RemoteRepositoryConfiguration> getRemoteRepositoriesAsMap()
    {
        java.util.Map<String, RemoteRepositoryConfiguration> map = new java.util.HashMap<String, RemoteRepositoryConfiguration>();
        if ( remoteRepositories != null )
        {
            for ( java.util.Iterator<RemoteRepositoryConfiguration> i = remoteRepositories.iterator(); i.hasNext(); )
            {
                RemoteRepositoryConfiguration repo = i.next();
                map.put( repo.getId(), repo );
            }
        }
        return map;
    }

    public RemoteRepositoryConfiguration findRemoteRepositoryById( String id )
    {
        if ( remoteRepositories != null )
        {
            for ( java.util.Iterator<RemoteRepositoryConfiguration> i = remoteRepositories.iterator(); i.hasNext(); )
            {
                RemoteRepositoryConfiguration repo = i.next();
                if ( repo.getId().equals( id ) )
                {
                    return repo;
                }
            }
        }
        return null;
    }

    public java.util.Map<String, ManagedRepositoryConfiguration> getManagedRepositoriesAsMap()
    {
        java.util.Map<String, ManagedRepositoryConfiguration> map = new java.util.HashMap<String, ManagedRepositoryConfiguration>();
        if ( managedRepositories != null )
        {
            for ( java.util.Iterator<ManagedRepositoryConfiguration> i = managedRepositories.iterator(); i.hasNext(); )
            {
                ManagedRepositoryConfiguration repo = i.next();
                map.put( repo.getId(), repo );
            }
        }
        return map;
    }

    public ManagedRepositoryConfiguration findManagedRepositoryById( String id )
    {
        if ( managedRepositories != null )
        {
            for ( java.util.Iterator<ManagedRepositoryConfiguration> i = managedRepositories.iterator(); i.hasNext(); )
            {
                ManagedRepositoryConfiguration repo = i.next();
                if ( repo.getId().equals( id ) )
                {
                    return repo;
                }
            }
        }
        return null;
    }
          
}
