package org.apache.maven.archiva.configuration.io.registry;

import org.codehaus.plexus.registry.Registry;

// Util imports
import java.util.*;

// Model class imports
import org.apache.maven.archiva.configuration.Configuration;
import org.apache.maven.archiva.configuration.AbstractRepositoryConfiguration;
import org.apache.maven.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.configuration.V1RepositoryConfiguration;
import org.apache.maven.archiva.configuration.LegacyArtifactPath;
import org.apache.maven.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.maven.archiva.configuration.AbstractRepositoryConnectorConfiguration;
import org.apache.maven.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.maven.archiva.configuration.SyncConnectorConfiguration;
import org.apache.maven.archiva.configuration.NetworkProxyConfiguration;
import org.apache.maven.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.maven.archiva.configuration.FileType;
import org.apache.maven.archiva.configuration.DatabaseScanningConfiguration;
import org.apache.maven.archiva.configuration.OrganisationInformation;
import org.apache.maven.archiva.configuration.WebappConfiguration;
import org.apache.maven.archiva.configuration.UserInterfaceOptions;




/**
 * Generate Plexus Registry output mechanism for model 'Configuration'.
 */
public class ConfigurationRegistryWriter
{
    public void write( Configuration model, Registry registry )
    {
        writeConfiguration( "", model, registry );
    }

    private void writeConfiguration( String prefix, Configuration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getVersion() != null
 )
            {
                String name = "version";
                registry.setString( prefix + name, value.getVersion() );
            }
            if ( value.getRepositories() != null && value.getRepositories().size() > 0
 )
            {
                registry.removeSubset( prefix + "repositories" );

                int count = 0;
                for ( Iterator iter = value.getRepositories().iterator(); iter.hasNext(); count++ )
                {
                    String name = "repositories.repository(" + count + ")";
                    V1RepositoryConfiguration o = ( V1RepositoryConfiguration ) iter.next();
                    writeV1RepositoryConfiguration( prefix + name + ".", o, registry );
                }
            }
            if ( value.getRepositoryGroups() != null && value.getRepositoryGroups().size() > 0
 )
            {
                registry.removeSubset( prefix + "repositoryGroups" );

                int count = 0;
                for ( Iterator iter = value.getRepositoryGroups().iterator(); iter.hasNext(); count++ )
                {
                    String name = "repositoryGroups.repositoryGroup(" + count + ")";
                    RepositoryGroupConfiguration o = ( RepositoryGroupConfiguration ) iter.next();
                    writeRepositoryGroupConfiguration( prefix + name + ".", o, registry );
                }
            }
            if ( value.getManagedRepositories() != null && value.getManagedRepositories().size() > 0
 )
            {
                registry.removeSubset( prefix + "managedRepositories" );

                int count = 0;
                for ( Iterator iter = value.getManagedRepositories().iterator(); iter.hasNext(); count++ )
                {
                    String name = "managedRepositories.managedRepository(" + count + ")";
                    ManagedRepositoryConfiguration o = ( ManagedRepositoryConfiguration ) iter.next();
                    writeManagedRepositoryConfiguration( prefix + name + ".", o, registry );
                }
            }
            if ( value.getRemoteRepositories() != null && value.getRemoteRepositories().size() > 0
 )
            {
                registry.removeSubset( prefix + "remoteRepositories" );

                int count = 0;
                for ( Iterator iter = value.getRemoteRepositories().iterator(); iter.hasNext(); count++ )
                {
                    String name = "remoteRepositories.remoteRepository(" + count + ")";
                    RemoteRepositoryConfiguration o = ( RemoteRepositoryConfiguration ) iter.next();
                    writeRemoteRepositoryConfiguration( prefix + name + ".", o, registry );
                }
            }
            if ( value.getProxyConnectors() != null && value.getProxyConnectors().size() > 0
 )
            {
                registry.removeSubset( prefix + "proxyConnectors" );

                int count = 0;
                for ( Iterator iter = value.getProxyConnectors().iterator(); iter.hasNext(); count++ )
                {
                    String name = "proxyConnectors.proxyConnector(" + count + ")";
                    ProxyConnectorConfiguration o = ( ProxyConnectorConfiguration ) iter.next();
                    writeProxyConnectorConfiguration( prefix + name + ".", o, registry );
                }
            }
            if ( value.getNetworkProxies() != null && value.getNetworkProxies().size() > 0
 )
            {
                registry.removeSubset( prefix + "networkProxies" );

                int count = 0;
                for ( Iterator iter = value.getNetworkProxies().iterator(); iter.hasNext(); count++ )
                {
                    String name = "networkProxies.networkProxy(" + count + ")";
                    NetworkProxyConfiguration o = ( NetworkProxyConfiguration ) iter.next();
                    writeNetworkProxyConfiguration( prefix + name + ".", o, registry );
                }
            }
            if ( value.getLegacyArtifactPaths() != null && value.getLegacyArtifactPaths().size() > 0
 )
            {
                registry.removeSubset( prefix + "legacyArtifactPaths" );

                int count = 0;
                for ( Iterator iter = value.getLegacyArtifactPaths().iterator(); iter.hasNext(); count++ )
                {
                    String name = "legacyArtifactPaths.legacyArtifactPath(" + count + ")";
                    LegacyArtifactPath o = ( LegacyArtifactPath ) iter.next();
                    writeLegacyArtifactPath( prefix + name + ".", o, registry );
                }
            }
            if ( value.getRepositoryScanning() != null
 )
            {
                writeRepositoryScanningConfiguration( prefix + "repositoryScanning.", value.getRepositoryScanning(), registry );
            }
            if ( value.getDatabaseScanning() != null
 )
            {
                writeDatabaseScanningConfiguration( prefix + "databaseScanning.", value.getDatabaseScanning(), registry );
            }
            if ( value.getWebapp() != null
 )
            {
                writeWebappConfiguration( prefix + "webapp.", value.getWebapp(), registry );
            }
            if ( value.getOrganisationInfo() != null
 )
            {
                writeOrganisationInformation( prefix + "organisationInfo.", value.getOrganisationInfo(), registry );
            }
        }
    }
    
    private void writeAbstractRepositoryConfiguration( String prefix, AbstractRepositoryConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getId() != null
 )
            {
                String name = "id";
                registry.setString( prefix + name, value.getId() );
            }
            if ( value.getName() != null
 )
            {
                String name = "name";
                registry.setString( prefix + name, value.getName() );
            }
            if ( value.getLayout() != null && !value.getLayout().equals( "default" )
 )
            {
                String name = "layout";
                registry.setString( prefix + name, value.getLayout() );
            }
        }
    }
    
    private void writeRemoteRepositoryConfiguration( String prefix, RemoteRepositoryConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getUrl() != null
 )
            {
                String name = "url";
                registry.setString( prefix + name, value.getUrl() );
            }
            if ( value.getUsername() != null
 )
            {
                String name = "username";
                registry.setString( prefix + name, value.getUsername() );
            }
            if ( value.getPassword() != null
 )
            {
                String name = "password";
                registry.setString( prefix + name, value.getPassword() );
            }
            if ( value.getTimeout() != 60
 )
            {
                String name = "timeout";
                registry.setInt( prefix + name, value.getTimeout() );
            }
            if ( value.getId() != null
 )
            {
                String name = "id";
                registry.setString( prefix + name, value.getId() );
            }
            if ( value.getName() != null
 )
            {
                String name = "name";
                registry.setString( prefix + name, value.getName() );
            }
            if ( value.getLayout() != null && !value.getLayout().equals( "default" )
 )
            {
                String name = "layout";
                registry.setString( prefix + name, value.getLayout() );
            }
        }
    }
    
    private void writeManagedRepositoryConfiguration( String prefix, ManagedRepositoryConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getLocation() != null
 )
            {
                String name = "location";
                registry.setString( prefix + name, value.getLocation() );
            }
            if ( value.isReleases() != true
 )
            {
                String name = "releases";
                registry.setBoolean( prefix + name, value.isReleases() );
            }
            if ( value.isBlockRedeployments() != false
 )
            {
                String name = "blockRedeployments";
                registry.setBoolean( prefix + name, value.isBlockRedeployments() );
            }
            if ( value.isSnapshots() != false
 )
            {
                String name = "snapshots";
                registry.setBoolean( prefix + name, value.isSnapshots() );
            }
            if ( value.isScanned() != true
 )
            {
                String name = "scanned";
                registry.setBoolean( prefix + name, value.isScanned() );
            }
            if ( value.getIndexDir() != null
 )
            {
                String name = "indexDir";
                registry.setString( prefix + name, value.getIndexDir() );
            }
            if ( value.getRefreshCronExpression() != null && !value.getRefreshCronExpression().equals( "0 0 * * * ?" )
 )
            {
                String name = "refreshCronExpression";
                registry.setString( prefix + name, value.getRefreshCronExpression() );
            }
            if ( value.getRetentionCount() != 2
 )
            {
                String name = "retentionCount";
                registry.setInt( prefix + name, value.getRetentionCount() );
            }
            if ( value.getDaysOlder() != 100
 )
            {
                String name = "daysOlder";
                registry.setInt( prefix + name, value.getDaysOlder() );
            }
            if ( value.isDeleteReleasedSnapshots() != false
 )
            {
                String name = "deleteReleasedSnapshots";
                registry.setBoolean( prefix + name, value.isDeleteReleasedSnapshots() );
            }
            if ( value.getId() != null
 )
            {
                String name = "id";
                registry.setString( prefix + name, value.getId() );
            }
            if ( value.getName() != null
 )
            {
                String name = "name";
                registry.setString( prefix + name, value.getName() );
            }
            if ( value.getLayout() != null && !value.getLayout().equals( "default" )
 )
            {
                String name = "layout";
                registry.setString( prefix + name, value.getLayout() );
            }
        }
    }
    
    private void writeV1RepositoryConfiguration( String prefix, V1RepositoryConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getUrl() != null
 )
            {
                String name = "url";
                registry.setString( prefix + name, value.getUrl() );
            }
            if ( value.isIndexed() != false
 )
            {
                String name = "indexed";
                registry.setBoolean( prefix + name, value.isIndexed() );
            }
            if ( value.getLocation() != null
 )
            {
                String name = "location";
                registry.setString( prefix + name, value.getLocation() );
            }
            if ( value.isReleases() != true
 )
            {
                String name = "releases";
                registry.setBoolean( prefix + name, value.isReleases() );
            }
            if ( value.isBlockRedeployments() != false
 )
            {
                String name = "blockRedeployments";
                registry.setBoolean( prefix + name, value.isBlockRedeployments() );
            }
            if ( value.isSnapshots() != false
 )
            {
                String name = "snapshots";
                registry.setBoolean( prefix + name, value.isSnapshots() );
            }
            if ( value.isScanned() != true
 )
            {
                String name = "scanned";
                registry.setBoolean( prefix + name, value.isScanned() );
            }
            if ( value.getIndexDir() != null
 )
            {
                String name = "indexDir";
                registry.setString( prefix + name, value.getIndexDir() );
            }
            if ( value.getRefreshCronExpression() != null && !value.getRefreshCronExpression().equals( "0 0 * * * ?" )
 )
            {
                String name = "refreshCronExpression";
                registry.setString( prefix + name, value.getRefreshCronExpression() );
            }
            if ( value.getRetentionCount() != 2
 )
            {
                String name = "retentionCount";
                registry.setInt( prefix + name, value.getRetentionCount() );
            }
            if ( value.getDaysOlder() != 100
 )
            {
                String name = "daysOlder";
                registry.setInt( prefix + name, value.getDaysOlder() );
            }
            if ( value.isDeleteReleasedSnapshots() != false
 )
            {
                String name = "deleteReleasedSnapshots";
                registry.setBoolean( prefix + name, value.isDeleteReleasedSnapshots() );
            }
            if ( value.getId() != null
 )
            {
                String name = "id";
                registry.setString( prefix + name, value.getId() );
            }
            if ( value.getName() != null
 )
            {
                String name = "name";
                registry.setString( prefix + name, value.getName() );
            }
            if ( value.getLayout() != null && !value.getLayout().equals( "default" )
 )
            {
                String name = "layout";
                registry.setString( prefix + name, value.getLayout() );
            }
        }
    }
    
    private void writeLegacyArtifactPath( String prefix, LegacyArtifactPath value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getPath() != null
 )
            {
                String name = "path";
                registry.setString( prefix + name, value.getPath() );
            }
            if ( value.getArtifact() != null
 )
            {
                String name = "artifact";
                registry.setString( prefix + name, value.getArtifact() );
            }
        }
    }
    
    private void writeRepositoryGroupConfiguration( String prefix, RepositoryGroupConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getId() != null
 )
            {
                String name = "id";
                registry.setString( prefix + name, value.getId() );
            }
            if ( value.getRepositories() != null && value.getRepositories().size() > 0
 )
            {
                registry.removeSubset( prefix + "repositories" );

                int count = 0;
                for ( Iterator iter = value.getRepositories().iterator(); iter.hasNext(); count++ )
                {
                    String name = "repositories.repository(" + count + ")";
                    String repository = ( String ) iter.next();
                    registry.setString( prefix + name, repository );
                }
            }
        }
    }
    
    private void writeAbstractRepositoryConnectorConfiguration( String prefix, AbstractRepositoryConnectorConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getSourceRepoId() != null
 )
            {
                String name = "sourceRepoId";
                registry.setString( prefix + name, value.getSourceRepoId() );
            }
            if ( value.getTargetRepoId() != null
 )
            {
                String name = "targetRepoId";
                registry.setString( prefix + name, value.getTargetRepoId() );
            }
            if ( value.getProxyId() != null
 )
            {
                String name = "proxyId";
                registry.setString( prefix + name, value.getProxyId() );
            }
            if ( value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0
 )
            {
                registry.removeSubset( prefix + "blackListPatterns" );

                int count = 0;
                for ( Iterator iter = value.getBlackListPatterns().iterator(); iter.hasNext(); count++ )
                {
                    String name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = ( String ) iter.next();
                    registry.setString( prefix + name, blackListPattern );
                }
            }
            if ( value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0
 )
            {
                registry.removeSubset( prefix + "whiteListPatterns" );

                int count = 0;
                for ( Iterator iter = value.getWhiteListPatterns().iterator(); iter.hasNext(); count++ )
                {
                    String name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = ( String ) iter.next();
                    registry.setString( prefix + name, whiteListPattern );
                }
            }
            if ( value.getPolicies() != null && value.getPolicies().size() > 0
 )
            {
                registry.removeSubset( prefix + "policies" );
                
                for ( Iterator iter = value.getPolicies().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String v = (String) value.getPolicies().get( key );

                    registry.setString( prefix + "policies." + key, v );
                }
            }
            if ( value.getProperties() != null && value.getProperties().size() > 0
 )
            {
                registry.removeSubset( prefix + "properties" );
                
                for ( Iterator iter = value.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String v = (String) value.getProperties().get( key );

                    registry.setString( prefix + "properties." + key, v );
                }
            }
            if ( value.isDisabled() != false
 )
            {
                String name = "disabled";
                registry.setBoolean( prefix + name, value.isDisabled() );
            }
        }
    }
    
    private void writeProxyConnectorConfiguration( String prefix, ProxyConnectorConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getOrder() != 0
 )
            {
                String name = "order";
                registry.setInt( prefix + name, value.getOrder() );
            }
            if ( value.getSourceRepoId() != null
 )
            {
                String name = "sourceRepoId";
                registry.setString( prefix + name, value.getSourceRepoId() );
            }
            if ( value.getTargetRepoId() != null
 )
            {
                String name = "targetRepoId";
                registry.setString( prefix + name, value.getTargetRepoId() );
            }
            if ( value.getProxyId() != null
 )
            {
                String name = "proxyId";
                registry.setString( prefix + name, value.getProxyId() );
            }
            if ( value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0
 )
            {
                registry.removeSubset( prefix + "blackListPatterns" );

                int count = 0;
                for ( Iterator iter = value.getBlackListPatterns().iterator(); iter.hasNext(); count++ )
                {
                    String name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = ( String ) iter.next();
                    registry.setString( prefix + name, blackListPattern );
                }
            }
            if ( value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0
 )
            {
                registry.removeSubset( prefix + "whiteListPatterns" );

                int count = 0;
                for ( Iterator iter = value.getWhiteListPatterns().iterator(); iter.hasNext(); count++ )
                {
                    String name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = ( String ) iter.next();
                    registry.setString( prefix + name, whiteListPattern );
                }
            }
            if ( value.getPolicies() != null && value.getPolicies().size() > 0
 )
            {
                registry.removeSubset( prefix + "policies" );
                
                for ( Iterator iter = value.getPolicies().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String v = (String) value.getPolicies().get( key );

                    registry.setString( prefix + "policies." + key, v );
                }
            }
            if ( value.getProperties() != null && value.getProperties().size() > 0
 )
            {
                registry.removeSubset( prefix + "properties" );
                
                for ( Iterator iter = value.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String v = (String) value.getProperties().get( key );

                    registry.setString( prefix + "properties." + key, v );
                }
            }
            if ( value.isDisabled() != false
 )
            {
                String name = "disabled";
                registry.setBoolean( prefix + name, value.isDisabled() );
            }
        }
    }
    
    private void writeSyncConnectorConfiguration( String prefix, SyncConnectorConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getCronExpression() != null && !value.getCronExpression().equals( "0 0 * * * ?" )
 )
            {
                String name = "cronExpression";
                registry.setString( prefix + name, value.getCronExpression() );
            }
            if ( value.getMethod() != null && !value.getMethod().equals( "rsync" )
 )
            {
                String name = "method";
                registry.setString( prefix + name, value.getMethod() );
            }
            if ( value.getSourceRepoId() != null
 )
            {
                String name = "sourceRepoId";
                registry.setString( prefix + name, value.getSourceRepoId() );
            }
            if ( value.getTargetRepoId() != null
 )
            {
                String name = "targetRepoId";
                registry.setString( prefix + name, value.getTargetRepoId() );
            }
            if ( value.getProxyId() != null
 )
            {
                String name = "proxyId";
                registry.setString( prefix + name, value.getProxyId() );
            }
            if ( value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0
 )
            {
                registry.removeSubset( prefix + "blackListPatterns" );

                int count = 0;
                for ( Iterator iter = value.getBlackListPatterns().iterator(); iter.hasNext(); count++ )
                {
                    String name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = ( String ) iter.next();
                    registry.setString( prefix + name, blackListPattern );
                }
            }
            if ( value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0
 )
            {
                registry.removeSubset( prefix + "whiteListPatterns" );

                int count = 0;
                for ( Iterator iter = value.getWhiteListPatterns().iterator(); iter.hasNext(); count++ )
                {
                    String name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = ( String ) iter.next();
                    registry.setString( prefix + name, whiteListPattern );
                }
            }
            if ( value.getPolicies() != null && value.getPolicies().size() > 0
 )
            {
                registry.removeSubset( prefix + "policies" );
                
                for ( Iterator iter = value.getPolicies().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String v = (String) value.getPolicies().get( key );

                    registry.setString( prefix + "policies." + key, v );
                }
            }
            if ( value.getProperties() != null && value.getProperties().size() > 0
 )
            {
                registry.removeSubset( prefix + "properties" );
                
                for ( Iterator iter = value.getProperties().keySet().iterator(); iter.hasNext(); )
                {
                    String key = (String) iter.next();
                    String v = (String) value.getProperties().get( key );

                    registry.setString( prefix + "properties." + key, v );
                }
            }
            if ( value.isDisabled() != false
 )
            {
                String name = "disabled";
                registry.setBoolean( prefix + name, value.isDisabled() );
            }
        }
    }
    
    private void writeNetworkProxyConfiguration( String prefix, NetworkProxyConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getId() != null
 )
            {
                String name = "id";
                registry.setString( prefix + name, value.getId() );
            }
            if ( value.getProtocol() != null && !value.getProtocol().equals( "http" )
 )
            {
                String name = "protocol";
                registry.setString( prefix + name, value.getProtocol() );
            }
            if ( value.getHost() != null
 )
            {
                String name = "host";
                registry.setString( prefix + name, value.getHost() );
            }
            if ( value.getPort() != 8080
 )
            {
                String name = "port";
                registry.setInt( prefix + name, value.getPort() );
            }
            if ( value.getUsername() != null
 )
            {
                String name = "username";
                registry.setString( prefix + name, value.getUsername() );
            }
            if ( value.getPassword() != null
 )
            {
                String name = "password";
                registry.setString( prefix + name, value.getPassword() );
            }
        }
    }
    
    private void writeRepositoryScanningConfiguration( String prefix, RepositoryScanningConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getFileTypes() != null && value.getFileTypes().size() > 0
 )
            {
                registry.removeSubset( prefix + "fileTypes" );

                int count = 0;
                for ( Iterator iter = value.getFileTypes().iterator(); iter.hasNext(); count++ )
                {
                    String name = "fileTypes.fileType(" + count + ")";
                    FileType o = ( FileType ) iter.next();
                    writeFileType( prefix + name + ".", o, registry );
                }
            }
            if ( value.getKnownContentConsumers() != null && value.getKnownContentConsumers().size() > 0
 )
            {
                registry.removeSubset( prefix + "knownContentConsumers" );

                int count = 0;
                for ( Iterator iter = value.getKnownContentConsumers().iterator(); iter.hasNext(); count++ )
                {
                    String name = "knownContentConsumers.knownContentConsumer(" + count + ")";
                    String knownContentConsumer = ( String ) iter.next();
                    registry.setString( prefix + name, knownContentConsumer );
                }
            }
            if ( value.getInvalidContentConsumers() != null && value.getInvalidContentConsumers().size() > 0
 )
            {
                registry.removeSubset( prefix + "invalidContentConsumers" );

                int count = 0;
                for ( Iterator iter = value.getInvalidContentConsumers().iterator(); iter.hasNext(); count++ )
                {
                    String name = "invalidContentConsumers.invalidContentConsumer(" + count + ")";
                    String invalidContentConsumer = ( String ) iter.next();
                    registry.setString( prefix + name, invalidContentConsumer );
                }
            }
        }
    }
    
    private void writeFileType( String prefix, FileType value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getId() != null
 )
            {
                String name = "id";
                registry.setString( prefix + name, value.getId() );
            }
            if ( value.getPatterns() != null && value.getPatterns().size() > 0
 )
            {
                registry.removeSubset( prefix + "patterns" );

                int count = 0;
                for ( Iterator iter = value.getPatterns().iterator(); iter.hasNext(); count++ )
                {
                    String name = "patterns.pattern(" + count + ")";
                    String pattern = ( String ) iter.next();
                    registry.setString( prefix + name, pattern );
                }
            }
        }
    }
    
    private void writeDatabaseScanningConfiguration( String prefix, DatabaseScanningConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getCronExpression() != null && !value.getCronExpression().equals( "0 0 0/2 * * ?" )
 )
            {
                String name = "cronExpression";
                registry.setString( prefix + name, value.getCronExpression() );
            }
            if ( value.getUnprocessedConsumers() != null && value.getUnprocessedConsumers().size() > 0
 )
            {
                registry.removeSubset( prefix + "unprocessedConsumers" );

                int count = 0;
                for ( Iterator iter = value.getUnprocessedConsumers().iterator(); iter.hasNext(); count++ )
                {
                    String name = "unprocessedConsumers.unprocessedConsumer(" + count + ")";
                    String unprocessedConsumer = ( String ) iter.next();
                    registry.setString( prefix + name, unprocessedConsumer );
                }
            }
            if ( value.getCleanupConsumers() != null && value.getCleanupConsumers().size() > 0
 )
            {
                registry.removeSubset( prefix + "cleanupConsumers" );

                int count = 0;
                for ( Iterator iter = value.getCleanupConsumers().iterator(); iter.hasNext(); count++ )
                {
                    String name = "cleanupConsumers.cleanupConsumer(" + count + ")";
                    String cleanupConsumer = ( String ) iter.next();
                    registry.setString( prefix + name, cleanupConsumer );
                }
            }
        }
    }
    
    private void writeOrganisationInformation( String prefix, OrganisationInformation value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getName() != null
 )
            {
                String name = "name";
                registry.setString( prefix + name, value.getName() );
            }
            if ( value.getUrl() != null
 )
            {
                String name = "url";
                registry.setString( prefix + name, value.getUrl() );
            }
            if ( value.getLogoLocation() != null
 )
            {
                String name = "logoLocation";
                registry.setString( prefix + name, value.getLogoLocation() );
            }
        }
    }
    
    private void writeWebappConfiguration( String prefix, WebappConfiguration value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.getUi() != null
 )
            {
                writeUserInterfaceOptions( prefix + "ui.", value.getUi(), registry );
            }
        }
    }
    
    private void writeUserInterfaceOptions( String prefix, UserInterfaceOptions value, Registry registry )
    {
        if ( value != null )
        {
            if ( value.isShowFindArtifacts() != true
 )
            {
                String name = "showFindArtifacts";
                registry.setBoolean( prefix + name, value.isShowFindArtifacts() );
            }
            if ( value.isAppletFindEnabled() != true
 )
            {
                String name = "appletFindEnabled";
                registry.setBoolean( prefix + name, value.isAppletFindEnabled() );
            }
        }
    }
    
}