/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class ManagedRepositoryConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class ManagedRepositoryConfiguration
    extends AbstractRepositoryConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The file system location for this repository.
     *           
     */
    private String location;

    /**
     * True if this repository contains release versioned artifacts.
     */
    private boolean releases = true;

    /**
     * True if re-deployment of artifacts already in the repository
     * will be blocked.
     */
    private boolean blockRedeployments = false;

    /**
     * True if this repository contains snapshot versioned artifacts
     */
    private boolean snapshots = false;

    /**
     * True if this repository should be scanned and processed.
     */
    private boolean scanned = true;

    /**
     * 
     *             The directory for the indexes of this
     * repository.
     *           
     */
    private String indexDir;

    /**
     * 
     *             When to run the refresh task.
     *             Default is every hour
     *           .
     */
    private String refreshCronExpression = "0 0 * * * ?";

    /**
     * 
     *             The total count of the artifact to be retained
     * for each snapshot.
     *           
     */
    private int retentionCount = 2;

    /**
     * 
     *             The number of days old which will be the basis
     * for removing a snapshot.
     *           
     */
    private int daysOlder = 100;

    /**
     * 
     *             True if the released snapshots are to be removed
     * from the repo during repository purge.
     *           
     */
    private boolean deleteReleasedSnapshots = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The number of days old which will be the basis
     * for removing a snapshot.
     *           
     * 
     * @return int
     */
    public int getDaysOlder()
    {
        return this.daysOlder;
    } //-- int getDaysOlder()

    /**
     * Get 
     *             The directory for the indexes of this
     * repository.
     *           
     * 
     * @return String
     */
    public String getIndexDir()
    {
        return this.indexDir;
    } //-- String getIndexDir()

    /**
     * Get 
     *             The file system location for this repository.
     *           
     * 
     * @return String
     */
    public String getLocation()
    {
        return this.location;
    } //-- String getLocation()

    /**
     * Get 
     *             When to run the refresh task.
     *             Default is every hour
     *           .
     * 
     * @return String
     */
    public String getRefreshCronExpression()
    {
        return this.refreshCronExpression;
    } //-- String getRefreshCronExpression()

    /**
     * Get 
     *             The total count of the artifact to be retained
     * for each snapshot.
     *           
     * 
     * @return int
     */
    public int getRetentionCount()
    {
        return this.retentionCount;
    } //-- int getRetentionCount()

    /**
     * Get true if re-deployment of artifacts already in the
     * repository will be blocked.
     * 
     * @return boolean
     */
    public boolean isBlockRedeployments()
    {
        return this.blockRedeployments;
    } //-- boolean isBlockRedeployments()

    /**
     * Get 
     *             True if the released snapshots are to be removed
     * from the repo during repository purge.
     *           
     * 
     * @return boolean
     */
    public boolean isDeleteReleasedSnapshots()
    {
        return this.deleteReleasedSnapshots;
    } //-- boolean isDeleteReleasedSnapshots()

    /**
     * Get true if this repository contains release versioned
     * artifacts.
     * 
     * @return boolean
     */
    public boolean isReleases()
    {
        return this.releases;
    } //-- boolean isReleases()

    /**
     * Get true if this repository should be scanned and processed.
     * 
     * @return boolean
     */
    public boolean isScanned()
    {
        return this.scanned;
    } //-- boolean isScanned()

    /**
     * Get true if this repository contains snapshot versioned
     * artifacts.
     * 
     * @return boolean
     */
    public boolean isSnapshots()
    {
        return this.snapshots;
    } //-- boolean isSnapshots()

    /**
     * Set true if re-deployment of artifacts already in the
     * repository will be blocked.
     * 
     * @param blockRedeployments
     */
    public void setBlockRedeployments( boolean blockRedeployments )
    {
        this.blockRedeployments = blockRedeployments;
    } //-- void setBlockRedeployments( boolean )

    /**
     * Set 
     *             The number of days old which will be the basis
     * for removing a snapshot.
     *           
     * 
     * @param daysOlder
     */
    public void setDaysOlder( int daysOlder )
    {
        this.daysOlder = daysOlder;
    } //-- void setDaysOlder( int )

    /**
     * Set 
     *             True if the released snapshots are to be removed
     * from the repo during repository purge.
     *           
     * 
     * @param deleteReleasedSnapshots
     */
    public void setDeleteReleasedSnapshots( boolean deleteReleasedSnapshots )
    {
        this.deleteReleasedSnapshots = deleteReleasedSnapshots;
    } //-- void setDeleteReleasedSnapshots( boolean )

    /**
     * Set 
     *             The directory for the indexes of this
     * repository.
     *           
     * 
     * @param indexDir
     */
    public void setIndexDir( String indexDir )
    {
        this.indexDir = indexDir;
    } //-- void setIndexDir( String )

    /**
     * Set 
     *             The file system location for this repository.
     *           
     * 
     * @param location
     */
    public void setLocation( String location )
    {
        this.location = location;
    } //-- void setLocation( String )

    /**
     * Set 
     *             When to run the refresh task.
     *             Default is every hour
     *           .
     * 
     * @param refreshCronExpression
     */
    public void setRefreshCronExpression( String refreshCronExpression )
    {
        this.refreshCronExpression = refreshCronExpression;
    } //-- void setRefreshCronExpression( String )

    /**
     * Set true if this repository contains release versioned
     * artifacts.
     * 
     * @param releases
     */
    public void setReleases( boolean releases )
    {
        this.releases = releases;
    } //-- void setReleases( boolean )

    /**
     * Set 
     *             The total count of the artifact to be retained
     * for each snapshot.
     *           
     * 
     * @param retentionCount
     */
    public void setRetentionCount( int retentionCount )
    {
        this.retentionCount = retentionCount;
    } //-- void setRetentionCount( int )

    /**
     * Set true if this repository should be scanned and processed.
     * 
     * @param scanned
     */
    public void setScanned( boolean scanned )
    {
        this.scanned = scanned;
    } //-- void setScanned( boolean )

    /**
     * Set true if this repository contains snapshot versioned
     * artifacts.
     * 
     * @param snapshots
     */
    public void setSnapshots( boolean snapshots )
    {
        this.snapshots = snapshots;
    } //-- void setSnapshots( boolean )


}
