/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * Class AbstractRepositoryConfiguration.
 * 
 * @version $Revision$ $Date$
 */
public class AbstractRepositoryConfiguration
    implements java.io.Serializable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * 
     *             The repository identifier.
     *           
     */
    private String id;

    /**
     * 
     *             The descriptive name of the repository.
     *           
     */
    private String name;

    /**
     * 
     *             The layout of the repository. Valid values are
     * "default" and "legacy".
     *           
     */
    private String layout = "default";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The repository identifier.
     *           
     * 
     * @return String
     */
    public String getId()
    {
        return this.id;
    } //-- String getId()

    /**
     * Get 
     *             The layout of the repository. Valid values are
     * "default" and "legacy".
     *           
     * 
     * @return String
     */
    public String getLayout()
    {
        return this.layout;
    } //-- String getLayout()

    /**
     * Get 
     *             The descriptive name of the repository.
     *           
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Set 
     *             The repository identifier.
     *           
     * 
     * @param id
     */
    public void setId( String id )
    {
        this.id = id;
    } //-- void setId( String )

    /**
     * Set 
     *             The layout of the repository. Valid values are
     * "default" and "legacy".
     *           
     * 
     * @param layout
     */
    public void setLayout( String layout )
    {
        this.layout = layout;
    } //-- void setLayout( String )

    /**
     * Set 
     *             The descriptive name of the repository.
     *           
     * 
     * @param name
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )


}
