/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.configuration.io.registry;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.maven.archiva.configuration.AbstractRepositoryConfiguration;
import org.apache.maven.archiva.configuration.AbstractRepositoryConnectorConfiguration;
import org.apache.maven.archiva.configuration.Configuration;
import org.apache.maven.archiva.configuration.DatabaseScanningConfiguration;
import org.apache.maven.archiva.configuration.FileType;
import org.apache.maven.archiva.configuration.LegacyArtifactPath;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.configuration.NetworkProxyConfiguration;
import org.apache.maven.archiva.configuration.OrganisationInformation;
import org.apache.maven.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.maven.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.maven.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.maven.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.maven.archiva.configuration.SyncConnectorConfiguration;
import org.apache.maven.archiva.configuration.UserInterfaceOptions;
import org.apache.maven.archiva.configuration.V1RepositoryConfiguration;
import org.apache.maven.archiva.configuration.WebappConfiguration;
import org.codehaus.plexus.registry.Registry;

public class ConfigurationRegistryWriter {
    public void write(Configuration model, Registry registry) {
        this.writeConfiguration("", model, registry);
    }

    private void writeConfiguration(String prefix, Configuration value, Registry registry) {
        if (value != null) {
            Serializable o;
            String name;
            Iterator<Serializable> iter;
            if (value.getVersion() != null) {
                String name2 = "version";
                registry.setString(prefix + name2, value.getVersion());
            }
            if (value.getRepositories() != null && value.getRepositories().size() > 0) {
                registry.removeSubset(prefix + "repositories");
                int count = 0;
                iter = value.getRepositories().iterator();
                while (iter.hasNext()) {
                    name = "repositories.repository(" + count + ")";
                    o = (V1RepositoryConfiguration)iter.next();
                    this.writeV1RepositoryConfiguration(prefix + name + ".", (V1RepositoryConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getRepositoryGroups() != null && value.getRepositoryGroups().size() > 0) {
                registry.removeSubset(prefix + "repositoryGroups");
                int count = 0;
                iter = value.getRepositoryGroups().iterator();
                while (iter.hasNext()) {
                    name = "repositoryGroups.repositoryGroup(" + count + ")";
                    o = (RepositoryGroupConfiguration)iter.next();
                    this.writeRepositoryGroupConfiguration(prefix + name + ".", (RepositoryGroupConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getManagedRepositories() != null && value.getManagedRepositories().size() > 0) {
                registry.removeSubset(prefix + "managedRepositories");
                int count = 0;
                iter = value.getManagedRepositories().iterator();
                while (iter.hasNext()) {
                    name = "managedRepositories.managedRepository(" + count + ")";
                    o = (ManagedRepositoryConfiguration)iter.next();
                    this.writeManagedRepositoryConfiguration(prefix + name + ".", (ManagedRepositoryConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getRemoteRepositories() != null && value.getRemoteRepositories().size() > 0) {
                registry.removeSubset(prefix + "remoteRepositories");
                int count = 0;
                iter = value.getRemoteRepositories().iterator();
                while (iter.hasNext()) {
                    name = "remoteRepositories.remoteRepository(" + count + ")";
                    o = (RemoteRepositoryConfiguration)iter.next();
                    this.writeRemoteRepositoryConfiguration(prefix + name + ".", (RemoteRepositoryConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getProxyConnectors() != null && value.getProxyConnectors().size() > 0) {
                registry.removeSubset(prefix + "proxyConnectors");
                int count = 0;
                iter = value.getProxyConnectors().iterator();
                while (iter.hasNext()) {
                    name = "proxyConnectors.proxyConnector(" + count + ")";
                    o = (ProxyConnectorConfiguration)iter.next();
                    this.writeProxyConnectorConfiguration(prefix + name + ".", (ProxyConnectorConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getNetworkProxies() != null && value.getNetworkProxies().size() > 0) {
                registry.removeSubset(prefix + "networkProxies");
                int count = 0;
                iter = value.getNetworkProxies().iterator();
                while (iter.hasNext()) {
                    name = "networkProxies.networkProxy(" + count + ")";
                    o = (NetworkProxyConfiguration)iter.next();
                    this.writeNetworkProxyConfiguration(prefix + name + ".", (NetworkProxyConfiguration)o, registry);
                    ++count;
                }
            }
            if (value.getLegacyArtifactPaths() != null && value.getLegacyArtifactPaths().size() > 0) {
                registry.removeSubset(prefix + "legacyArtifactPaths");
                int count = 0;
                iter = value.getLegacyArtifactPaths().iterator();
                while (iter.hasNext()) {
                    name = "legacyArtifactPaths.legacyArtifactPath(" + count + ")";
                    o = (LegacyArtifactPath)iter.next();
                    this.writeLegacyArtifactPath(prefix + name + ".", (LegacyArtifactPath)o, registry);
                    ++count;
                }
            }
            if (value.getRepositoryScanning() != null) {
                this.writeRepositoryScanningConfiguration(prefix + "repositoryScanning.", value.getRepositoryScanning(), registry);
            }
            if (value.getDatabaseScanning() != null) {
                this.writeDatabaseScanningConfiguration(prefix + "databaseScanning.", value.getDatabaseScanning(), registry);
            }
            if (value.getWebapp() != null) {
                this.writeWebappConfiguration(prefix + "webapp.", value.getWebapp(), registry);
            }
            if (value.getOrganisationInfo() != null) {
                this.writeOrganisationInformation(prefix + "organisationInfo.", value.getOrganisationInfo(), registry);
            }
        }
    }

    private void writeAbstractRepositoryConfiguration(String prefix, AbstractRepositoryConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            if (value.getId() != null) {
                name = "id";
                registry.setString(prefix + name, value.getId());
            }
            if (value.getName() != null) {
                name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getLayout() != null && !value.getLayout().equals("default")) {
                name = "layout";
                registry.setString(prefix + name, value.getLayout());
            }
        }
    }

    private void writeRemoteRepositoryConfiguration(String prefix, RemoteRepositoryConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            if (value.getUrl() != null) {
                name = "url";
                registry.setString(prefix + name, value.getUrl());
            }
            if (value.getUsername() != null) {
                name = "username";
                registry.setString(prefix + name, value.getUsername());
            }
            if (value.getPassword() != null) {
                name = "password";
                registry.setString(prefix + name, value.getPassword());
            }
            if (value.getTimeout() != 60) {
                name = "timeout";
                registry.setInt(prefix + name, value.getTimeout());
            }
            if (value.getId() != null) {
                name = "id";
                registry.setString(prefix + name, value.getId());
            }
            if (value.getName() != null) {
                name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getLayout() != null && !value.getLayout().equals("default")) {
                name = "layout";
                registry.setString(prefix + name, value.getLayout());
            }
        }
    }

    private void writeManagedRepositoryConfiguration(String prefix, ManagedRepositoryConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            if (value.getLocation() != null) {
                name = "location";
                registry.setString(prefix + name, value.getLocation());
            }
            if (!value.isReleases()) {
                name = "releases";
                registry.setBoolean(prefix + name, value.isReleases());
            }
            if (value.isSnapshots()) {
                name = "snapshots";
                registry.setBoolean(prefix + name, value.isSnapshots());
            }
            if (!value.isScanned()) {
                name = "scanned";
                registry.setBoolean(prefix + name, value.isScanned());
            }
            if (value.getIndexDir() != null) {
                name = "indexDir";
                registry.setString(prefix + name, value.getIndexDir());
            }
            if (value.getRefreshCronExpression() != null && !value.getRefreshCronExpression().equals("0 0 * * * ?")) {
                name = "refreshCronExpression";
                registry.setString(prefix + name, value.getRefreshCronExpression());
            }
            if (value.getRetentionCount() != 2) {
                name = "retentionCount";
                registry.setInt(prefix + name, value.getRetentionCount());
            }
            if (value.getDaysOlder() != 100) {
                name = "daysOlder";
                registry.setInt(prefix + name, value.getDaysOlder());
            }
            if (value.isDeleteReleasedSnapshots()) {
                name = "deleteReleasedSnapshots";
                registry.setBoolean(prefix + name, value.isDeleteReleasedSnapshots());
            }
            if (value.getId() != null) {
                name = "id";
                registry.setString(prefix + name, value.getId());
            }
            if (value.getName() != null) {
                name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getLayout() != null && !value.getLayout().equals("default")) {
                name = "layout";
                registry.setString(prefix + name, value.getLayout());
            }
        }
    }

    private void writeV1RepositoryConfiguration(String prefix, V1RepositoryConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            if (value.getUrl() != null) {
                name = "url";
                registry.setString(prefix + name, value.getUrl());
            }
            if (value.isIndexed()) {
                name = "indexed";
                registry.setBoolean(prefix + name, value.isIndexed());
            }
            if (value.getLocation() != null) {
                name = "location";
                registry.setString(prefix + name, value.getLocation());
            }
            if (!value.isReleases()) {
                name = "releases";
                registry.setBoolean(prefix + name, value.isReleases());
            }
            if (value.isSnapshots()) {
                name = "snapshots";
                registry.setBoolean(prefix + name, value.isSnapshots());
            }
            if (!value.isScanned()) {
                name = "scanned";
                registry.setBoolean(prefix + name, value.isScanned());
            }
            if (value.getIndexDir() != null) {
                name = "indexDir";
                registry.setString(prefix + name, value.getIndexDir());
            }
            if (value.getRefreshCronExpression() != null && !value.getRefreshCronExpression().equals("0 0 * * * ?")) {
                name = "refreshCronExpression";
                registry.setString(prefix + name, value.getRefreshCronExpression());
            }
            if (value.getRetentionCount() != 2) {
                name = "retentionCount";
                registry.setInt(prefix + name, value.getRetentionCount());
            }
            if (value.getDaysOlder() != 100) {
                name = "daysOlder";
                registry.setInt(prefix + name, value.getDaysOlder());
            }
            if (value.isDeleteReleasedSnapshots()) {
                name = "deleteReleasedSnapshots";
                registry.setBoolean(prefix + name, value.isDeleteReleasedSnapshots());
            }
            if (value.getId() != null) {
                name = "id";
                registry.setString(prefix + name, value.getId());
            }
            if (value.getName() != null) {
                name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getLayout() != null && !value.getLayout().equals("default")) {
                name = "layout";
                registry.setString(prefix + name, value.getLayout());
            }
        }
    }

    private void writeLegacyArtifactPath(String prefix, LegacyArtifactPath value, Registry registry) {
        if (value != null) {
            String name;
            if (value.getPath() != null) {
                name = "path";
                registry.setString(prefix + name, value.getPath());
            }
            if (value.getArtifact() != null) {
                name = "artifact";
                registry.setString(prefix + name, value.getArtifact());
            }
        }
    }

    private void writeRepositoryGroupConfiguration(String prefix, RepositoryGroupConfiguration value, Registry registry) {
        if (value != null) {
            if (value.getId() != null) {
                String name = "id";
                registry.setString(prefix + name, value.getId());
            }
            if (value.getRepositories() != null && value.getRepositories().size() > 0) {
                registry.removeSubset(prefix + "repositories");
                int count = 0;
                Iterator<String> iter = value.getRepositories().iterator();
                while (iter.hasNext()) {
                    String name = "repositories.repository(" + count + ")";
                    String repository = iter.next();
                    registry.setString(prefix + name, repository);
                    ++count;
                }
            }
        }
    }

    private void writeAbstractRepositoryConnectorConfiguration(String prefix, AbstractRepositoryConnectorConfiguration value, Registry registry) {
        if (value != null) {
            String v;
            String name;
            Iterator<String> iter;
            String name2;
            if (value.getSourceRepoId() != null) {
                name2 = "sourceRepoId";
                registry.setString(prefix + name2, value.getSourceRepoId());
            }
            if (value.getTargetRepoId() != null) {
                name2 = "targetRepoId";
                registry.setString(prefix + name2, value.getTargetRepoId());
            }
            if (value.getProxyId() != null) {
                name2 = "proxyId";
                registry.setString(prefix + name2, value.getProxyId());
            }
            if (value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0) {
                registry.removeSubset(prefix + "blackListPatterns");
                int count = 0;
                iter = value.getBlackListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = iter.next();
                    registry.setString(prefix + name, blackListPattern);
                    ++count;
                }
            }
            if (value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0) {
                registry.removeSubset(prefix + "whiteListPatterns");
                int count = 0;
                iter = value.getWhiteListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = iter.next();
                    registry.setString(prefix + name, whiteListPattern);
                    ++count;
                }
            }
            if (value.getPolicies() != null && value.getPolicies().size() > 0) {
                registry.removeSubset(prefix + "policies");
                for (String key : value.getPolicies().keySet()) {
                    v = (String)value.getPolicies().get(key);
                    registry.setString(prefix + "policies." + key, v);
                }
            }
            if (value.getProperties() != null && value.getProperties().size() > 0) {
                registry.removeSubset(prefix + "properties");
                for (String key : value.getProperties().keySet()) {
                    v = (String)value.getProperties().get(key);
                    registry.setString(prefix + "properties." + key, v);
                }
            }
            if (value.isDisabled()) {
                String name3 = "disabled";
                registry.setBoolean(prefix + name3, value.isDisabled());
            }
        }
    }

    private void writeProxyConnectorConfiguration(String prefix, ProxyConnectorConfiguration value, Registry registry) {
        if (value != null) {
            String v;
            String name;
            Iterator<String> iter;
            String name2;
            if (value.getOrder() != 0) {
                name2 = "order";
                registry.setInt(prefix + name2, value.getOrder());
            }
            if (value.getSourceRepoId() != null) {
                name2 = "sourceRepoId";
                registry.setString(prefix + name2, value.getSourceRepoId());
            }
            if (value.getTargetRepoId() != null) {
                name2 = "targetRepoId";
                registry.setString(prefix + name2, value.getTargetRepoId());
            }
            if (value.getProxyId() != null) {
                name2 = "proxyId";
                registry.setString(prefix + name2, value.getProxyId());
            }
            if (value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0) {
                registry.removeSubset(prefix + "blackListPatterns");
                int count = 0;
                iter = value.getBlackListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = iter.next();
                    registry.setString(prefix + name, blackListPattern);
                    ++count;
                }
            }
            if (value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0) {
                registry.removeSubset(prefix + "whiteListPatterns");
                int count = 0;
                iter = value.getWhiteListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = iter.next();
                    registry.setString(prefix + name, whiteListPattern);
                    ++count;
                }
            }
            if (value.getPolicies() != null && value.getPolicies().size() > 0) {
                registry.removeSubset(prefix + "policies");
                for (String key : value.getPolicies().keySet()) {
                    v = (String)value.getPolicies().get(key);
                    registry.setString(prefix + "policies." + key, v);
                }
            }
            if (value.getProperties() != null && value.getProperties().size() > 0) {
                registry.removeSubset(prefix + "properties");
                for (String key : value.getProperties().keySet()) {
                    v = (String)value.getProperties().get(key);
                    registry.setString(prefix + "properties." + key, v);
                }
            }
            if (value.isDisabled()) {
                String name3 = "disabled";
                registry.setBoolean(prefix + name3, value.isDisabled());
            }
        }
    }

    private void writeSyncConnectorConfiguration(String prefix, SyncConnectorConfiguration value, Registry registry) {
        if (value != null) {
            String v;
            String name;
            Iterator<String> iter;
            String name2;
            if (value.getCronExpression() != null && !value.getCronExpression().equals("0 0 * * * ?")) {
                name2 = "cronExpression";
                registry.setString(prefix + name2, value.getCronExpression());
            }
            if (value.getMethod() != null && !value.getMethod().equals("rsync")) {
                name2 = "method";
                registry.setString(prefix + name2, value.getMethod());
            }
            if (value.getSourceRepoId() != null) {
                name2 = "sourceRepoId";
                registry.setString(prefix + name2, value.getSourceRepoId());
            }
            if (value.getTargetRepoId() != null) {
                name2 = "targetRepoId";
                registry.setString(prefix + name2, value.getTargetRepoId());
            }
            if (value.getProxyId() != null) {
                name2 = "proxyId";
                registry.setString(prefix + name2, value.getProxyId());
            }
            if (value.getBlackListPatterns() != null && value.getBlackListPatterns().size() > 0) {
                registry.removeSubset(prefix + "blackListPatterns");
                int count = 0;
                iter = value.getBlackListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "blackListPatterns.blackListPattern(" + count + ")";
                    String blackListPattern = iter.next();
                    registry.setString(prefix + name, blackListPattern);
                    ++count;
                }
            }
            if (value.getWhiteListPatterns() != null && value.getWhiteListPatterns().size() > 0) {
                registry.removeSubset(prefix + "whiteListPatterns");
                int count = 0;
                iter = value.getWhiteListPatterns().iterator();
                while (iter.hasNext()) {
                    name = "whiteListPatterns.whiteListPattern(" + count + ")";
                    String whiteListPattern = iter.next();
                    registry.setString(prefix + name, whiteListPattern);
                    ++count;
                }
            }
            if (value.getPolicies() != null && value.getPolicies().size() > 0) {
                registry.removeSubset(prefix + "policies");
                for (String key : value.getPolicies().keySet()) {
                    v = (String)value.getPolicies().get(key);
                    registry.setString(prefix + "policies." + key, v);
                }
            }
            if (value.getProperties() != null && value.getProperties().size() > 0) {
                registry.removeSubset(prefix + "properties");
                for (String key : value.getProperties().keySet()) {
                    v = (String)value.getProperties().get(key);
                    registry.setString(prefix + "properties." + key, v);
                }
            }
            if (value.isDisabled()) {
                String name3 = "disabled";
                registry.setBoolean(prefix + name3, value.isDisabled());
            }
        }
    }

    private void writeNetworkProxyConfiguration(String prefix, NetworkProxyConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            if (value.getId() != null) {
                name = "id";
                registry.setString(prefix + name, value.getId());
            }
            if (value.getProtocol() != null && !value.getProtocol().equals("http")) {
                name = "protocol";
                registry.setString(prefix + name, value.getProtocol());
            }
            if (value.getHost() != null) {
                name = "host";
                registry.setString(prefix + name, value.getHost());
            }
            if (value.getPort() != 8080) {
                name = "port";
                registry.setInt(prefix + name, value.getPort());
            }
            if (value.getUsername() != null) {
                name = "username";
                registry.setString(prefix + name, value.getUsername());
            }
            if (value.getPassword() != null) {
                name = "password";
                registry.setString(prefix + name, value.getPassword());
            }
        }
    }

    private void writeRepositoryScanningConfiguration(String prefix, RepositoryScanningConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            Iterator<Object> iter;
            int count;
            if (value.getFileTypes() != null && value.getFileTypes().size() > 0) {
                registry.removeSubset(prefix + "fileTypes");
                count = 0;
                iter = value.getFileTypes().iterator();
                while (iter.hasNext()) {
                    name = "fileTypes.fileType(" + count + ")";
                    FileType o = (FileType)iter.next();
                    this.writeFileType(prefix + name + ".", o, registry);
                    ++count;
                }
            }
            if (value.getKnownContentConsumers() != null && value.getKnownContentConsumers().size() > 0) {
                registry.removeSubset(prefix + "knownContentConsumers");
                count = 0;
                iter = value.getKnownContentConsumers().iterator();
                while (iter.hasNext()) {
                    name = "knownContentConsumers.knownContentConsumer(" + count + ")";
                    String knownContentConsumer = (String)iter.next();
                    registry.setString(prefix + name, knownContentConsumer);
                    ++count;
                }
            }
            if (value.getInvalidContentConsumers() != null && value.getInvalidContentConsumers().size() > 0) {
                registry.removeSubset(prefix + "invalidContentConsumers");
                count = 0;
                iter = value.getInvalidContentConsumers().iterator();
                while (iter.hasNext()) {
                    name = "invalidContentConsumers.invalidContentConsumer(" + count + ")";
                    String invalidContentConsumer = (String)iter.next();
                    registry.setString(prefix + name, invalidContentConsumer);
                    ++count;
                }
            }
        }
    }

    private void writeFileType(String prefix, FileType value, Registry registry) {
        if (value != null) {
            if (value.getId() != null) {
                String name = "id";
                registry.setString(prefix + name, value.getId());
            }
            if (value.getPatterns() != null && value.getPatterns().size() > 0) {
                registry.removeSubset(prefix + "patterns");
                int count = 0;
                Iterator<String> iter = value.getPatterns().iterator();
                while (iter.hasNext()) {
                    String name = "patterns.pattern(" + count + ")";
                    String pattern = iter.next();
                    registry.setString(prefix + name, pattern);
                    ++count;
                }
            }
        }
    }

    private void writeDatabaseScanningConfiguration(String prefix, DatabaseScanningConfiguration value, Registry registry) {
        if (value != null) {
            String name;
            Iterator<String> iter;
            if (value.getCronExpression() != null && !value.getCronExpression().equals("0 0 0/2 * * ?")) {
                String name2 = "cronExpression";
                registry.setString(prefix + name2, value.getCronExpression());
            }
            if (value.getUnprocessedConsumers() != null && value.getUnprocessedConsumers().size() > 0) {
                registry.removeSubset(prefix + "unprocessedConsumers");
                int count = 0;
                iter = value.getUnprocessedConsumers().iterator();
                while (iter.hasNext()) {
                    name = "unprocessedConsumers.unprocessedConsumer(" + count + ")";
                    String unprocessedConsumer = iter.next();
                    registry.setString(prefix + name, unprocessedConsumer);
                    ++count;
                }
            }
            if (value.getCleanupConsumers() != null && value.getCleanupConsumers().size() > 0) {
                registry.removeSubset(prefix + "cleanupConsumers");
                int count = 0;
                iter = value.getCleanupConsumers().iterator();
                while (iter.hasNext()) {
                    name = "cleanupConsumers.cleanupConsumer(" + count + ")";
                    String cleanupConsumer = iter.next();
                    registry.setString(prefix + name, cleanupConsumer);
                    ++count;
                }
            }
        }
    }

    private void writeOrganisationInformation(String prefix, OrganisationInformation value, Registry registry) {
        if (value != null) {
            String name;
            if (value.getName() != null) {
                name = "name";
                registry.setString(prefix + name, value.getName());
            }
            if (value.getUrl() != null) {
                name = "url";
                registry.setString(prefix + name, value.getUrl());
            }
            if (value.getLogoLocation() != null) {
                name = "logoLocation";
                registry.setString(prefix + name, value.getLogoLocation());
            }
        }
    }

    private void writeWebappConfiguration(String prefix, WebappConfiguration value, Registry registry) {
        if (value != null && value.getUi() != null) {
            this.writeUserInterfaceOptions(prefix + "ui.", value.getUi(), registry);
        }
    }

    private void writeUserInterfaceOptions(String prefix, UserInterfaceOptions value, Registry registry) {
        if (value != null) {
            String name;
            if (!value.isShowFindArtifacts()) {
                name = "showFindArtifacts";
                registry.setBoolean(prefix + name, value.isShowFindArtifacts());
            }
            if (!value.isAppletFindEnabled()) {
                name = "appletFindEnabled";
                registry.setBoolean(prefix + name, value.isAppletFindEnabled());
            }
        }
    }
}

