/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * 
 *         The user interface configuration settings.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class UserInterfaceOptions implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field showFindArtifacts
     */
    private boolean showFindArtifacts = true;

    /**
     * Field appletFindEnabled
     */
    private boolean appletFindEnabled = true;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get true if applet behavior for find artifacts should be
     * enabled
     */
    public boolean isAppletFindEnabled()
    {
        return this.appletFindEnabled;
    } //-- boolean isAppletFindEnabled() 

    /**
     * Get true if find artifacts should be enabled
     */
    public boolean isShowFindArtifacts()
    {
        return this.showFindArtifacts;
    } //-- boolean isShowFindArtifacts() 

    /**
     * Set true if applet behavior for find artifacts should be
     * enabled
     * 
     * @param appletFindEnabled
     */
    public void setAppletFindEnabled(boolean appletFindEnabled)
    {
        this.appletFindEnabled = appletFindEnabled;
    } //-- void setAppletFindEnabled(boolean) 

    /**
     * Set true if find artifacts should be enabled
     * 
     * @param showFindArtifacts
     */
    public void setShowFindArtifacts(boolean showFindArtifacts)
    {
        this.showFindArtifacts = showFindArtifacts;
    } //-- void setShowFindArtifacts(boolean) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
