/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class NetworkProxyConfiguration implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field protocol
     */
    private String protocol = "http";

    /**
     * Field host
     */
    private String host;

    /**
     * Field port
     */
    private int port = 8080;

    /**
     * Field username
     */
    private String username;

    /**
     * Field password
     */
    private String password;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The proxy host.
     *           
     */
    public String getHost()
    {
        return this.host;
    } //-- String getHost() 

    /**
     * Get 
     *             The ID for this proxy.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The proxy password.
     *           
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword() 

    /**
     * Get 
     *             The proxy port.
     *           
     */
    public int getPort()
    {
        return this.port;
    } //-- int getPort() 

    /**
     * Get 
     *             The network protocol to use with this proxy:
     * "http", "socks-4"
     *           
     */
    public String getProtocol()
    {
        return this.protocol;
    } //-- String getProtocol() 

    /**
     * Get 
     *             The proxy user.
     *           
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername() 

    /**
     * Set 
     *             The proxy host.
     *           
     * 
     * @param host
     */
    public void setHost(String host)
    {
        this.host = host;
    } //-- void setHost(String) 

    /**
     * Set 
     *             The ID for this proxy.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The proxy password.
     *           
     * 
     * @param password
     */
    public void setPassword(String password)
    {
        this.password = password;
    } //-- void setPassword(String) 

    /**
     * Set 
     *             The proxy port.
     *           
     * 
     * @param port
     */
    public void setPort(int port)
    {
        this.port = port;
    } //-- void setPort(int) 

    /**
     * Set 
     *             The network protocol to use with this proxy:
     * "http", "socks-4"
     *           
     * 
     * @param protocol
     */
    public void setProtocol(String protocol)
    {
        this.protocol = protocol;
    } //-- void setProtocol(String) 

    /**
     * Set 
     *             The proxy user.
     *           
     * 
     * @param username
     */
    public void setUsername(String username)
    {
        this.username = username;
    } //-- void setUsername(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
