/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.archiva.configuration.DatabaseScanningConfiguration;
import org.apache.maven.archiva.configuration.LegacyArtifactPath;
import org.apache.maven.archiva.configuration.ManagedRepositoryConfiguration;
import org.apache.maven.archiva.configuration.NetworkProxyConfiguration;
import org.apache.maven.archiva.configuration.OrganisationInformation;
import org.apache.maven.archiva.configuration.ProxyConnectorConfiguration;
import org.apache.maven.archiva.configuration.RemoteRepositoryConfiguration;
import org.apache.maven.archiva.configuration.RepositoryGroupConfiguration;
import org.apache.maven.archiva.configuration.RepositoryScanningConfiguration;
import org.apache.maven.archiva.configuration.WebappConfiguration;
import org.apache.maven.archiva.configuration.functors.ProxyConnectorConfigurationOrderComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration
implements Serializable {
    private String version;
    private List repositories;
    private List repositoryGroups;
    private List managedRepositories;
    private List remoteRepositories;
    private List proxyConnectors;
    private List networkProxies;
    private List legacyArtifactPaths;
    private RepositoryScanningConfiguration repositoryScanning;
    private DatabaseScanningConfiguration databaseScanning;
    private WebappConfiguration webapp;
    private OrganisationInformation organisationInfo;
    private Map<String, List<String>> repositoryToGroupMap;
    private Map<String, List<String>> groupToRepositoryMap;
    private String modelEncoding = "UTF-8";

    public void addLegacyArtifactPath(LegacyArtifactPath legacyArtifactPath) {
        if (!(legacyArtifactPath instanceof LegacyArtifactPath)) {
            throw new ClassCastException("Configuration.addLegacyArtifactPaths(legacyArtifactPath) parameter must be instanceof " + LegacyArtifactPath.class.getName());
        }
        this.getLegacyArtifactPaths().add(legacyArtifactPath);
    }

    public void addManagedRepository(ManagedRepositoryConfiguration managedRepositoryConfiguration) {
        if (!(managedRepositoryConfiguration instanceof ManagedRepositoryConfiguration)) {
            throw new ClassCastException("Configuration.addManagedRepositories(managedRepositoryConfiguration) parameter must be instanceof " + ManagedRepositoryConfiguration.class.getName());
        }
        this.getManagedRepositories().add(managedRepositoryConfiguration);
    }

    public void addNetworkProxy(NetworkProxyConfiguration networkProxyConfiguration) {
        if (!(networkProxyConfiguration instanceof NetworkProxyConfiguration)) {
            throw new ClassCastException("Configuration.addNetworkProxies(networkProxyConfiguration) parameter must be instanceof " + NetworkProxyConfiguration.class.getName());
        }
        this.getNetworkProxies().add(networkProxyConfiguration);
    }

    public void addProxyConnector(ProxyConnectorConfiguration proxyConnectorConfiguration) {
        if (!(proxyConnectorConfiguration instanceof ProxyConnectorConfiguration)) {
            throw new ClassCastException("Configuration.addProxyConnectors(proxyConnectorConfiguration) parameter must be instanceof " + ProxyConnectorConfiguration.class.getName());
        }
        this.getProxyConnectors().add(proxyConnectorConfiguration);
    }

    public void addRemoteRepository(RemoteRepositoryConfiguration remoteRepositoryConfiguration) {
        if (!(remoteRepositoryConfiguration instanceof RemoteRepositoryConfiguration)) {
            throw new ClassCastException("Configuration.addRemoteRepositories(remoteRepositoryConfiguration) parameter must be instanceof " + RemoteRepositoryConfiguration.class.getName());
        }
        this.getRemoteRepositories().add(remoteRepositoryConfiguration);
    }

    public void addRepositoryGroup(RepositoryGroupConfiguration repositoryGroupConfiguration) {
        if (!(repositoryGroupConfiguration instanceof RepositoryGroupConfiguration)) {
            throw new ClassCastException("Configuration.addRepositoryGroups(repositoryGroupConfiguration) parameter must be instanceof " + RepositoryGroupConfiguration.class.getName());
        }
        this.getRepositoryGroups().add(repositoryGroupConfiguration);
    }

    public DatabaseScanningConfiguration getDatabaseScanning() {
        return this.databaseScanning;
    }

    public List getLegacyArtifactPaths() {
        if (this.legacyArtifactPaths == null) {
            this.legacyArtifactPaths = new ArrayList();
        }
        return this.legacyArtifactPaths;
    }

    public List getManagedRepositories() {
        if (this.managedRepositories == null) {
            this.managedRepositories = new ArrayList();
        }
        return this.managedRepositories;
    }

    public List getNetworkProxies() {
        if (this.networkProxies == null) {
            this.networkProxies = new ArrayList();
        }
        return this.networkProxies;
    }

    public OrganisationInformation getOrganisationInfo() {
        return this.organisationInfo;
    }

    public List getProxyConnectors() {
        if (this.proxyConnectors == null) {
            this.proxyConnectors = new ArrayList();
        }
        return this.proxyConnectors;
    }

    public List getRemoteRepositories() {
        if (this.remoteRepositories == null) {
            this.remoteRepositories = new ArrayList();
        }
        return this.remoteRepositories;
    }

    public List getRepositories() {
        if (this.repositories == null) {
            this.repositories = new ArrayList();
        }
        return this.repositories;
    }

    public List getRepositoryGroups() {
        if (this.repositoryGroups == null) {
            this.repositoryGroups = new ArrayList();
        }
        return this.repositoryGroups;
    }

    public RepositoryScanningConfiguration getRepositoryScanning() {
        return this.repositoryScanning;
    }

    public String getVersion() {
        return this.version;
    }

    public WebappConfiguration getWebapp() {
        return this.webapp;
    }

    public void removeLegacyArtifactPath(LegacyArtifactPath legacyArtifactPath) {
        if (!(legacyArtifactPath instanceof LegacyArtifactPath)) {
            throw new ClassCastException("Configuration.removeLegacyArtifactPaths(legacyArtifactPath) parameter must be instanceof " + LegacyArtifactPath.class.getName());
        }
        this.getLegacyArtifactPaths().remove(legacyArtifactPath);
    }

    public void removeManagedRepository(ManagedRepositoryConfiguration managedRepositoryConfiguration) {
        if (!(managedRepositoryConfiguration instanceof ManagedRepositoryConfiguration)) {
            throw new ClassCastException("Configuration.removeManagedRepositories(managedRepositoryConfiguration) parameter must be instanceof " + ManagedRepositoryConfiguration.class.getName());
        }
        this.getManagedRepositories().remove(managedRepositoryConfiguration);
    }

    public void removeNetworkProxy(NetworkProxyConfiguration networkProxyConfiguration) {
        if (!(networkProxyConfiguration instanceof NetworkProxyConfiguration)) {
            throw new ClassCastException("Configuration.removeNetworkProxies(networkProxyConfiguration) parameter must be instanceof " + NetworkProxyConfiguration.class.getName());
        }
        this.getNetworkProxies().remove(networkProxyConfiguration);
    }

    public void removeProxyConnector(ProxyConnectorConfiguration proxyConnectorConfiguration) {
        if (!(proxyConnectorConfiguration instanceof ProxyConnectorConfiguration)) {
            throw new ClassCastException("Configuration.removeProxyConnectors(proxyConnectorConfiguration) parameter must be instanceof " + ProxyConnectorConfiguration.class.getName());
        }
        this.getProxyConnectors().remove(proxyConnectorConfiguration);
    }

    public void removeRemoteRepository(RemoteRepositoryConfiguration remoteRepositoryConfiguration) {
        if (!(remoteRepositoryConfiguration instanceof RemoteRepositoryConfiguration)) {
            throw new ClassCastException("Configuration.removeRemoteRepositories(remoteRepositoryConfiguration) parameter must be instanceof " + RemoteRepositoryConfiguration.class.getName());
        }
        this.getRemoteRepositories().remove(remoteRepositoryConfiguration);
    }

    public void removeRepositoryGroup(RepositoryGroupConfiguration repositoryGroupConfiguration) {
        if (!(repositoryGroupConfiguration instanceof RepositoryGroupConfiguration)) {
            throw new ClassCastException("Configuration.removeRepositoryGroups(repositoryGroupConfiguration) parameter must be instanceof " + RepositoryGroupConfiguration.class.getName());
        }
        this.getRepositoryGroups().remove(repositoryGroupConfiguration);
    }

    public void setDatabaseScanning(DatabaseScanningConfiguration databaseScanning) {
        this.databaseScanning = databaseScanning;
    }

    public void setLegacyArtifactPaths(List legacyArtifactPaths) {
        this.legacyArtifactPaths = legacyArtifactPaths;
    }

    public void setManagedRepositories(List managedRepositories) {
        this.managedRepositories = managedRepositories;
    }

    public void setNetworkProxies(List networkProxies) {
        this.networkProxies = networkProxies;
    }

    public void setOrganisationInfo(OrganisationInformation organisationInfo) {
        this.organisationInfo = organisationInfo;
    }

    public void setProxyConnectors(List proxyConnectors) {
        this.proxyConnectors = proxyConnectors;
    }

    public void setRemoteRepositories(List remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public void setRepositories(List repositories) {
        this.repositories = repositories;
    }

    public void setRepositoryGroups(List repositoryGroups) {
        this.repositoryGroups = repositoryGroups;
    }

    public void setRepositoryScanning(RepositoryScanningConfiguration repositoryScanning) {
        this.repositoryScanning = repositoryScanning;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setWebapp(WebappConfiguration webapp) {
        this.webapp = webapp;
    }

    public Map<String, List<String>> getRepositoryToGroupMap() {
        if (this.repositoryGroups != null) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (RepositoryGroupConfiguration group : this.repositoryGroups) {
                for (String repositoryId : group.getRepositories()) {
                    ArrayList<String> groups = (ArrayList<String>)map.get(repositoryId);
                    if (groups == null) {
                        groups = new ArrayList<String>();
                        map.put(repositoryId, groups);
                    }
                    groups.add(group.getId());
                }
            }
            this.repositoryToGroupMap = map;
        }
        return this.repositoryToGroupMap;
    }

    public Map<String, RepositoryGroupConfiguration> getRepositoryGroupsAsMap() {
        HashMap<String, RepositoryGroupConfiguration> map = new HashMap<String, RepositoryGroupConfiguration>();
        if (this.repositoryGroups != null) {
            for (RepositoryGroupConfiguration group : this.repositoryGroups) {
                map.put(group.getId(), group);
            }
        }
        return map;
    }

    public RepositoryGroupConfiguration findRepositoryGroupById(String id) {
        if (this.repositoryGroups != null) {
            for (RepositoryGroupConfiguration group : this.repositoryGroups) {
                if (!group.getId().equals(id)) continue;
                return group;
            }
        }
        return null;
    }

    public Map<String, List<String>> getGroupToRepositoryMap() {
        if (this.repositoryGroups != null && this.managedRepositories != null) {
            HashMap<String, List<String>> map = new HashMap<String, List<String>>();
            for (ManagedRepositoryConfiguration repo : this.managedRepositories) {
                for (RepositoryGroupConfiguration group : this.repositoryGroups) {
                    if (group.getRepositories().contains(repo.getId())) continue;
                    String groupId = group.getId();
                    ArrayList<String> repos = (ArrayList<String>)map.get(groupId);
                    if (repos == null) {
                        repos = new ArrayList<String>();
                        map.put(groupId, repos);
                    }
                    repos.add(repo.getId());
                }
            }
            this.groupToRepositoryMap = map;
        }
        return this.groupToRepositoryMap;
    }

    public Map<String, NetworkProxyConfiguration> getNetworkProxiesAsMap() {
        HashMap<String, NetworkProxyConfiguration> map = new HashMap<String, NetworkProxyConfiguration>();
        if (this.networkProxies != null) {
            for (NetworkProxyConfiguration proxy : this.networkProxies) {
                map.put(proxy.getId(), proxy);
            }
        }
        return map;
    }

    public Map<String, List<ProxyConnectorConfiguration>> getProxyConnectorAsMap() {
        HashMap<String, List<ProxyConnectorConfiguration>> proxyConnectorMap = new HashMap<String, List<ProxyConnectorConfiguration>>();
        for (ProxyConnectorConfiguration proxyConfig : this.proxyConnectors) {
            String key = proxyConfig.getSourceRepoId();
            ArrayList<ProxyConnectorConfiguration> connectors = (ArrayList<ProxyConnectorConfiguration>)proxyConnectorMap.get(key);
            if (connectors == null) {
                connectors = new ArrayList<ProxyConnectorConfiguration>();
                proxyConnectorMap.put(key, connectors);
            }
            connectors.add(proxyConfig);
            Collections.sort(connectors, ProxyConnectorConfigurationOrderComparator.getInstance());
        }
        return proxyConnectorMap;
    }

    public Map<String, RemoteRepositoryConfiguration> getRemoteRepositoriesAsMap() {
        HashMap<String, RemoteRepositoryConfiguration> map = new HashMap<String, RemoteRepositoryConfiguration>();
        if (this.remoteRepositories != null) {
            for (RemoteRepositoryConfiguration repo : this.remoteRepositories) {
                map.put(repo.getId(), repo);
            }
        }
        return map;
    }

    public RemoteRepositoryConfiguration findRemoteRepositoryById(String id) {
        if (this.remoteRepositories != null) {
            for (RemoteRepositoryConfiguration repo : this.remoteRepositories) {
                if (!repo.getId().equals(id)) continue;
                return repo;
            }
        }
        return null;
    }

    public Map<String, ManagedRepositoryConfiguration> getManagedRepositoriesAsMap() {
        HashMap<String, ManagedRepositoryConfiguration> map = new HashMap<String, ManagedRepositoryConfiguration>();
        if (this.managedRepositories != null) {
            for (ManagedRepositoryConfiguration repo : this.managedRepositories) {
                map.put(repo.getId(), repo);
            }
        }
        return map;
    }

    public ManagedRepositoryConfiguration findManagedRepositoryById(String id) {
        if (this.managedRepositories != null) {
            for (ManagedRepositoryConfiguration repo : this.managedRepositories) {
                if (!repo.getId().equals(id)) continue;
                return repo;
            }
        }
        return null;
    }

    public void setModelEncoding(String modelEncoding) {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }
}

