/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class ManagedRepositoryConfiguration extends AbstractRepositoryConfiguration 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field location
     */
    private String location;

    /**
     * Field releases
     */
    private boolean releases = true;

    /**
     * Field snapshots
     */
    private boolean snapshots = false;

    /**
     * Field scanned
     */
    private boolean scanned = true;

    /**
     * Field indexDir
     */
    private String indexDir;

    /**
     * Field refreshCronExpression
     */
    private String refreshCronExpression = "0 0 * * * ?";

    /**
     * Field retentionCount
     */
    private int retentionCount = 2;

    /**
     * Field daysOlder
     */
    private int daysOlder = 100;

    /**
     * Field deleteReleasedSnapshots
     */
    private boolean deleteReleasedSnapshots = false;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The number of days old which will be the basis
     * for removing a snapshot.
     *           
     */
    public int getDaysOlder()
    {
        return this.daysOlder;
    } //-- int getDaysOlder() 

    /**
     * Get 
     *             The directory for the indexes of this
     * repository.
     *           
     */
    public String getIndexDir()
    {
        return this.indexDir;
    } //-- String getIndexDir() 

    /**
     * Get 
     *             The file system location for this repository.
     *           
     */
    public String getLocation()
    {
        return this.location;
    } //-- String getLocation() 

    /**
     * Get 
     *             When to run the refresh task.
     *             Default is every hour
     *           
     */
    public String getRefreshCronExpression()
    {
        return this.refreshCronExpression;
    } //-- String getRefreshCronExpression() 

    /**
     * Get 
     *             The total count of the artifact to be retained
     * for each snapshot.
     *           
     */
    public int getRetentionCount()
    {
        return this.retentionCount;
    } //-- int getRetentionCount() 

    /**
     * Get 
     *             True if the released snapshots are to be removed
     * from the repo during repository purge.
     *           
     */
    public boolean isDeleteReleasedSnapshots()
    {
        return this.deleteReleasedSnapshots;
    } //-- boolean isDeleteReleasedSnapshots() 

    /**
     * Get True if this repository contains release versioned
     * artifacts.
     */
    public boolean isReleases()
    {
        return this.releases;
    } //-- boolean isReleases() 

    /**
     * Get True if this repository should be scanned and processed.
     */
    public boolean isScanned()
    {
        return this.scanned;
    } //-- boolean isScanned() 

    /**
     * Get True if this repository contains snapshot versioned
     * artifacts.
     */
    public boolean isSnapshots()
    {
        return this.snapshots;
    } //-- boolean isSnapshots() 

    /**
     * Set 
     *             The number of days old which will be the basis
     * for removing a snapshot.
     *           
     * 
     * @param daysOlder
     */
    public void setDaysOlder(int daysOlder)
    {
        this.daysOlder = daysOlder;
    } //-- void setDaysOlder(int) 

    /**
     * Set 
     *             True if the released snapshots are to be removed
     * from the repo during repository purge.
     *           
     * 
     * @param deleteReleasedSnapshots
     */
    public void setDeleteReleasedSnapshots(boolean deleteReleasedSnapshots)
    {
        this.deleteReleasedSnapshots = deleteReleasedSnapshots;
    } //-- void setDeleteReleasedSnapshots(boolean) 

    /**
     * Set 
     *             The directory for the indexes of this
     * repository.
     *           
     * 
     * @param indexDir
     */
    public void setIndexDir(String indexDir)
    {
        this.indexDir = indexDir;
    } //-- void setIndexDir(String) 

    /**
     * Set 
     *             The file system location for this repository.
     *           
     * 
     * @param location
     */
    public void setLocation(String location)
    {
        this.location = location;
    } //-- void setLocation(String) 

    /**
     * Set 
     *             When to run the refresh task.
     *             Default is every hour
     *           
     * 
     * @param refreshCronExpression
     */
    public void setRefreshCronExpression(String refreshCronExpression)
    {
        this.refreshCronExpression = refreshCronExpression;
    } //-- void setRefreshCronExpression(String) 

    /**
     * Set True if this repository contains release versioned
     * artifacts.
     * 
     * @param releases
     */
    public void setReleases(boolean releases)
    {
        this.releases = releases;
    } //-- void setReleases(boolean) 

    /**
     * Set 
     *             The total count of the artifact to be retained
     * for each snapshot.
     *           
     * 
     * @param retentionCount
     */
    public void setRetentionCount(int retentionCount)
    {
        this.retentionCount = retentionCount;
    } //-- void setRetentionCount(int) 

    /**
     * Set True if this repository should be scanned and processed.
     * 
     * @param scanned
     */
    public void setScanned(boolean scanned)
    {
        this.scanned = scanned;
    } //-- void setScanned(boolean) 

    /**
     * Set True if this repository contains snapshot versioned
     * artifacts.
     * 
     * @param snapshots
     */
    public void setSnapshots(boolean snapshots)
    {
        this.snapshots = snapshots;
    } //-- void setSnapshots(boolean) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
