/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class LegacyArtifactPath implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field path
     */
    private String path;

    /**
     * Field artifact
     */
    private String artifact;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The artifact reference, as " [groupId] :
     * [artifactId] : [version] : [classifier] : [type] ".
     *           
     */
    public String getArtifact()
    {
        return this.artifact;
    } //-- String getArtifact() 

    /**
     * Get 
     *             The legacy path.
     *           
     */
    public String getPath()
    {
        return this.path;
    } //-- String getPath() 

    /**
     * Set 
     *             The artifact reference, as " [groupId] :
     * [artifactId] : [version] : [classifier] : [type] ".
     *           
     * 
     * @param artifact
     */
    public void setArtifact(String artifact)
    {
        this.artifact = artifact;
    } //-- void setArtifact(String) 

    /**
     * Set 
     *             The legacy path.
     *           
     * 
     * @param path
     */
    public void setPath(String path)
    {
        this.path = path;
    } //-- void setPath(String) 


    public boolean match( String path )
    {
        return path.equals( this.path );
    }

    public String getGroupId()
    {
        return artifact.split( ":" )[0];
	}

    public String getArtifactId()
    {
        return artifact.split( ":" )[1];
	}
        
    public String getVersion()
    {
        return artifact.split( ":" )[2];
	}
    
    public String getClassifier()
    {
		String classifier = artifact.split( ":" )[3];
        return classifier.length() > 0 ? classifier : null;
	}
    
    public String getType()
    {
        return artifact.split( ":" )[4];
    }
       
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
