/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class RemoteRepositoryConfiguration extends AbstractRepositoryConfiguration 
implements java.io.Serializable
{


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field url
     */
    private String url;

    /**
     * Field username
     */
    private String username;

    /**
     * Field password
     */
    private String password;

    /**
     * Field timeout
     */
    private int timeout = 60;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The Password for this repository.
     *           
     */
    public String getPassword()
    {
        return this.password;
    } //-- String getPassword() 

    /**
     * Get 
     *             Timeout in seconds for connections to this
     * repository
     *           
     */
    public int getTimeout()
    {
        return this.timeout;
    } //-- int getTimeout() 

    /**
     * Get 
     *             The URL for this repository.
     *           
     */
    public String getUrl()
    {
        return this.url;
    } //-- String getUrl() 

    /**
     * Get 
     *             The Username for this repository.
     *           
     */
    public String getUsername()
    {
        return this.username;
    } //-- String getUsername() 

    /**
     * Set 
     *             The Password for this repository.
     *           
     * 
     * @param password
     */
    public void setPassword(String password)
    {
        this.password = password;
    } //-- void setPassword(String) 

    /**
     * Set 
     *             Timeout in seconds for connections to this
     * repository
     *           
     * 
     * @param timeout
     */
    public void setTimeout(int timeout)
    {
        this.timeout = timeout;
    } //-- void setTimeout(int) 

    /**
     * Set 
     *             The URL for this repository.
     *           
     * 
     * @param url
     */
    public void setUrl(String url)
    {
        this.url = url;
    } //-- void setUrl(String) 

    /**
     * Set 
     *             The Username for this repository.
     *           
     * 
     * @param username
     */
    public void setUsername(String username)
    {
        this.username = username;
    } //-- void setUsername(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
