/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * The FileType object
 * 
 * @version $Revision$ $Date$
 */
public class FileType implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field patterns
     */
    private java.util.List patterns;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addPattern
     * 
     * @param string
     */
    public void addPattern(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "FileType.addPatterns(string) parameter must be instanceof " + String.class.getName() );
        }
        getPatterns().add( string );
    } //-- void addPattern(String) 

    /**
     * Get null
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getPatterns
     */
    public java.util.List getPatterns()
    {
        if ( this.patterns == null )
        {
            this.patterns = new java.util.ArrayList();
        }
        
        return this.patterns;
    } //-- java.util.List getPatterns() 

    /**
     * Method removePattern
     * 
     * @param string
     */
    public void removePattern(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "FileType.removePatterns(string) parameter must be instanceof " + String.class.getName() );
        }
        getPatterns().remove( string );
    } //-- void removePattern(String) 

    /**
     * Set null
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set null
     * 
     * @param patterns
     */
    public void setPatterns(java.util.List patterns)
    {
        this.patterns = patterns;
    } //-- void setPatterns(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
