/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class Configuration implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field version
     */
    private String version;

    /**
     * Field repositories
     */
    private java.util.List repositories;

    /**
     * Field repositoryGroups
     */
    private java.util.List repositoryGroups;

    /**
     * Field managedRepositories
     */
    private java.util.List managedRepositories;

    /**
     * Field remoteRepositories
     */
    private java.util.List remoteRepositories;

    /**
     * Field proxyConnectors
     */
    private java.util.List proxyConnectors;

    /**
     * Field networkProxies
     */
    private java.util.List networkProxies;

    /**
     * Field legacyArtifactPaths
     */
    private java.util.List legacyArtifactPaths;

    /**
     * Field repositoryScanning
     */
    private RepositoryScanningConfiguration repositoryScanning;

    /**
     * Field databaseScanning
     */
    private DatabaseScanningConfiguration databaseScanning;

    /**
     * Field webapp
     */
    private WebappConfiguration webapp;

    /**
     * Field organisationInfo
     */
    private OrganisationInformation organisationInfo;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addLegacyArtifactPath
     * 
     * @param legacyArtifactPath
     */
    public void addLegacyArtifactPath(LegacyArtifactPath legacyArtifactPath)
    {
        if ( !(legacyArtifactPath instanceof LegacyArtifactPath) )
        {
            throw new ClassCastException( "Configuration.addLegacyArtifactPaths(legacyArtifactPath) parameter must be instanceof " + LegacyArtifactPath.class.getName() );
        }
        getLegacyArtifactPaths().add( legacyArtifactPath );
    } //-- void addLegacyArtifactPath(LegacyArtifactPath) 

    /**
     * Method addManagedRepository
     * 
     * @param managedRepositoryConfiguration
     */
    public void addManagedRepository(ManagedRepositoryConfiguration managedRepositoryConfiguration)
    {
        if ( !(managedRepositoryConfiguration instanceof ManagedRepositoryConfiguration) )
        {
            throw new ClassCastException( "Configuration.addManagedRepositories(managedRepositoryConfiguration) parameter must be instanceof " + ManagedRepositoryConfiguration.class.getName() );
        }
        getManagedRepositories().add( managedRepositoryConfiguration );
    } //-- void addManagedRepository(ManagedRepositoryConfiguration) 

    /**
     * Method addNetworkProxy
     * 
     * @param networkProxyConfiguration
     */
    public void addNetworkProxy(NetworkProxyConfiguration networkProxyConfiguration)
    {
        if ( !(networkProxyConfiguration instanceof NetworkProxyConfiguration) )
        {
            throw new ClassCastException( "Configuration.addNetworkProxies(networkProxyConfiguration) parameter must be instanceof " + NetworkProxyConfiguration.class.getName() );
        }
        getNetworkProxies().add( networkProxyConfiguration );
    } //-- void addNetworkProxy(NetworkProxyConfiguration) 

    /**
     * Method addProxyConnector
     * 
     * @param proxyConnectorConfiguration
     */
    public void addProxyConnector(ProxyConnectorConfiguration proxyConnectorConfiguration)
    {
        if ( !(proxyConnectorConfiguration instanceof ProxyConnectorConfiguration) )
        {
            throw new ClassCastException( "Configuration.addProxyConnectors(proxyConnectorConfiguration) parameter must be instanceof " + ProxyConnectorConfiguration.class.getName() );
        }
        getProxyConnectors().add( proxyConnectorConfiguration );
    } //-- void addProxyConnector(ProxyConnectorConfiguration) 

    /**
     * Method addRemoteRepository
     * 
     * @param remoteRepositoryConfiguration
     */
    public void addRemoteRepository(RemoteRepositoryConfiguration remoteRepositoryConfiguration)
    {
        if ( !(remoteRepositoryConfiguration instanceof RemoteRepositoryConfiguration) )
        {
            throw new ClassCastException( "Configuration.addRemoteRepositories(remoteRepositoryConfiguration) parameter must be instanceof " + RemoteRepositoryConfiguration.class.getName() );
        }
        getRemoteRepositories().add( remoteRepositoryConfiguration );
    } //-- void addRemoteRepository(RemoteRepositoryConfiguration) 

    /**
     * Method addRepositoryGroup
     * 
     * @param repositoryGroupConfiguration
     */
    public void addRepositoryGroup(RepositoryGroupConfiguration repositoryGroupConfiguration)
    {
        if ( !(repositoryGroupConfiguration instanceof RepositoryGroupConfiguration) )
        {
            throw new ClassCastException( "Configuration.addRepositoryGroups(repositoryGroupConfiguration) parameter must be instanceof " + RepositoryGroupConfiguration.class.getName() );
        }
        getRepositoryGroups().add( repositoryGroupConfiguration );
    } //-- void addRepositoryGroup(RepositoryGroupConfiguration) 

    /**
     * Get 
     *             The database scanning configuration.
     *           
     */
    public DatabaseScanningConfiguration getDatabaseScanning()
    {
        return this.databaseScanning;
    } //-- DatabaseScanningConfiguration getDatabaseScanning() 

    /**
     * Method getLegacyArtifactPaths
     */
    public java.util.List getLegacyArtifactPaths()
    {
        if ( this.legacyArtifactPaths == null )
        {
            this.legacyArtifactPaths = new java.util.ArrayList();
        }
        
        return this.legacyArtifactPaths;
    } //-- java.util.List getLegacyArtifactPaths() 

    /**
     * Method getManagedRepositories
     */
    public java.util.List getManagedRepositories()
    {
        if ( this.managedRepositories == null )
        {
            this.managedRepositories = new java.util.ArrayList();
        }
        
        return this.managedRepositories;
    } //-- java.util.List getManagedRepositories() 

    /**
     * Method getNetworkProxies
     */
    public java.util.List getNetworkProxies()
    {
        if ( this.networkProxies == null )
        {
            this.networkProxies = new java.util.ArrayList();
        }
        
        return this.networkProxies;
    } //-- java.util.List getNetworkProxies() 

    /**
     * Get 
     *             The organisation info.
     *           
     */
    public OrganisationInformation getOrganisationInfo()
    {
        return this.organisationInfo;
    } //-- OrganisationInformation getOrganisationInfo() 

    /**
     * Method getProxyConnectors
     */
    public java.util.List getProxyConnectors()
    {
        if ( this.proxyConnectors == null )
        {
            this.proxyConnectors = new java.util.ArrayList();
        }
        
        return this.proxyConnectors;
    } //-- java.util.List getProxyConnectors() 

    /**
     * Method getRemoteRepositories
     */
    public java.util.List getRemoteRepositories()
    {
        if ( this.remoteRepositories == null )
        {
            this.remoteRepositories = new java.util.ArrayList();
        }
        
        return this.remoteRepositories;
    } //-- java.util.List getRemoteRepositories() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Method getRepositoryGroups
     */
    public java.util.List getRepositoryGroups()
    {
        if ( this.repositoryGroups == null )
        {
            this.repositoryGroups = new java.util.ArrayList();
        }
        
        return this.repositoryGroups;
    } //-- java.util.List getRepositoryGroups() 

    /**
     * Get 
     *             The repository scanning configuration.
     *           
     */
    public RepositoryScanningConfiguration getRepositoryScanning()
    {
        return this.repositoryScanning;
    } //-- RepositoryScanningConfiguration getRepositoryScanning() 

    /**
     * Get This is the version of the configuration format.
     */
    public String getVersion()
    {
        return this.version;
    } //-- String getVersion() 

    /**
     * Get 
     *             The webapp configuration.
     *           
     */
    public WebappConfiguration getWebapp()
    {
        return this.webapp;
    } //-- WebappConfiguration getWebapp() 

    /**
     * Method removeLegacyArtifactPath
     * 
     * @param legacyArtifactPath
     */
    public void removeLegacyArtifactPath(LegacyArtifactPath legacyArtifactPath)
    {
        if ( !(legacyArtifactPath instanceof LegacyArtifactPath) )
        {
            throw new ClassCastException( "Configuration.removeLegacyArtifactPaths(legacyArtifactPath) parameter must be instanceof " + LegacyArtifactPath.class.getName() );
        }
        getLegacyArtifactPaths().remove( legacyArtifactPath );
    } //-- void removeLegacyArtifactPath(LegacyArtifactPath) 

    /**
     * Method removeManagedRepository
     * 
     * @param managedRepositoryConfiguration
     */
    public void removeManagedRepository(ManagedRepositoryConfiguration managedRepositoryConfiguration)
    {
        if ( !(managedRepositoryConfiguration instanceof ManagedRepositoryConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeManagedRepositories(managedRepositoryConfiguration) parameter must be instanceof " + ManagedRepositoryConfiguration.class.getName() );
        }
        getManagedRepositories().remove( managedRepositoryConfiguration );
    } //-- void removeManagedRepository(ManagedRepositoryConfiguration) 

    /**
     * Method removeNetworkProxy
     * 
     * @param networkProxyConfiguration
     */
    public void removeNetworkProxy(NetworkProxyConfiguration networkProxyConfiguration)
    {
        if ( !(networkProxyConfiguration instanceof NetworkProxyConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeNetworkProxies(networkProxyConfiguration) parameter must be instanceof " + NetworkProxyConfiguration.class.getName() );
        }
        getNetworkProxies().remove( networkProxyConfiguration );
    } //-- void removeNetworkProxy(NetworkProxyConfiguration) 

    /**
     * Method removeProxyConnector
     * 
     * @param proxyConnectorConfiguration
     */
    public void removeProxyConnector(ProxyConnectorConfiguration proxyConnectorConfiguration)
    {
        if ( !(proxyConnectorConfiguration instanceof ProxyConnectorConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeProxyConnectors(proxyConnectorConfiguration) parameter must be instanceof " + ProxyConnectorConfiguration.class.getName() );
        }
        getProxyConnectors().remove( proxyConnectorConfiguration );
    } //-- void removeProxyConnector(ProxyConnectorConfiguration) 

    /**
     * Method removeRemoteRepository
     * 
     * @param remoteRepositoryConfiguration
     */
    public void removeRemoteRepository(RemoteRepositoryConfiguration remoteRepositoryConfiguration)
    {
        if ( !(remoteRepositoryConfiguration instanceof RemoteRepositoryConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeRemoteRepositories(remoteRepositoryConfiguration) parameter must be instanceof " + RemoteRepositoryConfiguration.class.getName() );
        }
        getRemoteRepositories().remove( remoteRepositoryConfiguration );
    } //-- void removeRemoteRepository(RemoteRepositoryConfiguration) 

    /**
     * Method removeRepositoryGroup
     * 
     * @param repositoryGroupConfiguration
     */
    public void removeRepositoryGroup(RepositoryGroupConfiguration repositoryGroupConfiguration)
    {
        if ( !(repositoryGroupConfiguration instanceof RepositoryGroupConfiguration) )
        {
            throw new ClassCastException( "Configuration.removeRepositoryGroups(repositoryGroupConfiguration) parameter must be instanceof " + RepositoryGroupConfiguration.class.getName() );
        }
        getRepositoryGroups().remove( repositoryGroupConfiguration );
    } //-- void removeRepositoryGroup(RepositoryGroupConfiguration) 

    /**
     * Set 
     *             The database scanning configuration.
     *           
     * 
     * @param databaseScanning
     */
    public void setDatabaseScanning(DatabaseScanningConfiguration databaseScanning)
    {
        this.databaseScanning = databaseScanning;
    } //-- void setDatabaseScanning(DatabaseScanningConfiguration) 

    /**
     * Set 
     *             The list of custom legacy path to artifact.
     *           
     * 
     * @param legacyArtifactPaths
     */
    public void setLegacyArtifactPaths(java.util.List legacyArtifactPaths)
    {
        this.legacyArtifactPaths = legacyArtifactPaths;
    } //-- void setLegacyArtifactPaths(java.util.List) 

    /**
     * Set The list of repositories that this archiva instance
     * uses.
     * 
     * @param managedRepositories
     */
    public void setManagedRepositories(java.util.List managedRepositories)
    {
        this.managedRepositories = managedRepositories;
    } //-- void setManagedRepositories(java.util.List) 

    /**
     * Set 
     *             The list of network proxies to use for outgoing
     * requests.
     *           
     * 
     * @param networkProxies
     */
    public void setNetworkProxies(java.util.List networkProxies)
    {
        this.networkProxies = networkProxies;
    } //-- void setNetworkProxies(java.util.List) 

    /**
     * Set 
     *             The organisation info.
     *           
     * 
     * @param organisationInfo
     */
    public void setOrganisationInfo(OrganisationInformation organisationInfo)
    {
        this.organisationInfo = organisationInfo;
    } //-- void setOrganisationInfo(OrganisationInformation) 

    /**
     * Set The list of proxy connectors for this archiva instance.
     * 
     * @param proxyConnectors
     */
    public void setProxyConnectors(java.util.List proxyConnectors)
    {
        this.proxyConnectors = proxyConnectors;
    } //-- void setProxyConnectors(java.util.List) 

    /**
     * Set The list of repositories that this archiva can retrieve
     * from or publish to.
     * 
     * @param remoteRepositories
     */
    public void setRemoteRepositories(java.util.List remoteRepositories)
    {
        this.remoteRepositories = remoteRepositories;
    } //-- void setRemoteRepositories(java.util.List) 

    /**
     * Set 
     *  @deprecated use managedRepositories or remoteRepositories
     * instead.
     *           
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 

    /**
     * Set The list of repository groups.
     * 
     * @param repositoryGroups
     */
    public void setRepositoryGroups(java.util.List repositoryGroups)
    {
        this.repositoryGroups = repositoryGroups;
    } //-- void setRepositoryGroups(java.util.List) 

    /**
     * Set 
     *             The repository scanning configuration.
     *           
     * 
     * @param repositoryScanning
     */
    public void setRepositoryScanning(RepositoryScanningConfiguration repositoryScanning)
    {
        this.repositoryScanning = repositoryScanning;
    } //-- void setRepositoryScanning(RepositoryScanningConfiguration) 

    /**
     * Set This is the version of the configuration format.
     * 
     * @param version
     */
    public void setVersion(String version)
    {
        this.version = version;
    } //-- void setVersion(String) 

    /**
     * Set 
     *             The webapp configuration.
     *           
     * 
     * @param webapp
     */
    public void setWebapp(WebappConfiguration webapp)
    {
        this.webapp = webapp;
    } //-- void setWebapp(WebappConfiguration) 


    private java.util.Map<String, java.util.List<String>> repositoryToGroupMap; 
    
    public java.util.Map<String, java.util.List<String>> getRepositoryToGroupMap()
    {
        if ( repositoryGroups != null )
        {
            java.util.Map<String, java.util.List<String>> map = new java.util.HashMap<String, java.util.List<String>>();
            
            for ( RepositoryGroupConfiguration group : (java.util.List<RepositoryGroupConfiguration>) repositoryGroups )
            {
                for ( String repositoryId : (java.util.List<String>) group.getRepositories() )
                {
                    java.util.List<String> groups = map.get( repositoryId );
                    if ( groups == null )
                    {
                        groups = new java.util.ArrayList<String>();
                        map.put( repositoryId, groups );
                    }
                    groups.add( group.getId() );
                }
            }
            
            repositoryToGroupMap = map;
        }
        return repositoryToGroupMap;
    }
    
    public java.util.Map<String, RepositoryGroupConfiguration> getRepositoryGroupsAsMap()
    {
        java.util.Map<String, RepositoryGroupConfiguration> map = new java.util.HashMap<String, RepositoryGroupConfiguration>();
        if ( repositoryGroups != null )
        {
            for ( RepositoryGroupConfiguration group : (java.util.List<RepositoryGroupConfiguration>) repositoryGroups )
            {
                map.put( group.getId(), group );
            }
        }
        return map;
    }
    
    public RepositoryGroupConfiguration findRepositoryGroupById( String id )
    {
        if ( repositoryGroups != null )
        {
            for ( RepositoryGroupConfiguration group : (java.util.List<RepositoryGroupConfiguration>) repositoryGroups )
            {
                if ( group.getId().equals( id ) )
                {
                    return group;
                }
            }
        }
        return null;
    }

    private java.util.Map<String, java.util.List<String>> groupToRepositoryMap;
    	
    public java.util.Map<String, java.util.List<String>> getGroupToRepositoryMap()
    {
    	if ( repositoryGroups != null && managedRepositories != null )
        {
            java.util.Map<String, java.util.List<String>> map = new java.util.HashMap<String, java.util.List<String>>();
            
            for ( ManagedRepositoryConfiguration repo : (java.util.List<ManagedRepositoryConfiguration>) managedRepositories )
            {
                for ( RepositoryGroupConfiguration group : (java.util.List<RepositoryGroupConfiguration>) repositoryGroups )
                {
                    if ( !group.getRepositories().contains( repo.getId() ) )
                    {
                        String groupId = group.getId();
                        java.util.List<String> repos = map.get( groupId );
                        if ( repos == null )
                        {
                            repos = new java.util.ArrayList<String>();
                            map.put( groupId, repos );
                        }
                        repos.add( repo.getId() );
                    }
                }
            }
            groupToRepositoryMap = map;
        }
        return groupToRepositoryMap;
    }
          
    public java.util.Map<String, NetworkProxyConfiguration> getNetworkProxiesAsMap()
    {
        java.util.Map<String, NetworkProxyConfiguration> map = new java.util.HashMap<String, NetworkProxyConfiguration>();
        if ( networkProxies != null )
        {
            for ( java.util.Iterator<NetworkProxyConfiguration> i = networkProxies.iterator(); i.hasNext(); )
            {
                NetworkProxyConfiguration proxy = i.next();
                map.put( proxy.getId(), proxy );
            }
        }
        return map;
    }

    public java.util.Map<String, java.util.List<ProxyConnectorConfiguration>> getProxyConnectorAsMap()
    {
        java.util.Map<String, java.util.List<ProxyConnectorConfiguration>> proxyConnectorMap =
            new java.util.HashMap<String, java.util.List<ProxyConnectorConfiguration>>();

        java.util.Iterator<ProxyConnectorConfiguration> it = proxyConnectors.iterator();
        while ( it.hasNext() )
        {
            ProxyConnectorConfiguration proxyConfig = it.next();
            String key = proxyConfig.getSourceRepoId();

            java.util.List<ProxyConnectorConfiguration> connectors = proxyConnectorMap.get( key );
            if ( connectors == null )
            {
                connectors = new java.util.ArrayList<ProxyConnectorConfiguration>();
                proxyConnectorMap.put( key, connectors );
            }

            connectors.add( proxyConfig );
            java.util.Collections.sort( connectors,
                org.apache.maven.archiva.configuration.functors.ProxyConnectorConfigurationOrderComparator.getInstance() );
        }

        return proxyConnectorMap;
    }

    public java.util.Map<String, RemoteRepositoryConfiguration> getRemoteRepositoriesAsMap()
    {
        java.util.Map<String, RemoteRepositoryConfiguration> map = new java.util.HashMap<String, RemoteRepositoryConfiguration>();
        if ( remoteRepositories != null )
        {
            for ( java.util.Iterator<RemoteRepositoryConfiguration> i = remoteRepositories.iterator(); i.hasNext(); )
            {
                RemoteRepositoryConfiguration repo = i.next();
                map.put( repo.getId(), repo );
            }
        }
        return map;
    }

    public RemoteRepositoryConfiguration findRemoteRepositoryById( String id )
    {
        if ( remoteRepositories != null )
        {
            for ( java.util.Iterator<RemoteRepositoryConfiguration> i = remoteRepositories.iterator(); i.hasNext(); )
            {
                RemoteRepositoryConfiguration repo = i.next();
                if ( repo.getId().equals( id ) )
                {
                    return repo;
                }
            }
        }
        return null;
    }

    public java.util.Map<String, ManagedRepositoryConfiguration> getManagedRepositoriesAsMap()
    {
        java.util.Map<String, ManagedRepositoryConfiguration> map = new java.util.HashMap<String, ManagedRepositoryConfiguration>();
        if ( managedRepositories != null )
        {
            for ( java.util.Iterator<ManagedRepositoryConfiguration> i = managedRepositories.iterator(); i.hasNext(); )
            {
                ManagedRepositoryConfiguration repo = i.next();
                map.put( repo.getId(), repo );
            }
        }
        return map;
    }

    public ManagedRepositoryConfiguration findManagedRepositoryById( String id )
    {
        if ( managedRepositories != null )
        {
            for ( java.util.Iterator<ManagedRepositoryConfiguration> i = managedRepositories.iterator(); i.hasNext(); )
            {
                ManagedRepositoryConfiguration repo = i.next();
                if ( repo.getId().equals( id ) )
                {
                    return repo;
                }
            }
        }
        return null;
    }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
