/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class AbstractRepositoryConfiguration implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field name
     */
    private String name;

    /**
     * Field layout
     */
    private String layout = "default";


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *             The repository identifier.
     *           
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Get 
     *             The layout of the repository. Valid values are
     * "default" and "legacy".
     *           
     */
    public String getLayout()
    {
        return this.layout;
    } //-- String getLayout() 

    /**
     * Get 
     *             The descriptive name of the repository.
     *           
     */
    public String getName()
    {
        return this.name;
    } //-- String getName() 

    /**
     * Set 
     *             The repository identifier.
     *           
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set 
     *             The layout of the repository. Valid values are
     * "default" and "legacy".
     *           
     * 
     * @param layout
     */
    public void setLayout(String layout)
    {
        this.layout = layout;
    } //-- void setLayout(String) 

    /**
     * Set 
     *             The descriptive name of the repository.
     *           
     * 
     * @param name
     */
    public void setName(String name)
    {
        this.name = name;
    } //-- void setName(String) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
