/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.configuration.CombinedConfiguration;
import org.apache.maven.archiva.common.utils.Slf4JPlexusLogger;
import org.apache.maven.archiva.configuration.ArchivaConfiguration;
import org.apache.maven.archiva.configuration.Configuration;
import org.apache.maven.archiva.configuration.FileType;
import org.apache.maven.archiva.configuration.functors.FiletypeSelectionPredicate;
import org.apache.maven.archiva.configuration.io.registry.ConfigurationRegistryReader;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.registry.Registry;
import org.codehaus.plexus.registry.RegistryException;
import org.codehaus.plexus.registry.RegistryListener;
import org.codehaus.plexus.registry.commons.CommonsConfigurationRegistry;
import org.codehaus.plexus.util.SelectorUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTypes
implements Initializable,
RegistryListener {
    public static final String ARTIFACTS = "artifacts";
    public static final String AUTO_REMOVE = "auto-remove";
    public static final String INDEXABLE_CONTENT = "indexable-content";
    public static final String IGNORED = "ignored";
    private ArchivaConfiguration archivaConfiguration;
    private Map<String, List<String>> defaultTypeMap = new HashMap<String, List<String>>();
    private List<String> artifactPatterns;
    public static final List<String> DEFAULT_EXCLUSIONS = Arrays.asList("**/maven-metadata.xml", "**/maven-metadata-*.xml", "**/*.sha1", "**/*.asc", "**/*.md5", "**/*.pgp");

    public void setArchivaConfiguration(ArchivaConfiguration archivaConfiguration) {
        this.archivaConfiguration = archivaConfiguration;
    }

    public List<String> getFileTypePatterns(String id) {
        Configuration config = this.archivaConfiguration.getConfiguration();
        FiletypeSelectionPredicate selectedFiletype = new FiletypeSelectionPredicate(id);
        FileType filetype = (FileType)CollectionUtils.find((Collection)config.getRepositoryScanning().getFileTypes(), (Predicate)selectedFiletype);
        if (filetype != null && CollectionUtils.isNotEmpty((Collection)filetype.getPatterns())) {
            return filetype.getPatterns();
        }
        List<String> defaultPatterns = this.defaultTypeMap.get(id);
        if (CollectionUtils.isEmpty(defaultPatterns)) {
            return Collections.singletonList("**/*");
        }
        return defaultPatterns;
    }

    public synchronized boolean matchesArtifactPattern(String relativePath) {
        relativePath = relativePath.replace('\\', '/');
        if (this.artifactPatterns == null) {
            this.artifactPatterns = this.getFileTypePatterns(ARTIFACTS);
        }
        for (String pattern : this.artifactPatterns) {
            if (!SelectorUtils.matchPath((String)pattern, (String)relativePath, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesDefaultExclusions(String relativePath) {
        relativePath = relativePath.replace('\\', '/');
        for (String pattern : DEFAULT_EXCLUSIONS) {
            if (!SelectorUtils.matchPath((String)pattern, (String)relativePath, (boolean)false)) continue;
            return true;
        }
        return false;
    }

    public void initialize() throws InitializationException {
        String errMsg = "Unable to load default archiva configuration for FileTypes: ";
        try {
            CommonsConfigurationRegistry commonsRegistry = new CommonsConfigurationRegistry();
            Field fld = commonsRegistry.getClass().getDeclaredField("configuration");
            fld.setAccessible(true);
            fld.set(commonsRegistry, new CombinedConfiguration());
            commonsRegistry.enableLogging((Logger)new Slf4JPlexusLogger(FileTypes.class));
            commonsRegistry.addConfigurationFromResource("org/apache/maven/archiva/configuration/default-archiva.xml");
            ConfigurationRegistryReader configReader = new ConfigurationRegistryReader();
            Configuration defaultConfig = configReader.read((Registry)commonsRegistry);
            this.initialiseTypeMap(defaultConfig);
        }
        catch (RegistryException e) {
            throw new InitializationException(errMsg + e.getMessage(), (Throwable)e);
        }
        catch (SecurityException e) {
            throw new InitializationException(errMsg + e.getMessage(), (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            throw new InitializationException(errMsg + e.getMessage(), (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            throw new InitializationException(errMsg + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InitializationException(errMsg + e.getMessage(), (Throwable)e);
        }
        this.archivaConfiguration.addChangeListener(this);
    }

    private void initialiseTypeMap(Configuration configuration) {
        this.defaultTypeMap.clear();
        List filetypes = configuration.getRepositoryScanning().getFileTypes();
        for (FileType filetype : filetypes) {
            List<String> patterns = this.defaultTypeMap.get(filetype.getId());
            if (patterns == null) {
                patterns = new ArrayList<String>();
            }
            patterns.addAll(filetype.getPatterns());
            this.defaultTypeMap.put(filetype.getId(), patterns);
        }
    }

    public void afterConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
        if (propertyName.contains("fileType")) {
            this.artifactPatterns = null;
            this.initialiseTypeMap(this.archivaConfiguration.getConfiguration());
        }
    }

    public void beforeConfigurationChange(Registry registry, String propertyName, Object propertyValue) {
    }
}

