/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class RepositoryGroupConfiguration implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field id
     */
    private String id;

    /**
     * Field repositories
     */
    private java.util.List repositories;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addRepository
     * 
     * @param string
     */
    public void addRepository(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "RepositoryGroupConfiguration.addRepositories(string) parameter must be instanceof " + String.class.getName() );
        }
        getRepositories().add( string );
    } //-- void addRepository(String) 

    /**
     * Get The id of the repository group.
     */
    public String getId()
    {
        return this.id;
    } //-- String getId() 

    /**
     * Method getRepositories
     */
    public java.util.List getRepositories()
    {
        if ( this.repositories == null )
        {
            this.repositories = new java.util.ArrayList();
        }
        
        return this.repositories;
    } //-- java.util.List getRepositories() 

    /**
     * Method removeRepository
     * 
     * @param string
     */
    public void removeRepository(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "RepositoryGroupConfiguration.removeRepositories(string) parameter must be instanceof " + String.class.getName() );
        }
        getRepositories().remove( string );
    } //-- void removeRepository(String) 

    /**
     * Set The id of the repository group.
     * 
     * @param id
     */
    public void setId(String id)
    {
        this.id = id;
    } //-- void setId(String) 

    /**
     * Set The list of repository ids under the group.
     * 
     * @param repositories
     */
    public void setRepositories(java.util.List repositories)
    {
        this.repositories = repositories;
    } //-- void setRepositories(java.util.List) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
