/*
 * $Id$
 */

package org.apache.maven.archiva.configuration;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.util.Date;

/**
 * null
 * 
 * @version $Revision$ $Date$
 */
public class AbstractRepositoryConnectorConfiguration implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field sourceRepoId
     */
    private String sourceRepoId;

    /**
     * Field targetRepoId
     */
    private String targetRepoId;

    /**
     * Field proxyId
     */
    private String proxyId;

    /**
     * Field blackListPatterns
     */
    private java.util.List blackListPatterns;

    /**
     * Field whiteListPatterns
     */
    private java.util.List whiteListPatterns;

    /**
     * Field policies
     */
    private java.util.Map policies;

    /**
     * Field properties
     */
    private java.util.Map properties;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addBlackListPattern
     * 
     * @param string
     */
    public void addBlackListPattern(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "AbstractRepositoryConnectorConfiguration.addBlackListPatterns(string) parameter must be instanceof " + String.class.getName() );
        }
        getBlackListPatterns().add( string );
    } //-- void addBlackListPattern(String) 

    /**
     * Method addPolicy
     * 
     * @param key
     * @param value
     */
    public void addPolicy(Object key, String value)
    {
        getPolicies().put( key, value );
    } //-- void addPolicy(Object, String) 

    /**
     * Method addProperty
     * 
     * @param key
     * @param value
     */
    public void addProperty(Object key, String value)
    {
        getProperties().put( key, value );
    } //-- void addProperty(Object, String) 

    /**
     * Method addWhiteListPattern
     * 
     * @param string
     */
    public void addWhiteListPattern(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "AbstractRepositoryConnectorConfiguration.addWhiteListPatterns(string) parameter must be instanceof " + String.class.getName() );
        }
        getWhiteListPatterns().add( string );
    } //-- void addWhiteListPattern(String) 

    /**
     * Method getBlackListPatterns
     */
    public java.util.List getBlackListPatterns()
    {
        if ( this.blackListPatterns == null )
        {
            this.blackListPatterns = new java.util.ArrayList();
        }
        
        return this.blackListPatterns;
    } //-- java.util.List getBlackListPatterns() 

    /**
     * Method getPolicies
     */
    public java.util.Map getPolicies()
    {
        if ( this.policies == null )
        {
            this.policies = new java.util.HashMap();
        }
        
        return this.policies;
    } //-- java.util.Map getPolicies() 

    /**
     * Method getProperties
     */
    public java.util.Map getProperties()
    {
        if ( this.properties == null )
        {
            this.properties = new java.util.HashMap();
        }
        
        return this.properties;
    } //-- java.util.Map getProperties() 

    /**
     * Get 
     *             The network proxy ID to use for this connector.
     *           
     */
    public String getProxyId()
    {
        return this.proxyId;
    } //-- String getProxyId() 

    /**
     * Get 
     *             The Repository Source for this connector.
     *           
     */
    public String getSourceRepoId()
    {
        return this.sourceRepoId;
    } //-- String getSourceRepoId() 

    /**
     * Get 
     *             The Repository Target for this connector.
     *           
     */
    public String getTargetRepoId()
    {
        return this.targetRepoId;
    } //-- String getTargetRepoId() 

    /**
     * Method getWhiteListPatterns
     */
    public java.util.List getWhiteListPatterns()
    {
        if ( this.whiteListPatterns == null )
        {
            this.whiteListPatterns = new java.util.ArrayList();
        }
        
        return this.whiteListPatterns;
    } //-- java.util.List getWhiteListPatterns() 

    /**
     * Method removeBlackListPattern
     * 
     * @param string
     */
    public void removeBlackListPattern(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "AbstractRepositoryConnectorConfiguration.removeBlackListPatterns(string) parameter must be instanceof " + String.class.getName() );
        }
        getBlackListPatterns().remove( string );
    } //-- void removeBlackListPattern(String) 

    /**
     * Method removeWhiteListPattern
     * 
     * @param string
     */
    public void removeWhiteListPattern(String string)
    {
        if ( !(string instanceof String) )
        {
            throw new ClassCastException( "AbstractRepositoryConnectorConfiguration.removeWhiteListPatterns(string) parameter must be instanceof " + String.class.getName() );
        }
        getWhiteListPatterns().remove( string );
    } //-- void removeWhiteListPattern(String) 

    /**
     * Set 
     *             The list of blacklisted patterns for this
     * connector.
     *           
     * 
     * @param blackListPatterns
     */
    public void setBlackListPatterns(java.util.List blackListPatterns)
    {
        this.blackListPatterns = blackListPatterns;
    } //-- void setBlackListPatterns(java.util.List) 

    /**
     * Set Policy configuration for the connector.
     * 
     * @param policies
     */
    public void setPolicies(java.util.Map policies)
    {
        this.policies = policies;
    } //-- void setPolicies(java.util.Map) 

    /**
     * Set Configuration for the connector.
     * 
     * @param properties
     */
    public void setProperties(java.util.Map properties)
    {
        this.properties = properties;
    } //-- void setProperties(java.util.Map) 

    /**
     * Set 
     *             The network proxy ID to use for this connector.
     *           
     * 
     * @param proxyId
     */
    public void setProxyId(String proxyId)
    {
        this.proxyId = proxyId;
    } //-- void setProxyId(String) 

    /**
     * Set 
     *             The Repository Source for this connector.
     *           
     * 
     * @param sourceRepoId
     */
    public void setSourceRepoId(String sourceRepoId)
    {
        this.sourceRepoId = sourceRepoId;
    } //-- void setSourceRepoId(String) 

    /**
     * Set 
     *             The Repository Target for this connector.
     *           
     * 
     * @param targetRepoId
     */
    public void setTargetRepoId(String targetRepoId)
    {
        this.targetRepoId = targetRepoId;
    } //-- void setTargetRepoId(String) 

    /**
     * Set 
     *             The list of whitelisted patterns for this
     * connector.
     *           
     * 
     * @param whiteListPatterns
     */
    public void setWhiteListPatterns(java.util.List whiteListPatterns)
    {
        this.whiteListPatterns = whiteListPatterns;
    } //-- void setWhiteListPatterns(java.util.List) 


    /**
     * Obtain a specific policy from the underlying connector.
     *
     * @param policyId the policy id to fetch.
     * @param defaultValue the default value for the policy id.
     * @return the configured policy value (or default value if not found).
     */
    public String getPolicy( String policyId, String defaultValue )
    {
        if ( this.getPolicies() == null )
        {
            return null;
        }

        Object value = this.getPolicies().get( policyId );

        if ( value == null )
        {
            return defaultValue;
        }

        return (String) value;
    }
          
    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }
}
