/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.common.utils;

import java.io.File;
import java.net.MalformedURLException;
import org.apache.commons.lang.StringUtils;

public class PathUtil {
    public static String toUrl(String path) {
        if (path.startsWith("file:/")) {
            return path;
        }
        return PathUtil.toUrl(new File(path));
    }

    public static String toUrl(File file) {
        try {
            return file.toURL().toExternalForm();
        }
        catch (MalformedURLException e) {
            String pathCorrected = StringUtils.replaceChars((String)file.getAbsolutePath(), (char)'\\', (char)'/');
            if (pathCorrected.startsWith("file:/")) {
                return pathCorrected;
            }
            return "file://" + pathCorrected;
        }
    }

    public static String getRelative(String basedir, File file) {
        return PathUtil.getRelative(basedir, file.getAbsolutePath());
    }

    public static String getRelative(String basedir, String child) {
        if (basedir.endsWith("/") || basedir.endsWith("\\")) {
            basedir = basedir.substring(0, basedir.length() - 1);
        }
        if (child.startsWith(basedir)) {
            return child.substring(basedir.length() + 1);
        }
        String absoluteBasedir = new File(basedir).getAbsolutePath();
        if (child.startsWith(absoluteBasedir)) {
            return child.substring(absoluteBasedir.length() + 1);
        }
        throw new IllegalStateException("Unable to obtain relative path of file " + child + ", it is not within basedir " + basedir + ".");
    }
}

