/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.common.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class VersionUtil {
    private static final String[] versionPatterns = new String[]{"([0-9][_.0-9a-z]*)", "(snapshot)", "(g?[_.0-9ab]*(pre|rc|g|m)[_.0-9]*)", "(dev[_.0-9]*)", "(alpha[_.0-9]*)", "(beta[_.0-9]*)", "(rc[_.0-9]*)", "(debug[_.0-9]*)", "(unofficial[_.0-9]*)", "(current)", "(latest)", "(fcs)", "(release[_.0-9]*)", "(nightly)", "(final)", "(incubating)", "(incubator)", "([ab][_.0-9]+)"};
    public static final String SNAPSHOT = "SNAPSHOT";
    public static final Pattern UNIQUE_SNAPSHOT_PATTERN = Pattern.compile("^(.*)-([0-9]{8}\\.[0-9]{6})-([0-9]+)$");
    public static final Pattern TIMESTAMP_PATTERN = Pattern.compile("^([0-9]{8})\\.([0-9]{6})$");
    public static final Pattern GENERIC_SNAPSHOT_PATTERN = Pattern.compile("^(.*)-SNAPSHOT");
    private static final Pattern VERSION_MEGA_PATTERN = Pattern.compile(StringUtils.join((Object[])versionPatterns, (char)'|'), 2);

    public static boolean isVersion(String unknown) {
        String[] versionParts = StringUtils.split((String)unknown, (char)'-');
        int countValidParts = 0;
        for (int i = 0; i < versionParts.length; ++i) {
            String part = versionParts[i];
            Matcher mat = VERSION_MEGA_PATTERN.matcher(part);
            if (!mat.matches()) continue;
            ++countValidParts;
        }
        int threshold = (int)Math.floor(Math.max(1.0, (double)versionParts.length * 0.75));
        return countValidParts >= threshold;
    }

    public static boolean isSimpleVersionKeyword(String identifier) {
        Matcher mat = VERSION_MEGA_PATTERN.matcher(identifier);
        return mat.matches();
    }

    public static boolean isSnapshot(String version) {
        Matcher m = UNIQUE_SNAPSHOT_PATTERN.matcher(version);
        if (m.matches()) {
            return true;
        }
        return version.endsWith(SNAPSHOT);
    }

    public static String getBaseVersion(String version) {
        Matcher m = UNIQUE_SNAPSHOT_PATTERN.matcher(version);
        if (m.matches()) {
            return m.group(1) + "-" + SNAPSHOT;
        }
        return version;
    }

    public static String getReleaseVersion(String snapshotVersion) {
        Matcher m = UNIQUE_SNAPSHOT_PATTERN.matcher(snapshotVersion);
        if (VersionUtil.isGenericSnapshot(snapshotVersion)) {
            m = GENERIC_SNAPSHOT_PATTERN.matcher(snapshotVersion);
        }
        if (m.matches()) {
            return m.group(1);
        }
        return snapshotVersion;
    }

    public static boolean isUniqueSnapshot(String version) {
        Matcher m = UNIQUE_SNAPSHOT_PATTERN.matcher(version);
        return m.matches();
    }

    public static boolean isGenericSnapshot(String version) {
        return version.endsWith(SNAPSHOT);
    }
}

