/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.api.impl;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.apex.malhar.stream.api.Option;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public class DagMeta {
    private List<NodeMeta> heads = new LinkedList<NodeMeta>();
    List<Pair<Attribute, Object>> dagAttributes = new LinkedList<Pair<Attribute, Object>>();
    private static final Logger logger = LoggerFactory.getLogger(DagMeta.class);

    public DAG buildDAG() {
        LogicalPlan dag = new LogicalPlan();
        this.buildDAG((DAG)dag);
        return dag;
    }

    public void buildDAG(DAG dag) {
        for (NodeMeta nm : this.heads) {
            this.visitNode(nm, dag);
        }
        logger.debug("Finish building the dag:\n {}", (Object)dag.toString());
    }

    private void visitNode(NodeMeta nm, DAG dag) {
        String opName = nm.getOperatorName();
        logger.debug("Building DAG: add operator {}: {}", (Object)opName, (Object)nm.operator);
        dag.addOperator(opName, nm.operator);
        for (NodeMeta nodeMeta : nm.children) {
            this.visitNode(nodeMeta, dag);
        }
        for (Map.Entry entry : nm.nodeStreams.entrySet()) {
            if (entry.getKey() == null || ((Pair)entry.getValue()).getKey() == null || 0 == ((List)((Pair)entry.getValue()).getKey()).size()) continue;
            logger.debug("Building DAG: add stream {} from {} to {}", new Object[]{((Operator.OutputPort)entry.getKey()).toString(), entry.getKey(), ((List)((Pair)entry.getValue()).getLeft()).toArray(new Operator.InputPort[0])});
            DAG.StreamMeta streamMeta = dag.addStream(((Operator.OutputPort)entry.getKey()).toString(), (Operator.OutputPort)entry.getKey(), ((List)((Pair)entry.getValue()).getLeft()).toArray(new Operator.InputPort[0]));
            if (((Pair)entry.getValue()).getRight() != null) {
                logger.debug("Building DAG: set locality of the stream {} to {}", (Object)((Operator.OutputPort)entry.getKey()).toString(), ((Pair)entry.getValue()).getRight());
                streamMeta.setLocality((DAG.Locality)((Pair)entry.getValue()).getRight());
            }
            if (!nm.outputPortAttributes.containsKey(entry.getKey())) continue;
            for (Pair<Attribute, Object> attr : nm.outputPortAttributes.get(entry.getKey())) {
                logger.debug("Building DAG: set port attribute {} to {} for port {}", new Object[]{attr.getLeft(), attr.getValue(), entry.getKey()});
                dag.setOutputPortAttribute((Operator.OutputPort)entry.getKey(), (Attribute)attr.getLeft(), attr.getValue());
            }
        }
        for (Operator.InputPort inputPort : nm.operatorInputs) {
            if (!nm.inputPortAttributes.containsKey(inputPort)) continue;
            for (Pair<Attribute, Object> attr : nm.inputPortAttributes.get(inputPort)) {
                logger.debug("Building DAG: set port attribute {} to {} for port {}", new Object[]{attr.getLeft(), attr.getValue(), inputPort});
                dag.setInputPortAttribute(inputPort, (Attribute)attr.getLeft(), attr.getValue());
            }
        }
        for (Pair pair : nm.operatorAttributes) {
            logger.debug("Building DAG: set operator attribute {} to {} for operator {}", new Object[]{pair.getLeft(), pair.getValue(), nm.operator});
            dag.setAttribute(nm.operator, (Attribute)pair.getLeft(), pair.getValue());
        }
    }

    public NodeMeta addNode(Operator operator, NodeMeta parent, Operator.OutputPort parentOutput, Operator.InputPort inputPort, Option ... options) {
        NodeMeta newNode = new NodeMeta(operator, options);
        if (parent == null) {
            this.heads.add(newNode);
        } else {
            ((List)((Pair)parent.nodeStreams.get(parentOutput)).getLeft()).add(inputPort);
            parent.children.add(newNode);
            newNode.parent.add(parent);
        }
        return newNode;
    }

    public static class NodeMeta {
        private Operator operator;
        private Option[] options;
        List<Pair<Attribute, Object>> operatorAttributes = new LinkedList<Pair<Attribute, Object>>();
        private Map<Operator.OutputPort, Pair<List<Operator.InputPort>, DAG.Locality>> nodeStreams = new HashMap<Operator.OutputPort, Pair<List<Operator.InputPort>, DAG.Locality>>();
        Map<Operator.OutputPort, List<Pair<Attribute, Object>>> outputPortAttributes = new HashMap<Operator.OutputPort, List<Pair<Attribute, Object>>>();
        Map<Operator.InputPort, List<Pair<Attribute, Object>>> inputPortAttributes = new HashMap<Operator.InputPort, List<Pair<Attribute, Object>>>();
        private Set<Operator.InputPort> operatorInputs = new HashSet<Operator.InputPort>();
        private List<NodeMeta> children = new LinkedList<NodeMeta>();
        private List<NodeMeta> parent = new LinkedList<NodeMeta>();

        public List<NodeMeta> getParent() {
            return this.parent;
        }

        public List<NodeMeta> getChildren() {
            return this.children;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Map<Operator.OutputPort, Pair<List<Operator.InputPort>, DAG.Locality>> getNodeStreams() {
            return this.nodeStreams;
        }

        public NodeMeta(Operator operator, Option ... options) {
            this.operator = operator;
            this.options = options;
            for (Field field : this.operator.getClass().getFields()) {
                int modifier = field.getModifiers();
                if (Modifier.isPublic(modifier) && Modifier.isTransient(modifier) && Operator.OutputPort.class.isAssignableFrom(field.getType())) {
                    try {
                        this.nodeStreams.put((Operator.OutputPort)field.get(operator), (Pair<List<Operator.InputPort>, DAG.Locality>)MutablePair.of(new LinkedList(), null));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if (!Modifier.isPublic(modifier) || !Modifier.isTransient(modifier) || !Operator.InputPort.class.isAssignableFrom(field.getType())) continue;
                try {
                    this.operatorInputs.add((Operator.InputPort)field.get(operator));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }

        public String getOperatorName() {
            for (Option opt : this.options) {
                if (!(opt instanceof Option.OpName)) continue;
                return ((Option.OpName)opt).getName();
            }
            return this.operator.toString();
        }
    }
}

