/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.api.impl;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.LocalMode;
import com.datatorrent.api.Operator;
import com.datatorrent.lib.io.ConsoleOutputOperator;
import com.datatorrent.stram.StramLocalCluster;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.apex.malhar.lib.function.Function;
import org.apache.apex.malhar.lib.function.FunctionOperator;
import org.apache.apex.malhar.lib.window.TriggerOption;
import org.apache.apex.malhar.lib.window.WindowOption;
import org.apache.apex.malhar.stream.api.ApexStream;
import org.apache.apex.malhar.stream.api.CompositeStreamTransform;
import org.apache.apex.malhar.stream.api.Option;
import org.apache.apex.malhar.stream.api.WindowedStream;
import org.apache.apex.malhar.stream.api.impl.ApexWindowedStreamImpl;
import org.apache.apex.malhar.stream.api.impl.DagMeta;
import org.apache.apex.malhar.stream.api.impl.IDGenerator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.classification.InterfaceStability;
import org.joda.time.Duration;

@InterfaceStability.Evolving
public class ApexStreamImpl<T>
implements ApexStream<T> {
    private static Set<Attribute<?>> OPERATOR_ATTRIBUTES = new HashSet();
    private static Set<Attribute<?>> DAG_ATTRIBUTES = new HashSet();
    private static Set<Attribute<?>> INPUT_ATTRIBUTES = new HashSet();
    private static Set<Attribute<?>> OUTPUT_ATTRIBUTES = new HashSet();
    protected DagMeta graph;
    protected Brick<T> lastBrick;

    public Brick<T> getLastBrick() {
        return this.lastBrick;
    }

    public void setLastBrick(Brick<T> lastBrick) {
        this.lastBrick = lastBrick;
    }

    public ApexStreamImpl() {
        this.graph = new DagMeta();
    }

    public ApexStreamImpl(ApexStreamImpl<T> apexStream) {
        this.graph = apexStream.graph;
        this.lastBrick = apexStream.lastBrick;
    }

    public ApexStreamImpl(DagMeta graph) {
        this(graph, null);
    }

    public ApexStreamImpl(DagMeta graph, Brick<T> lastBrick) {
        this.graph = graph;
        this.lastBrick = lastBrick;
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM map(Function.MapFunction<T, O> mf, Option ... opts) {
        FunctionOperator.MapFunctionOperator opt = new FunctionOperator.MapFunctionOperator(mf);
        return this.addOperator((Operator)opt, (Operator.InputPort<T>)opt.input, (Operator.OutputPort<O>)opt.output, opts);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM flatMap(Function.FlatMapFunction<T, O> flatten, Option ... opts) {
        FunctionOperator.FlatMapFunctionOperator opt = new FunctionOperator.FlatMapFunctionOperator(flatten);
        return this.addOperator((Operator)opt, (Operator.InputPort<T>)opt.input, (Operator.OutputPort<O>)opt.output, opts);
    }

    @Override
    public <STREAM extends ApexStream<T>> STREAM filter(Function.FilterFunction<T> filter, Option ... opts) {
        FunctionOperator.FilterFunctionOperator filterFunctionOperator = new FunctionOperator.FilterFunctionOperator(filter);
        return this.addOperator((Operator)filterFunctionOperator, (Operator.InputPort<T>)filterFunctionOperator.input, (Operator.OutputPort)filterFunctionOperator.output, opts);
    }

    public <STREAM extends ApexStream<Map.Entry<Object, Integer>>> STREAM countByElement() {
        return null;
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM endWith(Operator op, Operator.InputPort<T> inputPort, Option ... opts) {
        return this.addOperator(op, inputPort, null, opts);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM addOperator(Operator op, Operator.InputPort<T> inputPort, Operator.OutputPort<O> outputPort, Option ... opts) {
        this.checkArguments(op, inputPort, outputPort);
        DagMeta.NodeMeta nm = null;
        nm = this.lastBrick == null ? this.graph.addNode(op, null, null, inputPort, opts) : this.graph.addNode(op, ((Brick)this.lastBrick).nodeMeta, ((Brick)this.lastBrick).lastOutput, inputPort, opts);
        Brick<O> newBrick = new Brick<O>();
        ((Brick)newBrick).nodeMeta = nm;
        newBrick.setLastOutput(outputPort);
        if (this.lastBrick != null) {
            ((Brick)newBrick).lastStream = Pair.of((Object)((Brick)this.lastBrick).lastOutput, inputPort);
        }
        if (this.getClass() == ApexStreamImpl.class || this.getClass() == ApexWindowedStreamImpl.class) {
            return (STREAM)this.newStream(this.graph, newBrick);
        }
        try {
            return (STREAM)((ApexStream)this.getClass().getConstructor(ApexStreamImpl.class).newInstance(this.newStream(this.graph, newBrick)));
        }
        catch (Exception e) {
            throw new RuntimeException("You have to override the default constructor with ApexStreamImpl as default parameter", e);
        }
    }

    @Override
    public <O, INSTREAM extends ApexStream<T>, OUTSTREAM extends ApexStream<O>> OUTSTREAM addCompositeStreams(CompositeStreamTransform<INSTREAM, OUTSTREAM> compositeStreamTransform) {
        return compositeStreamTransform.compose(this);
    }

    private void checkArguments(Operator op, Operator.InputPort inputPort, Operator.OutputPort outputPort) {
        if (op == null) {
            throw new IllegalArgumentException("Operator can not be null");
        }
        boolean foundInput = inputPort == null;
        boolean foundOutput = outputPort == null;
        for (Field f : op.getClass().getFields()) {
            int modifiers = f.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isTransient(modifiers)) continue;
            Object obj = null;
            try {
                obj = f.get(op);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (obj == outputPort) {
                foundOutput = true;
            }
            if (obj != inputPort) continue;
            foundInput = true;
        }
        if (!foundInput || !foundOutput) {
            throw new IllegalArgumentException("Input port " + inputPort + " and/or Output port " + outputPort + " is/are not owned by Operator " + op);
        }
    }

    @Override
    public <STREAM extends ApexStream<T>> STREAM union(ApexStream<T> ... others) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ApexStreamImpl<T> print(Option ... opts) {
        ConsoleOutputOperator consoleOutputOperator = new ConsoleOutputOperator();
        this.addOperator((Operator)consoleOutputOperator, (Operator.InputPort<T>)consoleOutputOperator.input, null, opts);
        return this;
    }

    @Override
    public ApexStreamImpl<T> print() {
        ConsoleOutputOperator consoleOutputOperator = new ConsoleOutputOperator();
        this.addOperator((Operator)consoleOutputOperator, (Operator.InputPort<T>)consoleOutputOperator.input, null, Option.Options.name(IDGenerator.generateOperatorIDWithUUID(consoleOutputOperator.getClass())));
        return this;
    }

    @Override
    public ApexStream<T> printErr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ApexStream<T> with(Attribute attribute, Object value) {
        if (OPERATOR_ATTRIBUTES.contains(attribute)) {
            ((Brick)this.lastBrick).nodeMeta.operatorAttributes.add((Pair<Attribute, Object>)Pair.of((Object)attribute, (Object)value));
        }
        if (INPUT_ATTRIBUTES.contains(attribute) && ((Brick)this.lastBrick).lastStream != null) {
            List<Pair<Attribute, Object>> attrs = ((Brick)this.lastBrick).nodeMeta.inputPortAttributes.get(((Brick)this.lastBrick).lastStream.getRight());
            if (attrs == null) {
                attrs = new LinkedList<Pair<Attribute, Object>>();
            }
            attrs.add((Pair<Attribute, Object>)Pair.of((Object)attribute, (Object)value));
            ((Brick)this.lastBrick).nodeMeta.inputPortAttributes.put((Operator.InputPort)((Brick)this.lastBrick).lastStream.getRight(), attrs);
        }
        if (OUTPUT_ATTRIBUTES.contains(attribute) && ((Brick)this.lastBrick).lastStream != null) {
            for (DagMeta.NodeMeta parent : ((Brick)this.lastBrick).nodeMeta.getParent()) {
                parent.getNodeStreams().containsKey(((Brick)this.lastBrick).lastStream.getLeft());
                List<Pair<Attribute, Object>> attrs = parent.outputPortAttributes.get(((Brick)this.lastBrick).lastStream.getLeft());
                if (attrs == null) {
                    attrs = new LinkedList<Pair<Attribute, Object>>();
                }
                attrs.add((Pair<Attribute, Object>)Pair.of((Object)attribute, (Object)value));
                ((Brick)this.lastBrick).nodeMeta.outputPortAttributes.put((Operator.OutputPort)((Brick)this.lastBrick).lastStream.getLeft(), attrs);
            }
        }
        this.setGlobalAttribute(attribute, value);
        return this;
    }

    @Override
    public ApexStream<T> setGlobalAttribute(Attribute attribute, Object value) {
        this.graph.dagAttributes.add((Pair<Attribute, Object>)Pair.of((Object)attribute, (Object)value));
        return this;
    }

    @Override
    public ApexStream<T> with(DAG.Locality locality) {
        if (((Brick)this.lastBrick).lastStream != null) {
            for (DagMeta.NodeMeta parent : ((Brick)this.lastBrick).nodeMeta.getParent()) {
                Pair<List<Operator.InputPort>, DAG.Locality> p = parent.getNodeStreams().get(((Brick)this.lastBrick).lastStream.getLeft());
                if (p == null) continue;
                p.setValue((Object)locality);
            }
        }
        return this;
    }

    @Override
    public ApexStream<T> with(String propName, Object value) {
        try {
            BeanUtils.setProperty((Object)((Brick)this.lastBrick).nodeMeta.getOperator(), (String)propName, (Object)value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public DAG createDag() {
        LogicalPlan dag = new LogicalPlan();
        this.populateDag((DAG)dag);
        return dag;
    }

    @Override
    public void populateDag(DAG dag) {
        this.graph.buildDAG(dag);
    }

    @Override
    public void runEmbedded(boolean async, long duration, Callable<Boolean> exitCondition) {
        LocalMode lma = LocalMode.newInstance();
        this.populateDag(lma.getDAG());
        DAG dag = lma.getDAG();
        LocalMode.Controller lc = lma.getController();
        if (lc instanceof StramLocalCluster) {
            ((StramLocalCluster)lc).setExitCondition(exitCondition);
        }
        if (async) {
            lc.runAsync();
        } else if (duration >= 0L) {
            lc.run(duration);
        } else {
            lc.run();
        }
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WindowedStream<T> window(WindowOption option) {
        return this.window(option, null, null);
    }

    @Override
    public WindowedStream<T> window(WindowOption windowOption, TriggerOption triggerOption) {
        return this.window(windowOption, triggerOption, null);
    }

    @Override
    public WindowedStream<T> window(WindowOption windowOption, TriggerOption triggerOption, Duration allowLateness) {
        ApexWindowedStreamImpl windowedStream = new ApexWindowedStreamImpl();
        windowedStream.lastBrick = this.lastBrick;
        windowedStream.graph = this.graph;
        windowedStream.windowOption = windowOption;
        windowedStream.triggerOption = triggerOption;
        windowedStream.allowedLateness = allowLateness;
        return windowedStream;
    }

    protected <O> ApexStream<O> newStream(DagMeta graph, Brick<O> newBrick) {
        ApexStreamImpl<T> newstream = new ApexStreamImpl<T>();
        newstream.graph = graph;
        newstream.lastBrick = newBrick;
        return newstream;
    }

    static {
        try {
            for (Field field : Context.OperatorContext.class.getDeclaredFields()) {
                if (field.getType() != Attribute.class) continue;
                OPERATOR_ATTRIBUTES.add((Attribute)field.get(Context.OperatorContext.class));
            }
            for (Field field : Context.DAGContext.class.getDeclaredFields()) {
                if (field.getType() != Attribute.class) continue;
                DAG_ATTRIBUTES.add((Attribute)field.get(Context.DAGContext.class));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        INPUT_ATTRIBUTES.add(Context.PortContext.PARTITION_PARALLEL);
        INPUT_ATTRIBUTES.add(Context.PortContext.AUTO_RECORD);
        INPUT_ATTRIBUTES.add(Context.PortContext.STREAM_CODEC);
        INPUT_ATTRIBUTES.add(Context.PortContext.TUPLE_CLASS);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.QUEUE_CAPACITY);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.BUFFER_MEMORY_MB);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.SPIN_MILLIS);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.UNIFIER_SINGLE_FINAL);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.IS_OUTPUT_UNIFIED);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.AUTO_RECORD);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.STREAM_CODEC);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.TUPLE_CLASS);
    }

    public static class Brick<T> {
        private Operator.OutputPort<T> lastOutput;
        private DagMeta.NodeMeta nodeMeta;
        private Pair<Operator.OutputPort, Operator.InputPort> lastStream;

        public Operator.OutputPort<T> getLastOutput() {
            return this.lastOutput;
        }

        public void setLastOutput(Operator.OutputPort<T> lastOutput) {
            this.lastOutput = lastOutput;
        }

        public void setLastStream(Pair<Operator.OutputPort, Operator.InputPort> lastStream) {
            this.lastStream = lastStream;
        }

        public Pair<Operator.OutputPort, Operator.InputPort> getLastStream() {
            return this.lastStream;
        }
    }
}

