/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.api;

import com.datatorrent.api.Attribute;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public interface Option {

    public static class AttributeSetting<T>
    implements Option {
        private Attribute<T> attr;
        private T value;

        public AttributeSetting(Attribute<T> attr, T value) {
            this.attr = attr;
            this.value = value;
        }

        public Attribute<T> getAttr() {
            return this.attr;
        }

        public T getValue() {
            return this.value;
        }
    }

    public static class PropSetting
    implements Option {
        private String name;
        private Object val;

        public PropSetting(String name, Object val) {
            this.name = name;
            this.val = val;
        }

        public String getName() {
            return this.name;
        }

        public Object getVal() {
            return this.val;
        }
    }

    public static class OpName
    implements Option {
        private String name;

        public OpName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Options {
        public static Option name(String name) {
            return new OpName(name);
        }

        public static Option prop(String name, Object value) {
            return new PropSetting(name, value);
        }

        public static <T> Option attr(Attribute<T> attr, T obj) {
            return new AttributeSetting<T>(attr, obj);
        }
    }
}

