/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.sample;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import com.datatorrent.common.util.BaseOperator;
import com.google.common.base.Throwables;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class WCInput
extends BaseOperator
implements InputOperator {
    public final transient DefaultOutputPort<String> output = new DefaultOutputPort();
    private transient BufferedReader reader;

    public void setup(Context.OperatorContext context) {
        this.initReader();
    }

    private void initReader() {
        try {
            Path myPath = new Path("/user/siyuan/wc/wordcount");
            FileSystem fs = FileSystem.get((Configuration)new Configuration());
            this.reader = new BufferedReader(new InputStreamReader((InputStream)fs.open(myPath)));
        }
        catch (Exception ex) {
            throw Throwables.propagate((Throwable)ex);
        }
    }

    public void teardown() {
        IOUtils.closeQuietly((Reader)this.reader);
    }

    public void emitTuples() {
        try {
            String line = this.reader.readLine();
            if (line == null) {
                this.reader.close();
                this.initReader();
            } else {
                this.output.emit((Object)line);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void endWindow() {
    }
}

