/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.sample;

import com.datatorrent.lib.util.KeyValPair;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.apex.malhar.lib.function.Function;
import org.apache.apex.malhar.lib.window.TriggerOption;
import org.apache.apex.malhar.lib.window.Tuple;
import org.apache.apex.malhar.lib.window.WindowOption;
import org.apache.apex.malhar.stream.api.Option;
import org.apache.apex.malhar.stream.api.impl.StreamFactory;
import org.apache.apex.malhar.stream.sample.TupleCollector;
import org.junit.Assert;
import org.junit.Test;

public class LocalTestWithoutStreamApplication {
    @Test
    public void testNonStreamApplicationWordcount() throws Exception {
        TupleCollector collector = new TupleCollector();
        collector.id = "testNonStreamApplicationWordcount";
        final HashMap<String, Long> expected = new HashMap<String, Long>();
        expected.put("error", 2L);
        expected.put("word1", 4L);
        expected.put("word2", 8L);
        expected.put("word3", 4L);
        expected.put("word4", 4L);
        expected.put("word5", 4L);
        expected.put("word7", 4L);
        expected.put("word9", 6L);
        Callable<Boolean> exitCondition = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                if (!TupleCollector.results.containsKey("testNonStreamApplicationWordcount") || TupleCollector.results.get("testNonStreamApplicationWordcount").isEmpty()) {
                    return false;
                }
                HashMap<Object, Object> data = new HashMap<Object, Object>();
                for (Tuple.TimestampedTuple entry : TupleCollector.results.get("testNonStreamApplicationWordcount")) {
                    data.put(((KeyValPair)entry.getValue()).getKey(), ((KeyValPair)entry.getValue()).getValue());
                }
                return data.size() >= 8 && expected.equals(data);
            }
        };
        StreamFactory.fromFolder((String)"./src/test/resources/data").flatMap((Function.FlatMapFunction)new Function.FlatMapFunction<String, String>(){

            public Iterable<String> f(String input) {
                return Arrays.asList(input.split(" "));
            }
        }, new Option[0]).window((WindowOption)new WindowOption.GlobalWindow(), new TriggerOption().accumulatingFiredPanes().withEarlyFiringsAtEvery(1L)).countByKey((Function.ToKeyValue)new Function.ToKeyValue<String, String, Long>(){

            public Tuple<KeyValPair<String, Long>> f(String input) {
                return new Tuple.PlainTuple((Object)new KeyValPair((Object)input, (Object)1L));
            }
        }, new Option[0]).addOperator(collector, collector.inputPort, null, new Option[0]).runEmbedded(false, 30000L, (Callable)exitCondition);
        HashMap<Object, Object> data = new HashMap<Object, Object>();
        for (Tuple.TimestampedTuple entry : TupleCollector.results.get("testNonStreamApplicationWordcount")) {
            data.put(((KeyValPair)entry.getValue()).getKey(), ((KeyValPair)entry.getValue()).getValue());
        }
        Assert.assertNotNull(data);
        Assert.assertTrue((data.size() > 1 ? 1 : 0) != 0);
        Assert.assertEquals(expected, data);
    }
}

