/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.api.operator;

import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.esotericsoftware.reflectasm.shaded.org.objectweb.asm.ClassReader;
import com.esotericsoftware.reflectasm.shaded.org.objectweb.asm.ClassVisitor;
import com.esotericsoftware.reflectasm.shaded.org.objectweb.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.validation.constraints.NotNull;
import org.apache.apex.malhar.stream.api.function.Function;
import org.apache.apex.malhar.stream.api.operator.AnnonymousClassModifier;
import org.apache.apex.malhar.stream.api.operator.ByteArrayClassLoader;
import org.apache.commons.io.IOUtils;

public class FunctionOperator<OUT, FUNCTION extends Function>
implements Operator {
    private byte[] annonymousFunctionClass;
    protected transient FUNCTION statelessF;
    protected FUNCTION statefulF;
    protected boolean stateful = false;
    protected boolean isAnnonymous = false;
    public final transient DefaultOutputPort<OUT> output = new DefaultOutputPort();

    public FunctionOperator(FUNCTION f) {
        this.isAnnonymous = f.getClass().isAnonymousClass();
        if (this.isAnnonymous) {
            this.annonymousFunctionClass = this.functionClassData((Function)f);
        } else if (f instanceof Function.Stateful) {
            this.statelessF = f;
        } else {
            this.statefulF = f;
            this.stateful = true;
        }
    }

    private byte[] functionClassData(Function f) {
        Class<?> classT = f.getClass();
        byte[] classBytes = null;
        byte[] classNameBytes = null;
        String className = classT.getName();
        try {
            classNameBytes = className.replace('.', '/').getBytes();
            classBytes = IOUtils.toByteArray((InputStream)classT.getClassLoader().getResourceAsStream(className.replace('.', '/') + ".class"));
            int cursor = 0;
            for (int j = 0; j < classBytes.length; ++j) {
                cursor = classBytes[j] != classNameBytes[cursor] ? 0 : ++cursor;
                if (cursor != classNameBytes.length) continue;
                for (int p = 0; p < classNameBytes.length; ++p) {
                    if (classBytes[j - p] != 36) continue;
                    classBytes[j - p] = 95;
                }
                cursor = 0;
            }
            ClassReader cr = new ClassReader((InputStream)new ByteArrayInputStream(classBytes));
            ClassWriter cw = new ClassWriter(0);
            AnnonymousClassModifier annonymousClassModifier = new AnnonymousClassModifier(262144, (ClassVisitor)cw);
            cr.accept((ClassVisitor)annonymousClassModifier, 0);
            classBytes = cw.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        int dataLength = classNameBytes.length + 4 + 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(dataLength);
        DataOutputStream output = new DataOutputStream(byteArrayOutputStream);
        try {
            output.writeInt(classNameBytes.length);
            output.write(className.replace('$', '_').getBytes());
            output.writeInt(classBytes.length);
            output.write(classBytes);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                output.flush();
                output.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return byteArrayOutputStream.toByteArray();
    }

    public FunctionOperator() {
    }

    public void beginWindow(long l) {
    }

    public void endWindow() {
    }

    public void setup(Context.OperatorContext context) {
        this.readFunction();
    }

    private void readFunction() {
        try {
            if (this.statelessF != null || this.statefulF != null) {
                return;
            }
            DataInputStream input = new DataInputStream(new ByteArrayInputStream(this.annonymousFunctionClass));
            byte[] classNameBytes = new byte[input.readInt()];
            input.read(classNameBytes);
            String className = new String(classNameBytes);
            byte[] classData = new byte[input.readInt()];
            input.read(classData);
            HashMap<String, byte[]> classBin = new HashMap<String, byte[]>();
            classBin.put(className, classData);
            ByteArrayClassLoader byteArrayClassLoader = new ByteArrayClassLoader(classBin, Thread.currentThread().getContextClassLoader());
            this.statelessF = (Function)byteArrayClassLoader.findClass(className).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void teardown() {
    }

    public FUNCTION getFunction() {
        this.readFunction();
        if (this.stateful) {
            return this.statefulF;
        }
        return this.statelessF;
    }

    public FUNCTION getStatelessF() {
        return this.statelessF;
    }

    public void setStatelessF(FUNCTION statelessF) {
        this.statelessF = statelessF;
    }

    public FUNCTION getStatefulF() {
        return this.statefulF;
    }

    public void setStatefulF(FUNCTION statefulF) {
        this.statefulF = statefulF;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public boolean isAnnonymous() {
        return this.isAnnonymous;
    }

    public void setIsAnnonymous(boolean isAnnonymous) {
        this.isAnnonymous = isAnnonymous;
    }

    public static class FilterFunctionOperator<IN>
    extends FunctionOperator<IN, Function.FilterFunction<IN>> {
        public final transient DefaultInputPort<IN> input = new DefaultInputPort<IN>(){

            public void process(IN t) {
                Function.FilterFunction f = (Function.FilterFunction)FilterFunctionOperator.this.getFunction();
                if (((Boolean)f.f(t)).booleanValue()) {
                    FilterFunctionOperator.this.output.emit(t);
                }
            }
        };

        public FilterFunctionOperator() {
        }

        public FilterFunctionOperator(Function.FilterFunction<IN> f) {
            super(f);
        }
    }

    public static class ReduceFunctionOperator<IN>
    extends FunctionOperator<IN, Function.ReduceFunction<IN>> {
        @NotNull
        private IN reducedVal;
        public final transient DefaultInputPort<IN> input = new DefaultInputPort<IN>(){

            public void process(IN t) {
                Function.ReduceFunction f = (Function.ReduceFunction)ReduceFunctionOperator.this.getFunction();
                if (ReduceFunctionOperator.this.reducedVal == null) {
                    ReduceFunctionOperator.this.reducedVal = t;
                    return;
                }
                ReduceFunctionOperator.this.reducedVal = f.reduce(t, ReduceFunctionOperator.this.reducedVal);
                ReduceFunctionOperator.this.output.emit(ReduceFunctionOperator.this.reducedVal);
            }
        };

        public ReduceFunctionOperator() {
        }

        public ReduceFunctionOperator(Function.ReduceFunction<IN> f) {
            super(f);
        }
    }

    public static class FoldFunctionOperator<IN, OUT>
    extends FunctionOperator<OUT, Function.FoldFunction<IN, OUT>> {
        @NotNull
        private OUT foldVal;
        public final transient DefaultInputPort<IN> input = new DefaultInputPort<IN>(){

            public void process(IN t) {
                Function.FoldFunction f = (Function.FoldFunction)FoldFunctionOperator.this.getFunction();
                FoldFunctionOperator.this.foldVal = f.fold(t, FoldFunctionOperator.this.foldVal);
                FoldFunctionOperator.this.output.emit(FoldFunctionOperator.this.foldVal);
            }
        };

        public FoldFunctionOperator() {
        }

        public FoldFunctionOperator(Function.FoldFunction<IN, OUT> f, OUT initialVal) {
            super(f);
            this.foldVal = initialVal;
        }
    }

    public static class FlatMapFunctionOperator<IN, OUT>
    extends FunctionOperator<OUT, Function.FlatMapFunction<IN, OUT>> {
        public final transient DefaultInputPort<IN> input = new DefaultInputPort<IN>(){

            public void process(IN t) {
                Function.FlatMapFunction f = (Function.FlatMapFunction)FlatMapFunctionOperator.this.getFunction();
                for (Object out : (Iterable)f.f(t)) {
                    FlatMapFunctionOperator.this.output.emit(out);
                }
            }
        };

        public FlatMapFunctionOperator() {
        }

        public FlatMapFunctionOperator(Function.FlatMapFunction<IN, OUT> f) {
            super(f);
        }
    }

    public static class MapFunctionOperator<IN, OUT>
    extends FunctionOperator<OUT, Function.MapFunction<IN, OUT>> {
        public final transient DefaultInputPort<IN> input = new DefaultInputPort<IN>(){

            public void process(IN t) {
                Function.MapFunction f = (Function.MapFunction)MapFunctionOperator.this.getFunction();
                MapFunctionOperator.this.output.emit(f.f(t));
            }
        };

        public MapFunctionOperator() {
        }

        public MapFunctionOperator(Function.MapFunction<IN, OUT> f) {
            super(f);
        }
    }
}

