/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.api.impl;

import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import com.datatorrent.contrib.kafka.KafkaSinglePortStringInputOperator;
import org.apache.apex.malhar.lib.fs.LineByLineFileInputOperator;
import org.apache.apex.malhar.stream.api.ApexStream;
import org.apache.apex.malhar.stream.api.impl.ApexStreamImpl;

public class StreamFactory {
    public static ApexStream<String> fromFolder(String inputOperatorName, String folderName) {
        LineByLineFileInputOperator fileLineInputOperator = new LineByLineFileInputOperator();
        fileLineInputOperator.setDirectory(folderName);
        ApexStreamImpl newStream = new ApexStreamImpl();
        return newStream.addOperator(inputOperatorName, (Operator)fileLineInputOperator, null, fileLineInputOperator.output);
    }

    public static ApexStream<String> fromFolder(String folderName) {
        return StreamFactory.fromFolder("FolderScanner", folderName);
    }

    public static ApexStream<String> fromKafka08(String zookeepers, String topic) {
        return StreamFactory.fromKafka08("Kafka08Input", zookeepers, topic);
    }

    public static ApexStream<String> fromKafka08(String inputName, String zookeepers, String topic) {
        KafkaSinglePortStringInputOperator kafkaSinglePortStringInputOperator = new KafkaSinglePortStringInputOperator();
        kafkaSinglePortStringInputOperator.getConsumer().setTopic(topic);
        kafkaSinglePortStringInputOperator.getConsumer().setZookeeper(zookeepers);
        ApexStreamImpl newStream = new ApexStreamImpl();
        return newStream.addOperator((Operator)kafkaSinglePortStringInputOperator, null, kafkaSinglePortStringInputOperator.outputPort);
    }

    public static <T> ApexStream<T> fromInput(String inputOperatorName, InputOperator operator, Operator.OutputPort<T> outputPort) {
        ApexStreamImpl newStream = new ApexStreamImpl();
        return newStream.addOperator(inputOperatorName, (Operator)operator, null, outputPort);
    }

    public static <T> ApexStream<T> fromInput(InputOperator operator, Operator.OutputPort<T> outputPort) {
        return StreamFactory.fromInput(operator.toString(), operator, outputPort);
    }

    public static ApexStream<String> fromKafka09(String name, String brokers, String topic) {
        throw new UnsupportedOperationException();
    }

    public static ApexStream<String> fromKafka09(String brokers, String topic) {
        return StreamFactory.fromKafka09("KafkaInput", brokers, topic);
    }
}

