/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.api.impl;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.DAG;
import com.datatorrent.api.Operator;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class DagMeta {
    private List<NodeMeta> heads = new LinkedList<NodeMeta>();
    List<Pair<Attribute, Object>> dagAttributes = new LinkedList<Pair<Attribute, Object>>();

    public DAG buildDAG() {
        LogicalPlan dag = new LogicalPlan();
        this.buildDAG((DAG)dag);
        return dag;
    }

    public void buildDAG(DAG dag) {
        for (NodeMeta nm : this.heads) {
            this.visitNode(nm, dag);
        }
    }

    private void visitNode(NodeMeta nm, DAG dag) {
        dag.addOperator(nm.nodeName, nm.operator);
        for (NodeMeta nodeMeta : nm.children) {
            this.visitNode(nodeMeta, dag);
        }
        for (Map.Entry entry : nm.nodeStreams.entrySet()) {
            if (entry.getKey() == null || ((Pair)entry.getValue()).getKey() == null || 0 == ((List)((Pair)entry.getValue()).getKey()).size()) continue;
            DAG.StreamMeta streamMeta = dag.addStream(((Operator.OutputPort)entry.getKey()).toString(), (Operator.OutputPort)entry.getKey(), ((List)((Pair)entry.getValue()).getLeft()).toArray(new Operator.InputPort[0]));
            if (((Pair)entry.getValue()).getRight() != null) {
                streamMeta.setLocality((DAG.Locality)((Pair)entry.getValue()).getRight());
            }
            if (!nm.outputPortAttributes.containsKey(entry.getKey())) continue;
            for (Pair<Attribute, Object> attr : nm.outputPortAttributes.get(entry.getKey())) {
                dag.setOutputPortAttribute((Operator.OutputPort)entry.getKey(), (Attribute)attr.getLeft(), attr.getValue());
            }
        }
        for (Operator.InputPort inputPort : nm.operatorInputs) {
            if (!nm.inputPortAttributes.containsKey(inputPort)) continue;
            for (Pair<Attribute, Object> attr : nm.inputPortAttributes.get(inputPort)) {
                dag.setInputPortAttribute(inputPort, (Attribute)attr.getLeft(), attr.getValue());
            }
        }
        for (Pair pair : nm.operatorAttributes) {
            dag.setAttribute(nm.operator, (Attribute)pair.getLeft(), pair.getValue());
        }
    }

    public NodeMeta addNode(String nodeName, Operator operator, NodeMeta parent, Operator.OutputPort parentOutput, Operator.InputPort inputPort) {
        NodeMeta newNode = new NodeMeta(operator, nodeName);
        if (parent == null) {
            this.heads.add(newNode);
        } else {
            ((List)((Pair)parent.nodeStreams.get(parentOutput)).getLeft()).add(inputPort);
            parent.children.add(newNode);
            newNode.parent.add(parent);
        }
        return newNode;
    }

    public static class NodeMeta {
        private String nodeName;
        private Operator operator;
        List<Pair<Attribute, Object>> operatorAttributes = new LinkedList<Pair<Attribute, Object>>();
        private Map<Operator.OutputPort, Pair<List<Operator.InputPort>, DAG.Locality>> nodeStreams = new HashMap<Operator.OutputPort, Pair<List<Operator.InputPort>, DAG.Locality>>();
        Map<Operator.OutputPort, List<Pair<Attribute, Object>>> outputPortAttributes = new HashMap<Operator.OutputPort, List<Pair<Attribute, Object>>>();
        Map<Operator.InputPort, List<Pair<Attribute, Object>>> inputPortAttributes = new HashMap<Operator.InputPort, List<Pair<Attribute, Object>>>();
        private Set<Operator.InputPort> operatorInputs = new HashSet<Operator.InputPort>();
        private List<NodeMeta> children = new LinkedList<NodeMeta>();
        private List<NodeMeta> parent = new LinkedList<NodeMeta>();

        public List<NodeMeta> getParent() {
            return this.parent;
        }

        public List<NodeMeta> getChildren() {
            return this.children;
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public Operator getOperator() {
            return this.operator;
        }

        public Map<Operator.OutputPort, Pair<List<Operator.InputPort>, DAG.Locality>> getNodeStreams() {
            return this.nodeStreams;
        }

        public NodeMeta(Operator operator, String nodeName) {
            this.nodeName = nodeName;
            this.operator = operator;
            for (Field field : this.operator.getClass().getFields()) {
                int modifier = field.getModifiers();
                if (Modifier.isPublic(modifier) && Modifier.isTransient(modifier) && Operator.OutputPort.class.isAssignableFrom(field.getType())) {
                    try {
                        this.nodeStreams.put((Operator.OutputPort)field.get(operator), (Pair<List<Operator.InputPort>, DAG.Locality>)MutablePair.of(new LinkedList(), null));
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                if (!Modifier.isPublic(modifier) || !Modifier.isTransient(modifier) || !Operator.InputPort.class.isAssignableFrom(field.getType())) continue;
                try {
                    this.operatorInputs.add((Operator.InputPort)field.get(operator));
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }
}

