/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.api.impl;

import com.datatorrent.api.Attribute;
import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.LocalMode;
import com.datatorrent.api.Operator;
import com.datatorrent.lib.algo.UniqueCounter;
import com.datatorrent.lib.io.ConsoleOutputOperator;
import com.datatorrent.stram.StramLocalCluster;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.apex.malhar.stream.api.ApexStream;
import org.apache.apex.malhar.stream.api.function.Function;
import org.apache.apex.malhar.stream.api.impl.DagMeta;
import org.apache.apex.malhar.stream.api.impl.IDGenerator;
import org.apache.apex.malhar.stream.api.operator.FunctionOperator;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ApexStreamImpl<T>
implements ApexStream<T> {
    private static Set<Attribute<?>> OPERATOR_ATTRIBUTES = new HashSet();
    private static Set<Attribute<?>> DAG_ATTRIBUTES = new HashSet();
    private static Set<Attribute<?>> INPUT_ATTRIBUTES = new HashSet();
    private static Set<Attribute<?>> OUTPUT_ATTRIBUTES = new HashSet();
    private DagMeta graph;
    private ApexStream<T> delegator;
    private Brick<T> lastBrick;

    public Brick<T> getLastBrick() {
        return this.lastBrick;
    }

    public void setLastBrick(Brick<T> lastBrick) {
        this.lastBrick = lastBrick;
    }

    public ApexStreamImpl() {
        this.graph = new DagMeta();
    }

    public ApexStreamImpl(ApexStream<T> apexStream) {
        this.delegator = apexStream;
        if (this.delegator != null && this.delegator instanceof ApexStreamImpl) {
            this.graph = ((ApexStreamImpl)this.delegator).graph;
            this.lastBrick = ((ApexStreamImpl)this.delegator).lastBrick;
        }
    }

    public ApexStreamImpl(DagMeta graph) {
        this(graph, null);
    }

    public ApexStreamImpl(DagMeta graph, Brick<T> lastBrick) {
        this.graph = graph;
        this.lastBrick = lastBrick;
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM map(Function.MapFunction<T, O> mf) {
        return this.map(mf.toString(), mf);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM map(String name, Function.MapFunction<T, O> mf) {
        FunctionOperator.MapFunctionOperator<T, O> opt = new FunctionOperator.MapFunctionOperator<T, O>(mf);
        return this.addOperator(name, opt, (Operator.InputPort<T>)opt.input, (Operator.OutputPort<O>)opt.output);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM flatMap(Function.FlatMapFunction<T, O> flatten) {
        return this.flatMap(flatten.toString(), flatten);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM flatMap(String name, Function.FlatMapFunction<T, O> flatten) {
        FunctionOperator.FlatMapFunctionOperator<T, O> opt = new FunctionOperator.FlatMapFunctionOperator<T, O>(flatten);
        return this.addOperator(name, opt, (Operator.InputPort<T>)opt.input, (Operator.OutputPort<O>)opt.output);
    }

    @Override
    public <STREAM extends ApexStream<T>> STREAM filter(Function.FilterFunction<T> filter) {
        return this.filter(filter.toString(), filter);
    }

    @Override
    public <STREAM extends ApexStream<T>> STREAM filter(String name, Function.FilterFunction<T> filter) {
        FunctionOperator.FilterFunctionOperator<T> filterFunctionOperator = new FunctionOperator.FilterFunctionOperator<T>(filter);
        return this.addOperator(name, filterFunctionOperator, (Operator.InputPort<T>)filterFunctionOperator.input, (Operator.OutputPort)filterFunctionOperator.output);
    }

    @Override
    public <STREAM extends ApexStream<T>> STREAM reduce(Function.ReduceFunction<T> reduce) {
        return this.reduce(reduce.toString(), reduce);
    }

    @Override
    public <STREAM extends ApexStream<T>> STREAM reduce(String name, Function.ReduceFunction<T> reduce) {
        FunctionOperator.ReduceFunctionOperator<T> opt = new FunctionOperator.ReduceFunctionOperator<T>(reduce);
        return this.addOperator(name, opt, (Operator.InputPort<T>)opt.input, (Operator.OutputPort)opt.output);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM fold(O initialValue, Function.FoldFunction<T, O> fold) {
        return this.fold(fold.toString(), initialValue, fold);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM fold(String name, O initialValue, Function.FoldFunction<T, O> fold) {
        FunctionOperator.FoldFunctionOperator<T, O> opt = new FunctionOperator.FoldFunctionOperator<T, O>(fold, initialValue);
        return this.addOperator(name, opt, (Operator.InputPort<T>)opt.input, (Operator.OutputPort<O>)opt.output);
    }

    @Override
    public <STREAM extends ApexStream<Integer>> STREAM count() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <STREAM extends ApexStream<Map<Object, Integer>>> STREAM countByKey(int key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <STREAM extends ApexStream<Map<Object, Integer>>> STREAM countByKey() {
        UniqueCounter uniqueCounter = new UniqueCounter();
        uniqueCounter.setCumulative(true);
        DefaultOutputPort resultPort = uniqueCounter.count;
        return this.addOperator("CounterByKey", (Operator)uniqueCounter, (Operator.InputPort<T>)uniqueCounter.data, (Operator.OutputPort)resultPort);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM addOperator(Operator op, Operator.InputPort<T> inputPort, Operator.OutputPort<O> outputPort) {
        return this.addOperator(op.toString(), op, inputPort, outputPort);
    }

    @Override
    public <O, STREAM extends ApexStream<O>> STREAM addOperator(String opName, Operator op, Operator.InputPort<T> inputPort, Operator.OutputPort<O> outputPort) {
        if (this.delegator != null) {
            ApexStreamImpl apexStream = (ApexStreamImpl)this.delegator.addOperator(opName, op, inputPort, outputPort);
            try {
                return (STREAM)((ApexStream)this.getClass().getConstructor(ApexStream.class).newInstance(apexStream));
            }
            catch (Exception e) {
                throw new RuntimeException("You have to override the default constructor with ApexStreamImpl as delegator");
            }
        }
        this.checkArguments(op, inputPort, outputPort);
        DagMeta.NodeMeta nm = null;
        nm = this.lastBrick == null ? this.graph.addNode(opName, op, null, null, inputPort) : this.graph.addNode(opName, op, ((Brick)this.lastBrick).nodeMeta, ((Brick)this.lastBrick).lastOutput, inputPort);
        Brick<O> newBrick = new Brick<O>();
        ((Brick)newBrick).nodeMeta = nm;
        newBrick.setLastOutput(outputPort);
        if (this.lastBrick != null) {
            ((Brick)newBrick).lastStream = Pair.of((Object)((Brick)this.lastBrick).lastOutput, inputPort);
        }
        return (STREAM)new ApexStreamImpl(this.graph, newBrick);
    }

    private void checkArguments(Operator op, Operator.InputPort inputPort, Operator.OutputPort outputPort) {
        if (op == null) {
            throw new IllegalArgumentException("Operator can not be null");
        }
        boolean foundInput = inputPort == null;
        boolean foundOutput = outputPort == null;
        for (Field f : op.getClass().getFields()) {
            int modifiers = f.getModifiers();
            if (!Modifier.isPublic(modifiers) || !Modifier.isTransient(modifiers)) continue;
            Object obj = null;
            try {
                obj = f.get(op);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (obj == outputPort) {
                foundOutput = true;
            }
            if (obj != inputPort) continue;
            foundInput = true;
        }
        if (!foundInput || !foundOutput) {
            throw new IllegalArgumentException("Input port " + inputPort + " and/or Output port " + outputPort + " is/are not owned by Operator " + op);
        }
    }

    @Override
    public <STREAM extends ApexStream<T>> STREAM union(ApexStream<T> ... others) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ApexStreamImpl<T> print() {
        ConsoleOutputOperator consoleOutputOperator = new ConsoleOutputOperator();
        this.addOperator(IDGenerator.generateOperatorIDWithUUID(consoleOutputOperator.getClass()), (Operator)consoleOutputOperator, (Operator.InputPort<T>)consoleOutputOperator.input, null);
        return this;
    }

    @Override
    public ApexStream<T> printErr() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ApexStream<T> with(Attribute attribute, Object value) {
        if (OPERATOR_ATTRIBUTES.contains(attribute)) {
            ((Brick)this.lastBrick).nodeMeta.operatorAttributes.add((Pair<Attribute, Object>)Pair.of((Object)attribute, (Object)value));
        }
        if (INPUT_ATTRIBUTES.contains(attribute) && ((Brick)this.lastBrick).lastStream != null) {
            List<Pair<Attribute, Object>> attrs = ((Brick)this.lastBrick).nodeMeta.inputPortAttributes.get(((Brick)this.lastBrick).lastStream.getRight());
            if (attrs == null) {
                attrs = new LinkedList<Pair<Attribute, Object>>();
            }
            attrs.add((Pair<Attribute, Object>)Pair.of((Object)attribute, (Object)value));
            ((Brick)this.lastBrick).nodeMeta.inputPortAttributes.put((Operator.InputPort)((Brick)this.lastBrick).lastStream.getRight(), attrs);
        }
        if (OUTPUT_ATTRIBUTES.contains(attribute) && ((Brick)this.lastBrick).lastStream != null) {
            for (DagMeta.NodeMeta parent : ((Brick)this.lastBrick).nodeMeta.getParent()) {
                parent.getNodeStreams().containsKey(((Brick)this.lastBrick).lastStream.getLeft());
                List<Pair<Attribute, Object>> attrs = parent.outputPortAttributes.get(((Brick)this.lastBrick).lastStream.getLeft());
                if (attrs == null) {
                    attrs = new LinkedList<Pair<Attribute, Object>>();
                }
                attrs.add((Pair<Attribute, Object>)Pair.of((Object)attribute, (Object)value));
                ((Brick)this.lastBrick).nodeMeta.outputPortAttributes.put((Operator.OutputPort)((Brick)this.lastBrick).lastStream.getLeft(), attrs);
            }
        }
        this.setGlobalAttribute(attribute, value);
        return this;
    }

    @Override
    public ApexStream<T> setGlobalAttribute(Attribute attribute, Object value) {
        this.graph.dagAttributes.add((Pair<Attribute, Object>)Pair.of((Object)attribute, (Object)value));
        return this;
    }

    @Override
    public ApexStream<T> with(DAG.Locality locality) {
        if (((Brick)this.lastBrick).lastStream != null) {
            for (DagMeta.NodeMeta parent : ((Brick)this.lastBrick).nodeMeta.getParent()) {
                Pair<List<Operator.InputPort>, DAG.Locality> p = parent.getNodeStreams().get(((Brick)this.lastBrick).lastStream.getLeft());
                if (p == null) continue;
                p.setValue((Object)locality);
            }
        }
        return this;
    }

    @Override
    public ApexStream<T> with(String propName, Object value) {
        try {
            BeanUtils.setProperty((Object)((Brick)this.lastBrick).nodeMeta.getOperator(), (String)propName, (Object)value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public DAG createDag() {
        LogicalPlan dag = new LogicalPlan();
        this.populateDag((DAG)dag);
        return dag;
    }

    @Override
    public void populateDag(DAG dag) {
        this.graph.buildDAG(dag);
    }

    @Override
    public void runEmbedded(boolean async, long duration, Callable<Boolean> exitCondition) {
        LocalMode lma = LocalMode.newInstance();
        this.populateDag(lma.getDAG());
        LocalMode.Controller lc = lma.getController();
        if (lc instanceof StramLocalCluster) {
            ((StramLocalCluster)lc).setExitCondition(exitCondition);
        }
        if (async) {
            lc.runAsync();
        } else if (duration >= 0L) {
            lc.run(duration);
        } else {
            lc.run();
        }
    }

    @Override
    public void run() {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            for (Field field : Context.OperatorContext.class.getDeclaredFields()) {
                if (field.getType() != Attribute.class) continue;
                OPERATOR_ATTRIBUTES.add((Attribute)field.get(Context.OperatorContext.class));
            }
            for (Field field : Context.DAGContext.class.getDeclaredFields()) {
                if (field.getType() != Attribute.class) continue;
                DAG_ATTRIBUTES.add((Attribute)field.get(Context.DAGContext.class));
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        INPUT_ATTRIBUTES.add(Context.PortContext.PARTITION_PARALLEL);
        INPUT_ATTRIBUTES.add(Context.PortContext.AUTO_RECORD);
        INPUT_ATTRIBUTES.add(Context.PortContext.STREAM_CODEC);
        INPUT_ATTRIBUTES.add(Context.PortContext.TUPLE_CLASS);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.QUEUE_CAPACITY);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.BUFFER_MEMORY_MB);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.SPIN_MILLIS);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.UNIFIER_SINGLE_FINAL);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.IS_OUTPUT_UNIFIED);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.AUTO_RECORD);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.STREAM_CODEC);
        OUTPUT_ATTRIBUTES.add(Context.PortContext.TUPLE_CLASS);
    }

    public static class Brick<T> {
        private Operator.OutputPort<T> lastOutput;
        private DagMeta.NodeMeta nodeMeta;
        private Pair<Operator.OutputPort, Operator.InputPort> lastStream;

        public Operator.OutputPort<T> getLastOutput() {
            return this.lastOutput;
        }

        public void setLastOutput(Operator.OutputPort<T> lastOutput) {
            this.lastOutput = lastOutput;
        }

        public void setLastStream(Pair<Operator.OutputPort, Operator.InputPort> lastStream) {
            this.lastStream = lastStream;
        }

        public Pair<Operator.OutputPort, Operator.InputPort> getLastStream() {
            return this.lastStream;
        }
    }
}

