/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.sample;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import org.apache.apex.malhar.stream.api.function.Function;
import org.apache.apex.malhar.stream.api.impl.StreamFactory;
import org.apache.apex.malhar.stream.sample.TupleCollector;
import org.junit.Assert;
import org.junit.Test;

public class LocalTestWithoutStreamApplication {
    @Test
    public void testNonStreamApplicationWordcount() throws Exception {
        TupleCollector collector = new TupleCollector();
        collector.id = "testNonStreamApplicationWordcount";
        final HashMap<String, Integer> expected = new HashMap<String, Integer>();
        expected.put("error", 2);
        expected.put("word1", 4);
        expected.put("word2", 8);
        expected.put("word3", 4);
        expected.put("word4", 4);
        expected.put("word5", 4);
        expected.put("word7", 4);
        expected.put("word9", 6);
        Callable<Boolean> exitCondition = new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                List<?> data = TupleCollector.results.get("testNonStreamApplicationWordcount");
                return data != null && data.size() >= 1 && expected.equals(data.get(data.size() - 1));
            }
        };
        StreamFactory.fromFolder((String)"./src/test/resources/data").flatMap((Function.FlatMapFunction)new Function.FlatMapFunction<String, String>(){

            public Iterable<String> f(String input) {
                return Arrays.asList(input.split(" "));
            }
        }).countByKey().addOperator(collector, collector.inputPort, collector.outputPort).print().runEmbedded(false, 30000L, (Callable)exitCondition);
        List<?> data = TupleCollector.results.get("testNonStreamApplicationWordcount");
        Assert.assertNotNull(data);
        Assert.assertTrue((data.size() > 1 ? 1 : 0) != 0);
        Assert.assertEquals(expected, data.get(data.size() - 1));
    }
}

