/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.sample;

import com.datatorrent.api.DAG;
import com.datatorrent.api.StreamingApplication;
import com.datatorrent.api.annotation.ApplicationAnnotation;
import java.util.Arrays;
import org.apache.apex.malhar.stream.api.ApexStream;
import org.apache.apex.malhar.stream.api.function.Function;
import org.apache.apex.malhar.stream.api.impl.StreamFactory;
import org.apache.hadoop.conf.Configuration;

@ApplicationAnnotation(name="WordCountStreamingApiDemo")
public class ApplicationWithStreamAPI
implements StreamingApplication {
    public void populateDAG(DAG dag, Configuration configuration) {
        String localFolder = "./src/test/resources/data";
        ApexStream stream = StreamFactory.fromFolder((String)localFolder).flatMap((Function.FlatMapFunction)new Function.FlatMapFunction<String, String>(){

            public Iterable<String> f(String input) {
                return Arrays.asList(input.split(" "));
            }
        });
        stream.print();
        stream.countByKey().print();
        stream.populateDag(dag);
    }
}

