/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.stream.api.impl;

import com.datatorrent.api.Context;
import com.datatorrent.api.DAG;
import com.datatorrent.api.DefaultInputPort;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.Operator;
import com.datatorrent.common.util.BaseOperator;
import com.datatorrent.stram.plan.logical.LogicalPlan;
import java.util.Collection;
import java.util.HashSet;
import org.apache.apex.malhar.stream.api.impl.ApexStreamImpl;
import org.junit.Assert;
import org.junit.Test;

public class ApexStreamImplTest {
    @Test
    public void testAddOperator() {
        LogicalPlan dag = new LogicalPlan();
        TestOperator firstOperator = new TestOperator();
        TestOperator secondOperator = new TestOperator();
        new ApexStreamImpl().addOperator("first", firstOperator, null, firstOperator.output).addOperator("second", secondOperator, secondOperator.input, null).with(DAG.Locality.THREAD_LOCAL).with(Context.OperatorContext.AUTO_RECORD, (Object)true).with("prop", (Object)"TestProp").populateDag((DAG)dag);
        Assert.assertTrue((dag.getAllOperators().size() == 2 ? 1 : 0) != 0);
        HashSet<String> opNames = new HashSet<String>();
        opNames.add("first");
        opNames.add("second");
        for (LogicalPlan.OperatorMeta operatorMeta : dag.getAllOperators()) {
            Assert.assertTrue((boolean)(operatorMeta.getOperator() instanceof TestOperator));
            Assert.assertTrue((boolean)opNames.contains(operatorMeta.getName()));
            if (operatorMeta.getName().equals("second")) {
                Assert.assertTrue((boolean)((Boolean)operatorMeta.getAttributes().get(Context.OperatorContext.AUTO_RECORD)));
                Assert.assertEquals((Object)"TestProp", (Object)((TestOperator)operatorMeta.getOperator()).prop);
                continue;
            }
            Assert.assertNull((Object)operatorMeta.getAttributes().get(Context.OperatorContext.AUTO_RECORD));
            Assert.assertNull((Object)((TestOperator)operatorMeta.getOperator()).prop);
        }
        Collection streams = dag.getAllStreams();
        Assert.assertTrue((streams.size() == 1 ? 1 : 0) != 0);
        for (LogicalPlan.StreamMeta stream : streams) {
            Assert.assertEquals((Object)"first", (Object)stream.getSource().getOperatorMeta().getName());
            Assert.assertTrue((1 == stream.getSinks().size() ? 1 : 0) != 0);
            Assert.assertEquals((Object)"second", (Object)((LogicalPlan.InputPortMeta)stream.getSinks().get(0)).getOperatorWrapper().getName());
            Assert.assertTrue((stream.getLocality() == DAG.Locality.THREAD_LOCAL ? 1 : 0) != 0);
        }
    }

    public static class TestOperator<T, O>
    extends BaseOperator {
        private String prop = null;
        public final transient Operator.InputPort<T> input = new DefaultInputPort<T>(){

            public void process(T o) {
            }
        };
        public final transient Operator.OutputPort<O> output = new DefaultOutputPort();

        public void setProp(String prop) {
            this.prop = prop;
        }

        public String getProp() {
            return this.prop;
        }
    }
}

