/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu.sqltranslator;

import com.google.common.base.Preconditions;
import java.util.List;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;
import org.apache.apex.malhar.kudu.sqlparser.KuduSQLExpressionLexer;
import org.apache.apex.malhar.kudu.sqlparser.KuduSQLExpressionParser;
import org.apache.apex.malhar.kudu.sqltranslator.KuduSQLExpressionErrorListener;
import org.apache.apex.malhar.kudu.sqltranslator.KuduSQLParseTreeListener;
import org.apache.apex.malhar.kudu.sqltranslator.KuduSQLParser;
import org.apache.kudu.ColumnSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLToKuduPredicatesTranslator {
    private static final transient Logger LOG = LoggerFactory.getLogger(SQLToKuduPredicatesTranslator.class);
    private String sqlExpresssion = null;
    private KuduSQLExpressionErrorListener errorListener = null;
    private KuduSQLParser parser = null;
    private KuduSQLParseTreeListener kuduSQLParseTreeListener = null;
    private List<ColumnSchema> allColumnsForThisTable = null;

    public SQLToKuduPredicatesTranslator(String sqlExpresssionForParsing, List<ColumnSchema> tableColumns) throws Exception {
        Preconditions.checkNotNull(tableColumns, (Object)"Kudu table cannot have null or empty columns");
        Preconditions.checkNotNull((Object)sqlExpresssionForParsing, (Object)"Kudu SQL expression cannot be null");
        this.sqlExpresssion = sqlExpresssionForParsing;
        this.allColumnsForThisTable = tableColumns;
        this.parseKuduExpression();
    }

    public void parseKuduExpression() throws Exception {
        KuduSQLExpressionLexer lexer = new KuduSQLExpressionLexer((CharStream)CharStreams.fromString((String)this.sqlExpresssion));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        this.parser = new KuduSQLParser((TokenStream)tokens);
        this.errorListener = this.parser.getKuduSQLExpressionErrorListener();
        KuduSQLExpressionParser.KudusqlexpressionContext parserTree = this.parser.kudusqlexpression();
        if (!this.errorListener.isSyntaxError()) {
            ParseTreeWalker parseTreeWalker = new ParseTreeWalker();
            this.kuduSQLParseTreeListener = new KuduSQLParseTreeListener();
            this.kuduSQLParseTreeListener.setColumnSchemaList(this.allColumnsForThisTable);
            try {
                parseTreeWalker.walk((ParseTreeListener)this.kuduSQLParseTreeListener, (ParseTree)parserTree);
            }
            catch (Exception ex) {
                LOG.error(" The supplied SQL expression could not be parsed because " + ex.getMessage(), (Throwable)ex);
                this.errorListener.setSyntaxError(true);
            }
        } else {
            LOG.error(" Syntax error present in the Kudu SQL expression. Hence not processing");
            List<String> allRegisteredSyntaxErrors = this.errorListener.getListOfErrorMessages();
            for (String syntaxErrorMessage : allRegisteredSyntaxErrors) {
                LOG.error(" Error : " + syntaxErrorMessage + " in SQL expression \"" + this.sqlExpresssion + " \"");
            }
        }
    }

    public KuduSQLExpressionErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setErrorListener(KuduSQLExpressionErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public String getSqlExpresssion() {
        return this.sqlExpresssion;
    }

    public void setSqlExpresssion(String sqlExpresssion) {
        this.sqlExpresssion = sqlExpresssion;
    }

    public KuduSQLParser getParser() {
        return this.parser;
    }

    public void setParser(KuduSQLParser parser) {
        this.parser = parser;
    }

    public KuduSQLParseTreeListener getKuduSQLParseTreeListener() {
        return this.kuduSQLParseTreeListener;
    }

    public void setKuduSQLParseTreeListener(KuduSQLParseTreeListener kuduSQLParseTreeListener) {
        this.kuduSQLParseTreeListener = kuduSQLParseTreeListener;
    }
}

