/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu.sqltranslator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.apex.malhar.kudu.sqlparser.KuduSQLExpressionBaseListener;
import org.apache.apex.malhar.kudu.sqlparser.KuduSQLExpressionParser;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduSQLParseTreeListener
extends KuduSQLExpressionBaseListener {
    private boolean isSuccessfullyParsed = true;
    private boolean isFilterExpressionEnabled = false;
    private boolean isOptionsEnabled = false;
    private Set<String> listOfColumnsUsed = new HashSet<String>();
    private Map<String, String> aliases = new HashMap<String, String>();
    private Map<String, String> optionsUsed = new HashMap<String, String>();
    private List<KuduPredicate> kuduPredicateList = new ArrayList<KuduPredicate>();
    private Map<String, ColumnSchema> columnSchemaLookups = new HashMap<String, ColumnSchema>();
    private String tableName = null;
    private boolean isSelectStarExpressionEnabled = false;
    private static final transient Logger LOG = LoggerFactory.getLogger(KuduSQLParseTreeListener.class);
    private String controlTupleMessage = null;
    private Long readSnapshotTime = null;
    public static final String READ_SNAPSHOT_TIME = "read_snapshot_time";
    public static final String CONTROLTUPLE_MESSAGE = "controltuple_message";

    private void clearAll() {
        this.listOfColumnsUsed.clear();
        this.aliases.clear();
        this.optionsUsed.clear();
        this.kuduPredicateList.clear();
        this.tableName = null;
        this.columnSchemaLookups.clear();
    }

    public void setColumnSchemaList(List<ColumnSchema> listOfColumnsForCurrentTable) {
        Preconditions.checkNotNull(listOfColumnsForCurrentTable, (Object)"Column schemas cannot be null for kudu table");
        for (ColumnSchema aColumnDef : listOfColumnsForCurrentTable) {
            this.columnSchemaLookups.put(aColumnDef.getName(), aColumnDef);
            this.aliases.put(aColumnDef.getName(), aColumnDef.getName());
        }
    }

    @Override
    public void exitKudusqlexpression(KuduSQLExpressionParser.KudusqlexpressionContext ctx) {
        LOG.debug(" Scanning " + this.listOfColumnsUsed.size() + " columns from " + this.tableName + " table");
        LOG.debug(" Number of predicates that are part of the scan are " + this.kuduPredicateList.size());
        LOG.debug(" Select * expression enabled " + this.isSelectStarExpressionEnabled);
        LOG.debug(" Filter expression enabled " + this.isFilterExpressionEnabled);
        LOG.debug(" Are options being enabled  " + this.isOptionsEnabled);
        LOG.debug(" Read snapshot time being used as " + this.readSnapshotTime);
        LOG.debug(" Control tuple message being used as " + this.controlTupleMessage);
    }

    @Override
    public void exitSELECT_ID_ONLY_USED_AS_COLUMN_NAME(KuduSQLExpressionParser.SELECT_ID_ONLY_USED_AS_COLUMN_NAMEContext ctx) {
        String columnName;
        super.exitSELECT_ID_ONLY_USED_AS_COLUMN_NAME(ctx);
        KuduSQLExpressionParser.IdorcolumnnameContext ctxForIDOrColumnName = ctx.idorcolumnname();
        if (ctxForIDOrColumnName != null && (columnName = this.extractColumnNameFromContext(ctxForIDOrColumnName)) != null) {
            if (this.columnSchemaLookups.containsKey(columnName)) {
                LOG.debug(" Kudu column being enabled for scanning " + columnName);
                this.aliases.put(columnName, columnName);
                this.listOfColumnsUsed.add(columnName);
            } else {
                LOG.error("Invalid column  being set as a scanner ( column names are case sensitive ). " + columnName);
                this.isSuccessfullyParsed = false;
            }
        }
    }

    @Override
    public void exitALL_COLUMNS_SELECT_EXP(KuduSQLExpressionParser.ALL_COLUMNS_SELECT_EXPContext ctx) {
        super.exitALL_COLUMNS_SELECT_EXP(ctx);
        this.listOfColumnsUsed.addAll(this.columnSchemaLookups.keySet());
        this.isSelectStarExpressionEnabled = true;
    }

    private String extractColumnNameFromContext(KuduSQLExpressionParser.IdorcolumnnameContext ctxForIDOrColumnName) {
        if (ctxForIDOrColumnName.ID() != null) {
            return ctxForIDOrColumnName.ID().getSymbol().getText();
        }
        for (int i = 0; i < ctxForIDOrColumnName.getChildCount(); ++i) {
            ParseTree terminalNodeTree = ctxForIDOrColumnName.getChild(i);
            String childNodeText = terminalNodeTree.getText();
            if (childNodeText.equalsIgnoreCase(" ") || childNodeText.equalsIgnoreCase("'")) continue;
            return childNodeText;
        }
        return null;
    }

    @Override
    public void exitSELECT_ALIAS_USED(KuduSQLExpressionParser.SELECT_ALIAS_USEDContext ctx) {
        String columnName;
        super.exitSELECT_ALIAS_USED(ctx);
        KuduSQLExpressionParser.IdorcolumnnameContext ctxForIDOrColumnName = ctx.idorcolumnname();
        if (ctxForIDOrColumnName != null && (columnName = this.extractColumnNameFromContext(ctxForIDOrColumnName)) != null) {
            if (this.columnSchemaLookups.containsKey(columnName)) {
                LOG.debug(" Kudu column being enabled for scanning " + columnName);
                LOG.debug(columnName + " is being scanned as " + ctx.ID().getSymbol().getText());
                this.aliases.put(columnName, ctx.ID().getSymbol().getText());
                this.listOfColumnsUsed.add(columnName);
            } else {
                LOG.error("Invalid column  being set as a scanner ( column names are case sensitive ). " + columnName);
                this.isSuccessfullyParsed = false;
            }
        }
    }

    @Override
    public void exitTableclause(KuduSQLExpressionParser.TableclauseContext ctx) {
        super.exitTableclause(ctx);
        this.tableName = ctx.ID().getText();
    }

    @Override
    public void exitWhereclause(KuduSQLExpressionParser.WhereclauseContext ctx) {
        super.exitWhereclause(ctx);
        this.isFilterExpressionEnabled = true;
    }

    @Override
    public void exitWithoptionsclause(KuduSQLExpressionParser.WithoptionsclauseContext ctx) {
        super.exitWithoptionsclause(ctx);
        this.isOptionsEnabled = true;
    }

    private KuduPredicate buildKuduPredicate(String columnName, KuduPredicate.ComparisonOp comparisonOp, KuduSQLExpressionParser.AnyvalueContext anyvalueContext) {
        ColumnSchema thisColumnSchema = this.columnSchemaLookups.get(columnName);
        if (anyvalueContext.bool() != null) {
            if (thisColumnSchema.getType().getDataType().getNumber() != 9) {
                LOG.error(" Mismatched data type for column " + columnName);
                this.isSuccessfullyParsed = false;
                return null;
            }
            return KuduPredicate.newComparisonPredicate((ColumnSchema)thisColumnSchema, (KuduPredicate.ComparisonOp)comparisonOp, (boolean)Boolean.valueOf(anyvalueContext.bool().getText().toLowerCase()));
        }
        if (anyvalueContext.doubleval() != null) {
            if (thisColumnSchema.getType().getDataType().getNumber() != 11) {
                LOG.error(" Mismatched data type for column (Ensure doubles are appended with letter d)" + columnName);
                this.isSuccessfullyParsed = false;
                return null;
            }
            return KuduPredicate.newComparisonPredicate((ColumnSchema)thisColumnSchema, (KuduPredicate.ComparisonOp)comparisonOp, (double)Double.valueOf(anyvalueContext.doubleval().getText()));
        }
        if (anyvalueContext.floatval() != null) {
            if (thisColumnSchema.getType().getDataType().getNumber() != 10) {
                LOG.error(" Mismatched data type for column (Ensure doubles are appended with letter f)" + columnName);
                this.isSuccessfullyParsed = false;
                return null;
            }
            return KuduPredicate.newComparisonPredicate((ColumnSchema)thisColumnSchema, (KuduPredicate.ComparisonOp)comparisonOp, (float)Float.valueOf(anyvalueContext.floatval().getText()).floatValue());
        }
        if (anyvalueContext.stringval() != null) {
            if (thisColumnSchema.getType().getDataType().getNumber() != 8 && thisColumnSchema.getType().getDataType().getNumber() != 12) {
                LOG.error(" Mismatched data type for column ( Has to be a string or a binary value enclosed in double quotes" + columnName);
                this.isSuccessfullyParsed = false;
                return null;
            }
            if (thisColumnSchema.getType().getDataType().getNumber() == 8) {
                return KuduPredicate.newComparisonPredicate((ColumnSchema)thisColumnSchema, (KuduPredicate.ComparisonOp)comparisonOp, (String)anyvalueContext.stringval().getText());
            }
            if (thisColumnSchema.getType().getDataType().getNumber() == 12) {
                return KuduPredicate.newComparisonPredicate((ColumnSchema)thisColumnSchema, (KuduPredicate.ComparisonOp)comparisonOp, (byte[])anyvalueContext.stringval().getText().getBytes());
            }
        }
        if (anyvalueContext.numval() != null) {
            int dataTypeNumberForKuduCol = thisColumnSchema.getType().getDataType().getNumber();
            if (dataTypeNumberForKuduCol != 13 && dataTypeNumberForKuduCol != 1 && dataTypeNumberForKuduCol != 3 && dataTypeNumberForKuduCol != 5 && dataTypeNumberForKuduCol != 7 && dataTypeNumberForKuduCol != 0 && dataTypeNumberForKuduCol != 2 && dataTypeNumberForKuduCol != 4 && dataTypeNumberForKuduCol != 6) {
                LOG.error(" Mismatched data type for column " + columnName);
                this.isSuccessfullyParsed = false;
                return null;
            }
            return KuduPredicate.newComparisonPredicate((ColumnSchema)thisColumnSchema, (KuduPredicate.ComparisonOp)comparisonOp, (long)Long.valueOf(anyvalueContext.numval().getText()));
        }
        return null;
    }

    @Override
    public void exitFILTER_COMPARISION_EXP(KuduSQLExpressionParser.FILTER_COMPARISION_EXPContext ctx) {
        super.exitFILTER_COMPARISION_EXP(ctx);
        String columnName = this.extractColumnNameFromContext(ctx.idorcolumnname());
        if (this.columnSchemaLookups.containsKey(columnName)) {
            if (ctx.comparisionoperator().EQUAL_TO() != null) {
                this.kuduPredicateList.add(this.buildKuduPredicate(columnName, KuduPredicate.ComparisonOp.EQUAL, ctx.anyvalue()));
            }
            if (ctx.comparisionoperator().GREATER_THAN() != null) {
                this.kuduPredicateList.add(this.buildKuduPredicate(columnName, KuduPredicate.ComparisonOp.GREATER, ctx.anyvalue()));
            }
            if (ctx.comparisionoperator().LESSER_THAN() != null) {
                this.kuduPredicateList.add(this.buildKuduPredicate(columnName, KuduPredicate.ComparisonOp.LESS, ctx.anyvalue()));
            }
            if (ctx.comparisionoperator().GREATER_THAN_OR_EQUAL() != null) {
                this.kuduPredicateList.add(this.buildKuduPredicate(columnName, KuduPredicate.ComparisonOp.GREATER_EQUAL, ctx.anyvalue()));
            }
            if (ctx.comparisionoperator().LESSER_THAN_OR_EQUAL() != null) {
                this.kuduPredicateList.add(this.buildKuduPredicate(columnName, KuduPredicate.ComparisonOp.LESS_EQUAL, ctx.anyvalue()));
            }
        } else {
            LOG.error(columnName + " is not a valid column name for this kudu table");
            this.isSuccessfullyParsed = false;
        }
    }

    @Override
    public void exitIS_NULL_FILTER_EXP(KuduSQLExpressionParser.IS_NULL_FILTER_EXPContext ctx) {
        super.exitIS_NULL_FILTER_EXP(ctx);
        String columnName = this.extractColumnNameFromContext(ctx.idorcolumnname());
        if (this.columnSchemaLookups.containsKey(columnName)) {
            this.kuduPredicateList.add(KuduPredicate.newIsNullPredicate((ColumnSchema)this.columnSchemaLookups.get(columnName)));
        } else {
            LOG.error(columnName + " is not a valid column name for this kudu table");
            this.isSuccessfullyParsed = false;
        }
    }

    private List<Boolean> extractListOfBools(KuduSQLExpressionParser.ListofboolsContext listofboolsContext, String columnName) {
        ArrayList<Boolean> returnList = new ArrayList<Boolean>();
        for (KuduSQLExpressionParser.BoolContext aBool : listofboolsContext.bool()) {
            returnList.add(Boolean.valueOf(aBool.getText().toLowerCase()));
        }
        if (returnList.size() == 0) {
            LOG.error("Empty list of booleans specified for IN expression for column filter " + columnName);
            this.isSuccessfullyParsed = false;
        }
        return returnList;
    }

    private List<Double> extractListOfDoubles(KuduSQLExpressionParser.ListofdoublesContext listofdoubles, String columnName) {
        ArrayList<Double> returnList = new ArrayList<Double>();
        for (KuduSQLExpressionParser.DoublevalContext aDouble : listofdoubles.doubleval()) {
            returnList.add(Double.valueOf(aDouble.getText()));
        }
        if (returnList.size() == 0) {
            LOG.error("Empty list of doubles specified for IN expression for column filter " + columnName);
            this.isSuccessfullyParsed = false;
        }
        return returnList;
    }

    private List<Float> extractListOfFloats(KuduSQLExpressionParser.ListoffloatsContext listoffloatsContext, String columnName) {
        ArrayList<Float> returnList = new ArrayList<Float>();
        for (KuduSQLExpressionParser.FloatvalContext aFloat : listoffloatsContext.floatval()) {
            returnList.add(Float.valueOf(aFloat.getText()));
        }
        if (returnList.size() == 0) {
            LOG.error("Empty list of floats specified for IN expression for column filter " + columnName);
            this.isSuccessfullyParsed = false;
        }
        return returnList;
    }

    private List<Long> extractListOfLongs(KuduSQLExpressionParser.ListofnumsContext listofnumsContext, String columnName) {
        ArrayList<Long> returnList = new ArrayList<Long>();
        for (KuduSQLExpressionParser.NumvalContext aLong : listofnumsContext.numval()) {
            returnList.add(Long.valueOf(aLong.getText()));
        }
        if (returnList.size() == 0) {
            LOG.error("Empty list of longs specified for IN expression for column filter " + columnName);
            this.isSuccessfullyParsed = false;
        }
        return returnList;
    }

    private List<String> extractListOfStrings(KuduSQLExpressionParser.ListofstringsContext listofstringsContext, String columnName) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (KuduSQLExpressionParser.StringvalContext aString : listofstringsContext.stringval()) {
            returnList.add(aString.getText());
        }
        if (returnList.size() == 0) {
            LOG.error("Empty list of Strings specified for IN expression for column filter " + columnName);
            this.isSuccessfullyParsed = false;
        }
        return returnList;
    }

    private List<byte[]> extractListOfBinary(KuduSQLExpressionParser.ListofstringsContext listofstringsContext, String columnName) {
        ArrayList<byte[]> returnList = new ArrayList<byte[]>();
        for (KuduSQLExpressionParser.StringvalContext aString : listofstringsContext.stringval()) {
            returnList.add(aString.getText().getBytes());
        }
        if (returnList.size() == 0) {
            LOG.error("Empty list of binaries specified for IN expression for column filter " + columnName);
            this.isSuccessfullyParsed = false;
        }
        return returnList;
    }

    @Override
    public void exitIN_FILTER_EXP(KuduSQLExpressionParser.IN_FILTER_EXPContext ctx) {
        super.exitIN_FILTER_EXP(ctx);
        String columnName = this.extractColumnNameFromContext(ctx.idorcolumnname());
        if (this.columnSchemaLookups.containsKey(columnName)) {
            KuduSQLExpressionParser.ListofstringsContext listofstringsContext;
            KuduSQLExpressionParser.ListofnumsContext listofnumsContext;
            KuduSQLExpressionParser.ListoffloatsContext listoffloatsContext;
            KuduSQLExpressionParser.ListofdoublesContext listofdoubles;
            KuduSQLExpressionParser.ListofanyvalueContext listofanyvalueContext = ctx.listofanyvalue();
            KuduSQLExpressionParser.ListofboolsContext listofboolsContext = listofanyvalueContext.listofbools();
            if (listofboolsContext != null) {
                this.kuduPredicateList.add(KuduPredicate.newInListPredicate((ColumnSchema)this.columnSchemaLookups.get(columnName), this.extractListOfBools(listofboolsContext, columnName)));
            }
            if ((listofdoubles = listofanyvalueContext.listofdoubles()) != null) {
                this.kuduPredicateList.add(KuduPredicate.newInListPredicate((ColumnSchema)this.columnSchemaLookups.get(columnName), this.extractListOfDoubles(listofdoubles, columnName)));
            }
            if ((listoffloatsContext = listofanyvalueContext.listoffloats()) != null) {
                this.kuduPredicateList.add(KuduPredicate.newInListPredicate((ColumnSchema)this.columnSchemaLookups.get(columnName), this.extractListOfFloats(listoffloatsContext, columnName)));
            }
            if ((listofnumsContext = listofanyvalueContext.listofnums()) != null) {
                this.kuduPredicateList.add(KuduPredicate.newInListPredicate((ColumnSchema)this.columnSchemaLookups.get(columnName), this.extractListOfLongs(listofnumsContext, columnName)));
            }
            if ((listofstringsContext = listofanyvalueContext.listofstrings()) != null) {
                if (this.columnSchemaLookups.get(columnName).getType().getDataType().getNumber() == 8) {
                    this.kuduPredicateList.add(KuduPredicate.newInListPredicate((ColumnSchema)this.columnSchemaLookups.get(columnName), this.extractListOfStrings(listofstringsContext, columnName)));
                }
                if (this.columnSchemaLookups.get(columnName).getType().getDataType().getNumber() == 8) {
                    this.kuduPredicateList.add(KuduPredicate.newInListPredicate((ColumnSchema)this.columnSchemaLookups.get(columnName), this.extractListOfBinary(listofstringsContext, columnName)));
                }
            }
        } else {
            LOG.error(columnName + " is not a valid column name to be used in a where clause for this kudu table");
            this.isSuccessfullyParsed = false;
        }
    }

    @Override
    public void exitIS_NOT_NULL_FILTER_EXP(KuduSQLExpressionParser.IS_NOT_NULL_FILTER_EXPContext ctx) {
        super.exitIS_NOT_NULL_FILTER_EXP(ctx);
        String columnName = this.extractColumnNameFromContext(ctx.idorcolumnname());
        if (this.columnSchemaLookups.containsKey(columnName)) {
            this.kuduPredicateList.add(KuduPredicate.newIsNotNullPredicate((ColumnSchema)this.columnSchemaLookups.get(columnName)));
        } else {
            LOG.error(columnName + " is not a valid column name for this kudu table");
            this.isSuccessfullyParsed = false;
        }
    }

    @Override
    public void exitSET_CONTROL_TUPLE_MSG(KuduSQLExpressionParser.SET_CONTROL_TUPLE_MSGContext ctx) {
        super.exitSET_CONTROL_TUPLE_MSG(ctx);
        this.controlTupleMessage = ctx.STRINGVAL().getText();
        this.optionsUsed.put(CONTROLTUPLE_MESSAGE, this.controlTupleMessage);
    }

    @Override
    public void exitSET_READ_SNAPSHOT_TIME(KuduSQLExpressionParser.SET_READ_SNAPSHOT_TIMEContext ctx) {
        super.exitSET_READ_SNAPSHOT_TIME(ctx);
        this.readSnapshotTime = Long.valueOf(ctx.INT().getText());
        this.optionsUsed.put(READ_SNAPSHOT_TIME, "" + this.readSnapshotTime);
    }

    public boolean isSuccessfullyParsed() {
        return this.isSuccessfullyParsed;
    }

    public void setSuccessfullyParsed(boolean successfullyParsed) {
        this.isSuccessfullyParsed = successfullyParsed;
    }

    public Set<String> getListOfColumnsUsed() {
        return this.listOfColumnsUsed;
    }

    public void setListOfColumnsUsed(Set<String> listOfColumnsUsed) {
        this.listOfColumnsUsed = listOfColumnsUsed;
    }

    public Map<String, String> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, String> aliases) {
        this.aliases = aliases;
    }

    public Map<String, String> getOptionsUsed() {
        return this.optionsUsed;
    }

    public void setOptionsUsed(Map<String, String> optionsUsed) {
        this.optionsUsed = optionsUsed;
    }

    public List<KuduPredicate> getKuduPredicateList() {
        return this.kuduPredicateList;
    }

    public void setKuduPredicateList(List<KuduPredicate> kuduPredicateList) {
        this.kuduPredicateList = kuduPredicateList;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean isSelectStarExpressionEnabled() {
        return this.isSelectStarExpressionEnabled;
    }

    public void setSelectStarExpressionEnabled(boolean selectStarExpressionEnabled) {
        this.isSelectStarExpressionEnabled = selectStarExpressionEnabled;
    }

    public boolean isFilterExpressionEnabled() {
        return this.isFilterExpressionEnabled;
    }

    public void setFilterExpressionEnabled(boolean filterExpressionEnabled) {
        this.isFilterExpressionEnabled = filterExpressionEnabled;
    }

    public boolean isOptionsEnabled() {
        return this.isOptionsEnabled;
    }

    public void setOptionsEnabled(boolean optionsEnabled) {
        this.isOptionsEnabled = optionsEnabled;
    }

    public String getControlTupleMessage() {
        return this.controlTupleMessage;
    }

    public void setControlTupleMessage(String controlTupleMessage) {
        this.controlTupleMessage = controlTupleMessage;
    }

    public Long getReadSnapshotTime() {
        return this.readSnapshotTime;
    }

    public void setReadSnapshotTime(Long readSnapshotTime) {
        this.readSnapshotTime = readSnapshotTime;
    }
}

