/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu.scanner;

import com.datatorrent.lib.util.PojoUtils;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.apex.malhar.kudu.AbstractKuduInputOperator;
import org.apache.apex.malhar.kudu.ApexKuduConnection;
import org.apache.apex.malhar.kudu.InputOperatorControlTuple;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionScanAssignmentMeta;
import org.apache.apex.malhar.kudu.scanner.KuduRecordWithMeta;
import org.apache.apex.malhar.kudu.sqltranslator.SQLToKuduPredicatesTranslator;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduScanToken;
import org.apache.kudu.client.KuduScanner;
import org.apache.kudu.client.RowResult;
import org.apache.kudu.client.RowResultIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduPartitionScannerCallable<T, C extends InputOperatorControlTuple>
implements Callable<Long> {
    private AbstractKuduInputOperator<T, C> operatorUsingThisScanner;
    private KuduPartitionScanAssignmentMeta kuduPartitionScanAssignmentMeta;
    private BlockingQueue<KuduRecordWithMeta<T>> bufferForTransmittingRecords;
    private Class<T> clazzForResultObject;
    private transient KuduClient kuduClientHandle;
    private Map<String, ColumnSchema> tableSchema;
    private Map<String, Object> settersForThisQueryScan;
    private SQLToKuduPredicatesTranslator parsedQuery;
    private static final Logger LOG = LoggerFactory.getLogger(KuduPartitionScannerCallable.class);

    public KuduPartitionScannerCallable(AbstractKuduInputOperator<T, C> kuduInputOperator, KuduPartitionScanAssignmentMeta partitionMeta, ApexKuduConnection apexKuduConnection, Map<String, Object> setters, SQLToKuduPredicatesTranslator parsedQueryInstance) {
        Preconditions.checkNotNull(kuduInputOperator, (Object)"Kudu operator instance cannot be null in the kudu scanner thread");
        Preconditions.checkNotNull((Object)partitionMeta, (Object)"Partition metadata cannot be null in kudu scanner thread");
        Preconditions.checkNotNull((Object)apexKuduConnection, (Object)"Kudu connection cannot be null in the kudu scanner thread");
        Preconditions.checkNotNull((Object)apexKuduConnection, (Object)"Setters cannot be null in the kudu scanner thread");
        Preconditions.checkNotNull((Object)parsedQueryInstance, (Object)"parsed Query instance cannot be null");
        this.operatorUsingThisScanner = kuduInputOperator;
        this.kuduPartitionScanAssignmentMeta = partitionMeta;
        this.bufferForTransmittingRecords = kuduInputOperator.getBuffer();
        this.clazzForResultObject = kuduInputOperator.getClazzForResultObject();
        Preconditions.checkNotNull((Object)apexKuduConnection, (Object)"Kudu connection cannot be null when initializing scanner");
        this.kuduClientHandle = apexKuduConnection.getKuduClient();
        Preconditions.checkNotNull((Object)this.kuduClientHandle, (Object)"Kudu client cannot be null when initializing scanner");
        this.tableSchema = kuduInputOperator.getKuduColNameToSchemaMapping();
        this.settersForThisQueryScan = setters;
        this.parsedQuery = parsedQueryInstance;
    }

    public void setValuesInPOJO(RowResult aRow, T payload) {
        Set<String> columnsUsed = this.parsedQuery.getKuduSQLParseTreeListener().getListOfColumnsUsed();
        block16: for (String aColumnName : columnsUsed) {
            ColumnSchema schemaForThisColumn = this.tableSchema.get(aColumnName);
            if (aRow.isNull(aColumnName)) continue;
            switch (schemaForThisColumn.getType().getDataType().getNumber()) {
                case 12: {
                    ((PojoUtils.Setter)this.settersForThisQueryScan.get(aColumnName)).set(payload, (Object)aRow.getBinary(aColumnName));
                    continue block16;
                }
                case 8: {
                    ((PojoUtils.Setter)this.settersForThisQueryScan.get(aColumnName)).set(payload, (Object)aRow.getString(aColumnName));
                    continue block16;
                }
                case 9: {
                    ((PojoUtils.SetterBoolean)this.settersForThisQueryScan.get(aColumnName)).set(payload, aRow.getBoolean(aColumnName));
                    continue block16;
                }
                case 11: {
                    ((PojoUtils.SetterDouble)this.settersForThisQueryScan.get(aColumnName)).set(payload, aRow.getDouble(aColumnName));
                    continue block16;
                }
                case 10: {
                    ((PojoUtils.SetterFloat)this.settersForThisQueryScan.get(aColumnName)).set(payload, aRow.getFloat(aColumnName));
                    continue block16;
                }
                case 1: {
                    ((PojoUtils.SetterByte)this.settersForThisQueryScan.get(aColumnName)).set(payload, aRow.getByte(aColumnName));
                    continue block16;
                }
                case 3: {
                    ((PojoUtils.SetterShort)this.settersForThisQueryScan.get(aColumnName)).set(payload, aRow.getShort(aColumnName));
                    continue block16;
                }
                case 5: {
                    ((PojoUtils.SetterInt)this.settersForThisQueryScan.get(aColumnName)).set(payload, aRow.getInt(aColumnName));
                    continue block16;
                }
                case 7: 
                case 13: {
                    ((PojoUtils.SetterLong)this.settersForThisQueryScan.get(aColumnName)).set(payload, aRow.getLong(aColumnName));
                    continue block16;
                }
                case 0: {
                    LOG.error("Unsigned int 8 not supported yet");
                    throw new RuntimeException("uint8 not supported in Kudu schema yet");
                }
                case 2: {
                    LOG.error("Unsigned int 16 not supported yet");
                    throw new RuntimeException("uint16 not supported in Kudu schema yet");
                }
                case 4: {
                    LOG.error("Unsigned int 32 not supported yet");
                    throw new RuntimeException("uint32 not supported in Kudu schema yet");
                }
                case 6: {
                    LOG.error("Unsigned int 64 not supported yet");
                    throw new RuntimeException("uint64 not supported in Kudu schema yet");
                }
                case 999: {
                    LOG.error("unknown data type ( complex types ? )  not supported yet");
                    throw new RuntimeException("Unknown data type  ( complex types ? ) not supported in Kudu schema yet");
                }
            }
            LOG.error("unknown type/default  ( complex types ? )  not supported yet");
            throw new RuntimeException("Unknown type/default  ( complex types ? ) not supported in Kudu schema yet");
        }
    }

    @Override
    public Long call() throws Exception {
        long numRowsScanned = 0L;
        KuduScanner aPartitionSpecificScanner = KuduScanToken.deserializeIntoScanner((byte[])this.kuduPartitionScanAssignmentMeta.getSerializedKuduScanToken(), (KuduClient)this.kuduClientHandle);
        LOG.info("Scanning the following tablet " + KuduScanToken.stringifySerializedToken((byte[])this.kuduPartitionScanAssignmentMeta.getSerializedKuduScanToken(), (KuduClient)this.kuduClientHandle));
        KuduRecordWithMeta beginScanRecord = new KuduRecordWithMeta();
        beginScanRecord.setBeginScanMarker(true);
        beginScanRecord.setTabletMetadata(this.kuduPartitionScanAssignmentMeta);
        this.bufferForTransmittingRecords.add(beginScanRecord);
        while (aPartitionSpecificScanner.hasMoreRows()) {
            LOG.debug("Number of columns being returned for this read " + aPartitionSpecificScanner.getProjectionSchema().getColumnCount());
            RowResultIterator resultIterator = aPartitionSpecificScanner.nextRows();
            if (resultIterator == null) break;
            while (resultIterator.hasNext()) {
                KuduRecordWithMeta<T> recordWithMeta = new KuduRecordWithMeta<T>();
                RowResult aRow = resultIterator.next();
                recordWithMeta.setPositionInScan(numRowsScanned);
                T payload = this.clazzForResultObject.newInstance();
                recordWithMeta.setThePayload(payload);
                recordWithMeta.setEndOfScanMarker(false);
                recordWithMeta.setTabletMetadata(this.kuduPartitionScanAssignmentMeta);
                this.setValuesInPOJO(aRow, payload);
                this.bufferForTransmittingRecords.add(recordWithMeta);
                ++numRowsScanned;
            }
        }
        aPartitionSpecificScanner.close();
        KuduRecordWithMeta endScanRecord = new KuduRecordWithMeta();
        endScanRecord.setEndOfScanMarker(true);
        endScanRecord.setTabletMetadata(this.kuduPartitionScanAssignmentMeta);
        this.bufferForTransmittingRecords.add(endScanRecord);
        LOG.info(" Scanned a total of " + numRowsScanned + " for this scanner thread @tablet " + KuduScanToken.stringifySerializedToken((byte[])this.kuduPartitionScanAssignmentMeta.getSerializedKuduScanToken(), (KuduClient)this.kuduClientHandle));
        return numRowsScanned;
    }
}

