/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu.scanner;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.apex.malhar.kudu.AbstractKuduInputOperator;
import org.apache.apex.malhar.kudu.InputOperatorControlTuple;
import org.apache.apex.malhar.kudu.scanner.AbstractKuduPartitionScanner;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionScanAssignmentMeta;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionScannerCallable;
import org.apache.apex.malhar.kudu.sqltranslator.SQLToKuduPredicatesTranslator;

public class KuduPartitionRandomOrderScanner<T, C extends InputOperatorControlTuple>
extends AbstractKuduPartitionScanner<T, C> {
    public KuduPartitionRandomOrderScanner(AbstractKuduInputOperator<T, C> parentOperator) {
        super(parentOperator);
        this.threadPoolExecutorSize = parentOperator.getPartitionPieAssignment().size();
        this.initScannerCommons();
    }

    @Override
    public int scanAllRecords(SQLToKuduPredicatesTranslator parsedQuery, Map<String, Object> setters) throws IOException {
        int counterForMeta = 0;
        List<KuduPartitionScanAssignmentMeta> preparedScans = this.preparePlanForScanners(parsedQuery);
        for (KuduPartitionScanAssignmentMeta aMeta : preparedScans) {
            KuduPartitionScannerCallable aScanJobThread = new KuduPartitionScannerCallable(this.parentOperator, aMeta, this.verifyConnectionStaleness(counterForMeta), setters, parsedQuery);
            ++counterForMeta;
            this.kuduConsumerExecutor.submit(aScanJobThread);
        }
        return preparedScans.size();
    }
}

