/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu.scanner;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.apex.malhar.kudu.AbstractKuduInputOperator;
import org.apache.apex.malhar.kudu.InputOperatorControlTuple;
import org.apache.apex.malhar.kudu.scanner.AbstractKuduPartitionScanner;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionScanAssignmentMeta;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionScannerCallable;
import org.apache.apex.malhar.kudu.sqltranslator.SQLToKuduPredicatesTranslator;

public class KuduPartitionConsistentOrderScanner<T, C extends InputOperatorControlTuple>
extends AbstractKuduPartitionScanner<T, C> {
    public KuduPartitionConsistentOrderScanner(AbstractKuduInputOperator<T, C> parentOperator) {
        super(parentOperator);
        this.threadPoolExecutorSize = 1;
        this.initScannerCommons();
    }

    @Override
    public int scanAllRecords(SQLToKuduPredicatesTranslator parsedQuery, Map<String, Object> setters) throws IOException {
        List<KuduPartitionScanAssignmentMeta> plannedScansForthisQuery = this.preparePlanForScanners(parsedQuery);
        this.kuduConsumerExecutor.submit(new SequentialScannerThread(parsedQuery, setters, plannedScansForthisQuery));
        return plannedScansForthisQuery.size();
    }

    public class SequentialScannerThread
    implements Callable<Long> {
        SQLToKuduPredicatesTranslator parsedQuery;
        Map<String, Object> settersForThisQuery;
        List<KuduPartitionScanAssignmentMeta> scansForThisQuery;
        ExecutorService executorServiceForSequentialScanner = Executors.newFixedThreadPool(1);

        public SequentialScannerThread(SQLToKuduPredicatesTranslator parsedQueryTree, Map<String, Object> setters, List<KuduPartitionScanAssignmentMeta> plannedScans) {
            Preconditions.checkNotNull((Object)parsedQueryTree, (Object)"Parsed SQL expression cannot be null for scanner");
            Preconditions.checkNotNull(setters, (Object)"Setters cannot be null for the scanner thread");
            Preconditions.checkNotNull(plannedScans, (Object)"Planned scan segments cannot be null for scanner thread");
            this.parsedQuery = parsedQueryTree;
            this.settersForThisQuery = setters;
            this.scansForThisQuery = plannedScans;
        }

        @Override
        public Long call() throws Exception {
            long overallCount = 0L;
            int counterForMeta = 0;
            for (KuduPartitionScanAssignmentMeta aMeta : this.scansForThisQuery) {
                KuduPartitionScannerCallable aScanJobThread = new KuduPartitionScannerCallable(KuduPartitionConsistentOrderScanner.this.parentOperator, aMeta, KuduPartitionConsistentOrderScanner.this.verifyConnectionStaleness(counterForMeta), this.settersForThisQuery, this.parsedQuery);
                ++counterForMeta;
                Future<Long> scanResult = this.executorServiceForSequentialScanner.submit(aScanJobThread);
                overallCount += scanResult.get().longValue();
            }
            this.executorServiceForSequentialScanner.shutdown();
            return overallCount;
        }
    }
}

