/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu.partitioner;

import com.datatorrent.api.Partitioner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.apex.malhar.kudu.AbstractKuduInputOperator;
import org.apache.apex.malhar.kudu.partitioner.AbstractKuduInputPartitioner;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionScanAssignmentMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KuduOneToManyPartitioner
extends AbstractKuduInputPartitioner {
    private static final Logger LOG = LoggerFactory.getLogger(KuduOneToManyPartitioner.class);

    public KuduOneToManyPartitioner(AbstractKuduInputOperator prototypeOperator) {
        super(prototypeOperator);
    }

    @Override
    public Map<Integer, List<KuduPartitionScanAssignmentMeta>> assign(List<KuduPartitionScanAssignmentMeta> totalList, Partitioner.PartitioningContext context) {
        int i;
        HashMap<Integer, List<KuduPartitionScanAssignmentMeta>> partitionAssignments = new HashMap<Integer, List<KuduPartitionScanAssignmentMeta>>();
        int partitionCount = this.getNumberOfPartitions(context);
        if (partitionCount <= 0) {
            LOG.error(" Partition count cannot be zero ");
            partitionCount = 1;
        }
        int idealDistributionRatio = totalList.size() / partitionCount + 1;
        LOG.info(" Distributing not more than " + idealDistributionRatio + " partitions per input operator");
        int counterForLoopingTotal = 0;
        int totalSizeOfKuduScanAssignments = totalList.size();
        for (i = 0; i < partitionCount; ++i) {
            partitionAssignments.put(i, new ArrayList());
        }
        block1: while (counterForLoopingTotal < totalSizeOfKuduScanAssignments) {
            for (i = 0; i < partitionCount; ++i) {
                List assignmentsForThisOperatorId = (List)partitionAssignments.get(i);
                if (counterForLoopingTotal >= totalSizeOfKuduScanAssignments) continue block1;
                assignmentsForThisOperatorId.add(totalList.get(counterForLoopingTotal));
                ++counterForLoopingTotal;
            }
        }
        return partitionAssignments;
    }
}

