/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.apex.malhar.kudu.AbstractKuduInputOperator;
import org.apache.apex.malhar.kudu.ApexKuduConnection;
import org.apache.apex.malhar.kudu.InputOperatorControlTuple;
import org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.kudu.client.SessionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncrementalStepScanInputOperator<T, C extends InputOperatorControlTuple>
extends AbstractKuduInputOperator<T, C> {
    private static final Logger LOG = LoggerFactory.getLogger(IncrementalStepScanInputOperator.class);
    private long stepUpValue;
    private long startSeedValue;
    private long currentLowerBound;
    private long currentUpperBound;
    private String queryTemplateString;
    private String lowerBoundParamName;
    private String upperBoundParamName;
    public static String DEFAULT_CONNECTION_PROPS_FILE_NAME = "kuduincrementalstepscaninputoperator.properties";
    public static final String TABLE_NAME = "tablename";
    public static final String MASTER_HOSTS = "masterhosts";
    public static final String POJO_CLASS_NAME = "pojoclassname";
    public static final String TEMPLATE_QUERY_STRING = "templatequerystring";
    public static final String TEMPLATE_QUERY_LOWERBOUND_PARAMNAME = "templatequerylowerboundparamname";
    public static final String TEMPLATE_QUERY_UPPERBOUND_PARAMNAME = "templatequeryupperboundparamname";
    public static final String TEMPLATE_QUERY_SEED_VALUE = "templatequeryseedvalue";
    public static final String TEMPLATE_QUERY_INCREMENT_STEP_VALUE = "templatequeryincrementalvalue";
    private ApexKuduConnection.ApexKuduConnectionBuilder apexKuduConnectionBuilder;

    public IncrementalStepScanInputOperator() throws IOException, NumberFormatException {
        this.initConnectionBuilderProperties(DEFAULT_CONNECTION_PROPS_FILE_NAME);
    }

    public IncrementalStepScanInputOperator(Class<T> classForPojo, String configFileInClasspath) throws IOException, NumberFormatException {
        this.initConnectionBuilderProperties(configFileInClasspath);
        this.clazzForResultObject = classForPojo;
    }

    private void initConnectionBuilderProperties(String configFileInClasspath) throws IOException, NumberFormatException {
        Properties incrementalStepProperties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream kuduPropsFileAsStream = loader.getResourceAsStream(configFileInClasspath);
        if (kuduPropsFileAsStream != null) {
            incrementalStepProperties.load(kuduPropsFileAsStream);
        } else {
            if (!DEFAULT_CONNECTION_PROPS_FILE_NAME.equalsIgnoreCase(configFileInClasspath)) {
                throw new IOException("Properties file required for Kudu connection " + configFileInClasspath + " is not locatable in the root classpath");
            }
            LOG.warn("Properties file could not be loaded. Expecting the user to set properties manually");
        }
        this.tableName = (String)Preconditions.checkNotNull((Object)incrementalStepProperties.getProperty(TABLE_NAME));
        String masterHostsConnectionString = (String)Preconditions.checkNotNull((Object)incrementalStepProperties.getProperty(MASTER_HOSTS));
        String[] masterAndHosts = masterHostsConnectionString.split(",");
        this.lowerBoundParamName = (String)Preconditions.checkNotNull((Object)incrementalStepProperties.getProperty(TEMPLATE_QUERY_LOWERBOUND_PARAMNAME));
        this.upperBoundParamName = (String)Preconditions.checkNotNull((Object)incrementalStepProperties.getProperty(TEMPLATE_QUERY_UPPERBOUND_PARAMNAME));
        String stepUpValueString = (String)Preconditions.checkNotNull((Object)incrementalStepProperties.getProperty(TEMPLATE_QUERY_INCREMENT_STEP_VALUE));
        String seedValueString = (String)Preconditions.checkNotNull((Object)incrementalStepProperties.getProperty(TEMPLATE_QUERY_SEED_VALUE));
        this.queryTemplateString = (String)Preconditions.checkNotNull((Object)incrementalStepProperties.getProperty(TEMPLATE_QUERY_STRING));
        this.startSeedValue = Long.valueOf(seedValueString);
        this.stepUpValue = Long.valueOf(stepUpValueString);
        this.currentLowerBound = this.startSeedValue;
        this.currentUpperBound = this.currentLowerBound + this.startSeedValue;
        this.initKuduConfig(this.tableName, Arrays.asList(masterAndHosts));
    }

    public void initKuduConfig(String kuduTableName, List<String> kuduMasters) {
        this.apexKuduConnectionBuilder = new ApexKuduConnection.ApexKuduConnectionBuilder().withTableName(kuduTableName).withExternalConsistencyMode(ExternalConsistencyMode.COMMIT_WAIT).withFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC).withNumberOfBossThreads(1).withNumberOfWorkerThreads(2).withSocketReadTimeOutAs(3000L).withOperationTimeOutAs(3000L);
        for (String aMasterAndHost : kuduMasters) {
            this.apexKuduConnectionBuilder = this.apexKuduConnectionBuilder.withAPossibleMasterHostAs(aMasterAndHost);
        }
        this.apexKuduConnectionInfo = this.apexKuduConnectionBuilder;
    }

    @Override
    protected String getNextQuery() {
        long lowerBoundToUseForNextIteration = this.currentLowerBound;
        long upperBoundToUseForNextIteration = this.currentUpperBound;
        String queryToUse = new String(this.queryTemplateString);
        queryToUse = queryToUse.replace(this.lowerBoundParamName, "" + lowerBoundToUseForNextIteration);
        queryToUse = queryToUse.replace(this.upperBoundParamName, "" + upperBoundToUseForNextIteration);
        this.currentLowerBound = this.currentUpperBound;
        this.currentUpperBound = this.currentLowerBound + this.stepUpValue;
        return queryToUse;
    }

    public long getStepUpValue() {
        return this.stepUpValue;
    }

    public void setStepUpValue(long stepUpValue) {
        this.stepUpValue = stepUpValue;
    }

    public long getStartSeedValue() {
        return this.startSeedValue;
    }

    public void setStartSeedValue(long startSeedValue) {
        this.startSeedValue = startSeedValue;
        this.currentLowerBound = startSeedValue;
        this.currentUpperBound = this.currentLowerBound + startSeedValue;
    }

    public String getQueryTemplateString() {
        return this.queryTemplateString;
    }

    public void setQueryTemplateString(String queryTemplateString) {
        this.queryTemplateString = queryTemplateString;
    }

    public String getLowerBoundParamName() {
        return this.lowerBoundParamName;
    }

    public void setLowerBoundParamName(String lowerBoundParamName) {
        this.lowerBoundParamName = lowerBoundParamName;
    }

    public String getUpperBoundParamName() {
        return this.upperBoundParamName;
    }

    public void setUpperBoundParamName(String upperBoundParamName) {
        this.upperBoundParamName = upperBoundParamName;
    }
}

