/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.apex.malhar.kudu.AbstractKuduOutputOperator;
import org.apache.apex.malhar.kudu.ApexKuduConnection;
import org.apache.apex.malhar.kudu.KuduExecutionContext;
import org.apache.apex.malhar.lib.wal.FSWindowDataManager;
import org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.kudu.client.SessionConfiguration;

public class BaseKuduOutputOperator
extends AbstractKuduOutputOperator {
    public static String DEFAULT_CONNECTION_PROPS_FILE_NAME = "kuduoutputoperator.properties";
    public static final String TABLE_NAME = "tablename";
    public static final String MASTER_HOSTS = "masterhosts";
    public static final String POJO_CLASS_NAME = "pojoclassname";
    private Class pojoPayloadClass;
    private ApexKuduConnection.ApexKuduConnectionBuilder apexKuduConnectionBuilder;

    public BaseKuduOutputOperator() throws IOException, ClassNotFoundException {
        this.windowDataManager = new FSWindowDataManager();
        this.initConnectionBuilderProperties(DEFAULT_CONNECTION_PROPS_FILE_NAME);
    }

    public BaseKuduOutputOperator(String configFileInClasspath) throws IOException, ClassNotFoundException {
        this.windowDataManager = new FSWindowDataManager();
        this.initConnectionBuilderProperties(configFileInClasspath);
    }

    private void initConnectionBuilderProperties(String configFileInClasspath) throws IOException, ClassNotFoundException {
        Properties kuduConnectionProperties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream kuduPropsFileAsStream = loader.getResourceAsStream(configFileInClasspath);
        if (kuduPropsFileAsStream == null) {
            throw new IOException("Properties file required for Kudu connection " + configFileInClasspath + " is not locatable in the root classpath");
        }
        kuduConnectionProperties.load(kuduPropsFileAsStream);
        kuduPropsFileAsStream.close();
        String tableName = (String)Preconditions.checkNotNull((Object)kuduConnectionProperties.getProperty(TABLE_NAME));
        String pojoClassName = (String)Preconditions.checkNotNull((Object)kuduConnectionProperties.getProperty(POJO_CLASS_NAME));
        String masterHostsConnectionString = (String)Preconditions.checkNotNull((Object)kuduConnectionProperties.getProperty(MASTER_HOSTS));
        String[] masterAndHosts = masterHostsConnectionString.split(",");
        this.pojoPayloadClass = Class.forName(pojoClassName);
        this.initKuduConfig(tableName, Arrays.asList(masterAndHosts));
    }

    private void initKuduConfig(String kuduTableName, List<String> kuduMasters) {
        this.apexKuduConnectionBuilder = new ApexKuduConnection.ApexKuduConnectionBuilder().withTableName(kuduTableName).withExternalConsistencyMode(ExternalConsistencyMode.COMMIT_WAIT).withFlushMode(SessionConfiguration.FlushMode.AUTO_FLUSH_SYNC).withNumberOfBossThreads(1).withNumberOfWorkerThreads(2).withSocketReadTimeOutAs(3000L).withOperationTimeOutAs(3000L);
        for (String aMasterAndHost : kuduMasters) {
            this.apexKuduConnectionBuilder = this.apexKuduConnectionBuilder.withAPossibleMasterHostAs(aMasterAndHost);
        }
    }

    public BaseKuduOutputOperator(String kuduTableName, List<String> kuduMasters, Class pojoPayloadClass) {
        this.pojoPayloadClass = pojoPayloadClass;
        this.initKuduConfig(kuduTableName, kuduMasters);
    }

    @Override
    ApexKuduConnection.ApexKuduConnectionBuilder getKuduConnectionConfig() {
        return this.apexKuduConnectionBuilder;
    }

    public ApexKuduConnection.ApexKuduConnectionBuilder getApexKuduConnectionBuilder() {
        return this.apexKuduConnectionBuilder;
    }

    @Override
    protected Class getTuplePayloadClass() {
        return this.pojoPayloadClass;
    }

    @Override
    protected boolean isEligibleForPassivationInReconcilingWindow(KuduExecutionContext executionContext, long reconcilingWindowId) {
        return true;
    }
}

