/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.kudu.client.ExternalConsistencyMode;
import org.apache.kudu.client.KuduClient;
import org.apache.kudu.client.KuduSession;
import org.apache.kudu.client.KuduTable;
import org.apache.kudu.client.SessionConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApexKuduConnection
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 4720185362997969198L;
    private transient KuduSession kuduSession;
    private transient KuduTable kuduTable;
    private transient KuduClient kuduClient;
    public static final Logger LOG = LoggerFactory.getLogger(ApexKuduConnection.class);
    private ApexKuduConnectionBuilder builderForThisConnection;

    private ApexKuduConnection(ApexKuduConnectionBuilder builder) {
        Preconditions.checkNotNull((Object)builder, (Object)"Builder cannot be null to establish kudu session");
        Preconditions.checkArgument((builder.mastersCollection.size() > 0 ? 1 : 0) != 0, (Object)"Atleast one kudu master needs to be specified");
        Preconditions.checkNotNull((Object)builder.tableName, (Object)"Kudu table cannot be null");
        this.builderForThisConnection = builder;
        KuduClient.KuduClientBuilder kuduClientBuilder = new KuduClient.KuduClientBuilder(builder.mastersCollection);
        if (builder.isOperationTimeOutSet) {
            kuduClientBuilder.defaultOperationTimeoutMs(builder.operationTimeOutMs);
        }
        if (builder.isBossThreadCountSet) {
            kuduClientBuilder.bossCount(builder.numBossThreads);
        }
        if (builder.isWorkerThreadsCountSet) {
            kuduClientBuilder.workerCount(builder.workerThreads);
        }
        if (builder.isSocketReadTimeOutSet) {
            kuduClientBuilder.defaultSocketReadTimeoutMs(builder.socketReadTimeOutMs);
        }
        this.kuduClient = kuduClientBuilder.build();
        this.kuduSession = this.kuduClient.newSession();
        if (builder.isFlushModeSet) {
            this.kuduSession.setFlushMode(builder.flushMode);
        }
        if (builder.isExternalConsistencyModeSet) {
            this.kuduSession.setExternalConsistencyMode(builder.externalConsistencyMode);
        }
        try {
            if (!this.kuduClient.tableExists(builder.tableName)) {
                throw new Exception("Table " + builder.tableName + " does not exist. ");
            }
            this.kuduTable = this.kuduClient.openTable(builder.tableName);
        }
        catch (Exception e) {
            throw new RuntimeException("Kudu table existence could not be ascertained  " + e.getMessage(), e);
        }
    }

    @Override
    public void close() throws Exception {
        this.kuduSession.close();
        this.kuduClient.close();
    }

    public KuduSession getKuduSession() {
        return this.kuduSession;
    }

    public void setKuduSession(KuduSession kuduSession) {
        this.kuduSession = kuduSession;
    }

    public KuduTable getKuduTable() {
        return this.kuduTable;
    }

    public void setKuduTable(KuduTable kuduTable) {
        this.kuduTable = kuduTable;
    }

    public KuduClient getKuduClient() {
        return this.kuduClient;
    }

    public void setKuduClient(KuduClient kuduClient) {
        this.kuduClient = kuduClient;
    }

    public ApexKuduConnectionBuilder getBuilderForThisConnection() {
        return this.builderForThisConnection;
    }

    public void setBuilderForThisConnection(ApexKuduConnectionBuilder builderForThisConnection) {
        this.builderForThisConnection = builderForThisConnection;
    }

    public static class ApexKuduConnectionBuilder
    implements Serializable {
        private static final long serialVersionUID = -3428649955056723311L;
        List<String> mastersCollection = new ArrayList<String>();
        String tableName;
        int numBossThreads = 1;
        boolean isBossThreadCountSet = false;
        int workerThreads = 2 * Runtime.getRuntime().availableProcessors();
        boolean isWorkerThreadsCountSet = false;
        long socketReadTimeOutMs = 10000L;
        boolean isSocketReadTimeOutSet = false;
        long operationTimeOutMs = 30000L;
        boolean isOperationTimeOutSet = false;
        ExternalConsistencyMode externalConsistencyMode;
        boolean isExternalConsistencyModeSet = false;
        SessionConfiguration.FlushMode flushMode;
        boolean isFlushModeSet = false;

        public ApexKuduConnectionBuilder withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public ApexKuduConnectionBuilder withAPossibleMasterHostAs(String masterHostAndPort) {
            this.mastersCollection.add(masterHostAndPort);
            return this;
        }

        public ApexKuduConnectionBuilder withNumberOfBossThreads(int numberOfBossThreads) {
            this.numBossThreads = numberOfBossThreads;
            this.isBossThreadCountSet = true;
            return this;
        }

        public ApexKuduConnectionBuilder withNumberOfWorkerThreads(int numberOfWorkerThreads) {
            this.workerThreads = numberOfWorkerThreads;
            this.isWorkerThreadsCountSet = true;
            return this;
        }

        public ApexKuduConnectionBuilder withSocketReadTimeOutAs(long socketReadTimeOut) {
            this.socketReadTimeOutMs = socketReadTimeOut;
            this.isSocketReadTimeOutSet = true;
            return this;
        }

        public ApexKuduConnectionBuilder withOperationTimeOutAs(long operationTimeOut) {
            this.operationTimeOutMs = operationTimeOut;
            this.isOperationTimeOutSet = true;
            return this;
        }

        public ApexKuduConnectionBuilder withExternalConsistencyMode(ExternalConsistencyMode externalConsistencyMode) {
            this.externalConsistencyMode = externalConsistencyMode;
            this.isExternalConsistencyModeSet = true;
            return this;
        }

        public ApexKuduConnectionBuilder withFlushMode(SessionConfiguration.FlushMode flushMode) {
            this.flushMode = flushMode;
            this.isFlushModeSet = true;
            return this;
        }

        public ApexKuduConnection build() {
            ApexKuduConnection apexKuduConnection = new ApexKuduConnection(this);
            return apexKuduConnection;
        }
    }
}

