/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kudu;

import com.conversantmedia.util.concurrent.DisruptorBlockingQueue;
import com.conversantmedia.util.concurrent.SpinPolicy;
import com.datatorrent.api.Context;
import com.datatorrent.api.DefaultOutputPort;
import com.datatorrent.api.InputOperator;
import com.datatorrent.api.Operator;
import com.datatorrent.api.Partitioner;
import com.datatorrent.api.StatsListener;
import com.datatorrent.lib.util.PojoUtils;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.apache.apex.api.ControlAwareDefaultOutputPort;
import org.apache.apex.api.operator.ControlTuple;
import org.apache.apex.malhar.kudu.ApexKuduConnection;
import org.apache.apex.malhar.kudu.InputOperatorControlTuple;
import org.apache.apex.malhar.kudu.partitioner.AbstractKuduInputPartitioner;
import org.apache.apex.malhar.kudu.partitioner.KuduOneToManyPartitioner;
import org.apache.apex.malhar.kudu.partitioner.KuduOneToOnePartitioner;
import org.apache.apex.malhar.kudu.partitioner.KuduPartitionScanStrategy;
import org.apache.apex.malhar.kudu.scanner.AbstractKuduPartitionScanner;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionConsistentOrderScanner;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionRandomOrderScanner;
import org.apache.apex.malhar.kudu.scanner.KuduPartitionScanAssignmentMeta;
import org.apache.apex.malhar.kudu.scanner.KuduRecordWithMeta;
import org.apache.apex.malhar.kudu.scanner.KuduScanOrderStrategy;
import org.apache.apex.malhar.kudu.sqltranslator.SQLToKuduPredicatesTranslator;
import org.apache.apex.malhar.lib.wal.FSWindowDataManager;
import org.apache.apex.malhar.lib.wal.WindowDataManager;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.kudu.ColumnSchema;
import org.apache.kudu.client.KuduTable;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceStability.Evolving
public abstract class AbstractKuduInputOperator<T, C extends InputOperatorControlTuple>
implements InputOperator,
Operator.ActivationListener<Context.OperatorContext>,
Operator.CheckpointNotificationListener,
Partitioner<AbstractKuduInputOperator>,
StatsListener {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractKuduInputOperator.class);
    private KuduPartitionScanStrategy partitionScanStrategy = KuduPartitionScanStrategy.MANY_TABLETS_PER_OPERATOR;
    private KuduScanOrderStrategy scanOrderStrategy = KuduScanOrderStrategy.RANDOM_ORDER_SCANNER;
    protected ApexKuduConnection.ApexKuduConnectionBuilder apexKuduConnectionInfo;
    private List<KuduPartitionScanAssignmentMeta> partitionPieAssignment = new ArrayList<KuduPartitionScanAssignmentMeta>();
    protected Class<T> clazzForResultObject;
    private int numberOfPartitions = -1;
    protected String tableName;
    private boolean isFaultTolerantScanner = true;
    private SpinPolicy cpuSpinPolicyForWaitingInBuffer = SpinPolicy.WAITING;
    private int bufferCapacity = 8192;
    private int maxTuplesPerWindow = -1;
    private String currentQueryBeingProcessed;
    private Map<String, String> optionsEnabledForCurrentQuery;
    private int plannedSegmentsForCurrentQuery = 0;
    private Map<KuduPartitionScanAssignmentMeta, Boolean> currentQueryCompletionStatus = new HashMap<KuduPartitionScanAssignmentMeta, Boolean>();
    private boolean allScansCompleteForThisQuery = true;
    private boolean isPartitioned = false;
    @NotNull
    private WindowDataManager windowDataManager = new FSWindowDataManager();
    private transient long currentWindowId;
    private transient long reconcilingPhaseWindowId;
    private transient boolean isCurrentlyInSafeMode;
    private transient boolean isCurrentlyInReconcilingMode;
    private transient Map<KuduPartitionScanAssignmentMeta, Long> windowManagerDataForScans;
    @JsonIgnore
    protected transient AbstractKuduInputPartitioner partitioner;
    @JsonIgnore
    protected transient AbstractKuduPartitionScanner<T, C> scanner;
    private transient DisruptorBlockingQueue<KuduRecordWithMeta<T>> buffer;
    private transient Map<String, String> kuduColNameToPOJOFieldNameMap;
    private transient Map<String, ColumnSchema> kuduColNameToSchemaMapping;
    private transient int currentWindowTupleCount = 0;
    public final transient ControlAwareDefaultOutputPort<T> outputPort = new ControlAwareDefaultOutputPort();
    public final transient DefaultOutputPort<String> errorPort = new DefaultOutputPort();

    public AbstractKuduInputOperator() {
    }

    public AbstractKuduInputOperator(ApexKuduConnection.ApexKuduConnectionBuilder kuduConnectionInfo, Class<T> clazzForPOJO) throws Exception {
        Preconditions.checkNotNull(clazzForPOJO, (Object)" Class definition for POJO cannot be null");
        Preconditions.checkNotNull((Object)kuduConnectionInfo, (Object)"Kudu connection info cannot be null");
        this.apexKuduConnectionInfo = kuduConnectionInfo;
        this.clazzForResultObject = clazzForPOJO;
        this.tableName = kuduConnectionInfo.tableName;
    }

    protected abstract String getNextQuery();

    protected boolean processForQueryString(String queryExpression) {
        LOG.info("Processing query " + queryExpression);
        SQLToKuduPredicatesTranslator parsedQuery = null;
        try {
            parsedQuery = new SQLToKuduPredicatesTranslator(queryExpression, new ArrayList<ColumnSchema>(this.kuduColNameToSchemaMapping.values()));
            parsedQuery.parseKuduExpression();
        }
        catch (Exception e) {
            LOG.error("Could not parse the SQL expression/query " + e.getMessage(), (Throwable)e);
            this.errorPort.emit((Object)queryExpression);
            return false;
        }
        if (parsedQuery.getErrorListener().isSyntaxError()) {
            LOG.error(" Query is an invalid query " + queryExpression);
            this.errorPort.emit((Object)queryExpression);
            return false;
        }
        if (!parsedQuery.getKuduSQLParseTreeListener().isSuccessfullyParsed()) {
            LOG.error(" Query could not be successfully parsed instead of being syntactically correct " + queryExpression);
            this.errorPort.emit((Object)queryExpression);
            return false;
        }
        Map<String, Object> setters = this.extractSettersForResultObject(parsedQuery);
        try {
            this.currentQueryBeingProcessed = queryExpression;
            this.optionsEnabledForCurrentQuery.clear();
            this.optionsEnabledForCurrentQuery.putAll(parsedQuery.getKuduSQLParseTreeListener().getOptionsUsed());
            this.plannedSegmentsForCurrentQuery = this.scanner.scanAllRecords(parsedQuery, setters);
        }
        catch (IOException e) {
            LOG.error("Error while scanning the kudu segments " + e.getMessage(), (Throwable)e);
            this.errorPort.emit((Object)queryExpression);
            return false;
        }
        LOG.info("Query" + queryExpression + " submitted for scanning");
        return true;
    }

    protected boolean processForNextQuery() {
        LOG.info("Clearing data structures for processing query " + this.currentQueryBeingProcessed);
        this.windowManagerDataForScans.clear();
        this.currentQueryCompletionStatus.clear();
        return this.processForQueryString(this.getNextQuery());
    }

    private Map<String, ColumnSchema> buildColumnSchemaForTable() throws Exception {
        if (this.kuduColNameToSchemaMapping == null) {
            ApexKuduConnection connectionForMetaDataScan = this.apexKuduConnectionInfo.build();
            KuduTable table = connectionForMetaDataScan.getKuduTable();
            List tableColumns = table.getSchema().getColumns();
            connectionForMetaDataScan.close();
            HashMap<String, ColumnSchema> columnSchemaMap = new HashMap<String, ColumnSchema>();
            for (ColumnSchema aColumn : tableColumns) {
                columnSchemaMap.put(aColumn.getName(), aColumn);
            }
            this.kuduColNameToSchemaMapping = columnSchemaMap;
        }
        return this.kuduColNameToSchemaMapping;
    }

    protected void sendControlTupleForNewQuery() {
        C startNewQueryControlTuple = this.getControlTupleForNewQuery();
        if (startNewQueryControlTuple != null) {
            this.outputPort.emitControl(startNewQueryControlTuple);
        }
    }

    protected C getControlTupleForNewQuery() {
        return null;
    }

    protected KuduRecordWithMeta<T> processNextTuple() {
        boolean emitTuple = true;
        KuduRecordWithMeta entryFetchedFromBuffer = null;
        if (this.maxTuplesPerWindow != -1 && this.currentWindowTupleCount >= this.maxTuplesPerWindow) {
            emitTuple = false;
        }
        if (emitTuple) {
            try {
                entryFetchedFromBuffer = (KuduRecordWithMeta)this.buffer.poll(100L, TimeUnit.MICROSECONDS);
            }
            catch (InterruptedException e) {
                LOG.debug("No entry available in the buffer " + e.getMessage(), (Throwable)e);
            }
        }
        return entryFetchedFromBuffer;
    }

    protected void filterTupleBasedOnCurrentState(KuduRecordWithMeta<T> recordWithMeta) {
        boolean filter = false;
        if (this.isCurrentlyInSafeMode) {
            filter = true;
        }
        KuduPartitionScanAssignmentMeta currentRecordMeta = recordWithMeta.getTabletMetadata();
        long currentPositionInScan = recordWithMeta.getPositionInScan();
        if (this.windowManagerDataForScans.containsKey(currentRecordMeta)) {
            long counterLimitForThisMeta = this.windowManagerDataForScans.get(currentRecordMeta);
            if (currentPositionInScan <= counterLimitForThisMeta) {
                filter = true;
            } else {
                this.windowManagerDataForScans.put(currentRecordMeta, currentPositionInScan);
            }
        } else {
            this.windowManagerDataForScans.put(currentRecordMeta, currentPositionInScan);
        }
        if (this.isCurrentlyInReconcilingMode && !this.isAllowedInReconcilingWindow(recordWithMeta)) {
            filter = true;
        }
        if (!filter) {
            this.outputPort.emit(recordWithMeta.getThePayload());
            ++this.currentWindowTupleCount;
        }
    }

    public void emitTuples() {
        if (this.allScansCompleteForThisQuery) {
            if (this.processForNextQuery()) {
                this.sendControlTupleForNewQuery();
                this.allScansCompleteForThisQuery = false;
            }
            return;
        }
        KuduRecordWithMeta<T> entryFetchedFromBuffer = this.processNextTuple();
        if (entryFetchedFromBuffer != null) {
            if (!entryFetchedFromBuffer.isEndOfScanMarker() && !entryFetchedFromBuffer.isBeginScanMarker()) {
                this.filterTupleBasedOnCurrentState(entryFetchedFromBuffer);
                return;
            }
            if (entryFetchedFromBuffer.isEndOfScanMarker()) {
                this.processForEndScanMarker(entryFetchedFromBuffer);
                this.sendControlTupleForEndQuery();
            }
            if (entryFetchedFromBuffer.isBeginScanMarker()) {
                this.processForBeginScanMarker(entryFetchedFromBuffer);
            }
        }
    }

    protected void sendControlTupleForEndQuery() {
        if (this.currentQueryBeingProcessed == null) {
            return;
        }
        if (!this.allScansCompleteForThisQuery) {
            return;
        }
        C endControlTuple = this.getControlTupleForEndQuery();
        if (endControlTuple != null) {
            this.outputPort.emitControl(endControlTuple);
        } else if (this.optionsEnabledForCurrentQuery.containsKey("controltuple_message")) {
            InputOperatorControlTuple controlTuple = new InputOperatorControlTuple();
            controlTuple.setBeginNewQuery(false);
            controlTuple.setEndCurrentQuery(true);
            controlTuple.setQuery(this.currentQueryBeingProcessed);
            controlTuple.setControlMessage(this.optionsEnabledForCurrentQuery.get("controltuple_message"));
            this.outputPort.emitControl((ControlTuple)controlTuple);
        }
    }

    protected C getControlTupleForEndQuery() {
        return null;
    }

    protected void processForBeginScanMarker(KuduRecordWithMeta<T> entryFetchedFromBuffer) {
        this.currentQueryCompletionStatus.put(entryFetchedFromBuffer.getTabletMetadata(), false);
    }

    protected void processForEndScanMarker(KuduRecordWithMeta<T> entryFetchedFromBuffer) {
        Boolean currentStatus = this.currentQueryCompletionStatus.get(entryFetchedFromBuffer.getTabletMetadata());
        if (currentStatus == null) {
            LOG.error(" End scan marker cannot be precede a Begin Scan marker ");
        }
        this.currentQueryCompletionStatus.put(entryFetchedFromBuffer.getTabletMetadata(), true);
        if (this.plannedSegmentsForCurrentQuery == 0) {
            this.allScansCompleteForThisQuery = true;
            return;
        }
        boolean areAllScansComplete = true;
        if (this.currentQueryCompletionStatus.size() != this.plannedSegmentsForCurrentQuery) {
            return;
        }
        for (KuduPartitionScanAssignmentMeta aMeta : this.currentQueryCompletionStatus.keySet()) {
            if (this.currentQueryCompletionStatus.get(aMeta).booleanValue()) continue;
            areAllScansComplete = false;
        }
        if (areAllScansComplete) {
            this.allScansCompleteForThisQuery = true;
        }
    }

    protected boolean isAllowedInReconcilingWindow(KuduRecordWithMeta<T> extractedRecord) {
        return true;
    }

    public void beginWindow(long windowId) {
        this.currentWindowTupleCount = 0;
        this.currentWindowId = windowId;
        if (this.currentWindowId != -1L) {
            if (this.currentWindowId > this.reconcilingPhaseWindowId) {
                this.isCurrentlyInSafeMode = false;
                this.isCurrentlyInReconcilingMode = false;
            }
            if (this.currentWindowId == this.reconcilingPhaseWindowId) {
                this.isCurrentlyInReconcilingMode = true;
                this.isCurrentlyInSafeMode = false;
            }
            if (this.currentWindowId < this.reconcilingPhaseWindowId) {
                this.isCurrentlyInReconcilingMode = false;
                this.isCurrentlyInSafeMode = true;
            }
        }
        LOG.info(" Current processing mode states Safe Mode = " + this.isCurrentlyInSafeMode + " Reconciling mode = " + this.isCurrentlyInReconcilingMode);
        LOG.info(" Current window ID = " + this.currentWindowId + " reconciling window ID = " + this.reconcilingPhaseWindowId);
    }

    public void endWindow() {
        try {
            this.windowDataManager.save(this.windowManagerDataForScans, this.currentWindowId);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not persist the window Data manager on end window boundary " + e.getMessage(), e);
        }
    }

    public void setup(Context.OperatorContext context) {
        if (this.windowDataManager != null) {
            this.windowDataManager.setup((Context)context);
        }
        try {
            this.buildColumnSchemaForTable();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while trying to build the schema definition for the Kudu table " + this.tableName, e);
        }
        this.windowManagerDataForScans = new HashMap<KuduPartitionScanAssignmentMeta, Long>();
        this.optionsEnabledForCurrentQuery = new HashMap<String, String>();
        this.initPartitioner();
        this.initBuffer();
        this.initScanner();
        this.initCurrentState();
        this.isCurrentlyInSafeMode = false;
        this.isCurrentlyInReconcilingMode = false;
        this.reconcilingPhaseWindowId = -1L;
        if ((Long)context.getValue(Context.OperatorContext.ACTIVATION_WINDOW_ID) != -1L && (Long)context.getValue(Context.OperatorContext.ACTIVATION_WINDOW_ID) < this.windowDataManager.getLargestCompletedWindow()) {
            this.isCurrentlyInSafeMode = true;
            this.reconcilingPhaseWindowId = this.windowDataManager.getLargestCompletedWindow() + 1L;
            LOG.info("Set reconciling window ID as " + this.reconcilingPhaseWindowId);
            this.isCurrentlyInReconcilingMode = false;
        }
    }

    public void teardown() {
        this.scanner.close();
    }

    private void initCurrentState() {
        Map savedState = null;
        if (this.windowManagerDataForScans.size() == 0 && this.currentQueryBeingProcessed == null) {
            try {
                savedState = (Map)this.windowDataManager.retrieve(this.windowDataManager.getLargestCompletedWindow());
            }
            catch (IOException e) {
                throw new RuntimeException("Error while retrieving the window manager data at the initialization phase", e);
            }
            catch (NullPointerException ex) {
                LOG.error("Error while getting the window manager data ", (Throwable)ex);
            }
        }
        if (savedState != null && savedState.size() > 0) {
            KuduPartitionScanAssignmentMeta aMeta = (KuduPartitionScanAssignmentMeta)savedState.keySet().iterator().next();
            this.currentQueryBeingProcessed = aMeta.getCurrentQuery();
            this.allScansCompleteForThisQuery = false;
            this.windowManagerDataForScans.putAll(savedState);
            this.processForQueryString(this.currentQueryBeingProcessed);
        }
    }

    public Collection<Partitioner.Partition<AbstractKuduInputOperator>> definePartitions(Collection collection, Partitioner.PartitioningContext context) {
        this.initPartitioner();
        return this.partitioner.definePartitions(collection, context);
    }

    public void partitioned(Map partitions) {
        this.initPartitioner();
        this.partitioner.partitioned(partitions);
    }

    public StatsListener.Response processStats(StatsListener.BatchedOperatorStats stats) {
        StatsListener.Response response = new StatsListener.Response();
        response.repartitionRequired = this.partitionPieAssignment == null || this.partitionPieAssignment.size() == 0;
        return response;
    }

    private void initBuffer() {
        this.buffer = new DisruptorBlockingQueue(this.bufferCapacity, this.cpuSpinPolicyForWaitingInBuffer);
    }

    private void initPartitioner() {
        if (this.partitioner != null) {
            return;
        }
        Preconditions.checkNotNull((Object)this.apexKuduConnectionInfo, (Object)"Apex Kudu connection cannot be null while setting partitioner");
        switch (this.partitionScanStrategy) {
            case MANY_TABLETS_PER_OPERATOR: {
                this.partitioner = new KuduOneToManyPartitioner(this);
                break;
            }
            default: {
                this.partitioner = new KuduOneToOnePartitioner(this);
            }
        }
    }

    private void initScanner() {
        switch (this.scanOrderStrategy) {
            case CONSISTENT_ORDER_SCANNER: {
                this.setFaultTolerantScanner(true);
                this.scanner = new KuduPartitionConsistentOrderScanner(this);
                break;
            }
            default: {
                this.scanner = new KuduPartitionRandomOrderScanner(this);
            }
        }
    }

    public Map<String, Object> extractSettersForResultObject(SQLToKuduPredicatesTranslator parsedQuery) {
        Map<String, String> aliasesUsedForThisQuery = parsedQuery.getKuduSQLParseTreeListener().getAliases();
        HashMap<String, Object> setterMap = new HashMap<String, Object>();
        Field[] fieldsOfThisPojo = this.clazzForResultObject.getDeclaredFields();
        HashSet<String> allPojoFieldNamesUsed = new HashSet<String>(aliasesUsedForThisQuery.values());
        for (Field aField : fieldsOfThisPojo) {
            if (allPojoFieldNamesUsed.contains(aField.getName())) continue;
            LOG.error("Invalid mapping fo Kudu table column name to the POJO field name " + aField.getName());
            return null;
        }
        block17: for (ColumnSchema aKuduTableColumn : this.kuduColNameToSchemaMapping.values()) {
            String kuduColumnName = aKuduTableColumn.getName();
            switch (aKuduTableColumn.getType().getDataType().getNumber()) {
                case 12: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetter(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName), ByteBuffer.class));
                    continue block17;
                }
                case 9: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetterBoolean(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName)));
                    continue block17;
                }
                case 11: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetterDouble(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName)));
                    continue block17;
                }
                case 10: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetterFloat(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName)));
                    continue block17;
                }
                case 1: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetterByte(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName)));
                    continue block17;
                }
                case 3: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetterShort(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName)));
                    continue block17;
                }
                case 5: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetterInt(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName)));
                    continue block17;
                }
                case 7: 
                case 13: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetterLong(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName)));
                    continue block17;
                }
                case 8: {
                    setterMap.put(kuduColumnName, PojoUtils.createSetter(this.clazzForResultObject, (String)aliasesUsedForThisQuery.get(kuduColumnName), String.class));
                    continue block17;
                }
                case 0: {
                    LOG.error("Unsigned int 8 not supported yet");
                    throw new RuntimeException("uint8 not supported in Kudu schema yet");
                }
                case 2: {
                    LOG.error("Unsigned int 16 not supported yet");
                    throw new RuntimeException("uint16 not supported in Kudu schema yet");
                }
                case 4: {
                    LOG.error("Unsigned int 32 not supported yet");
                    throw new RuntimeException("uint32 not supported in Kudu schema yet");
                }
                case 6: {
                    LOG.error("Unsigned int 64 not supported yet");
                    throw new RuntimeException("uint64 not supported in Kudu schema yet");
                }
                case 999: {
                    LOG.error("unknown data type ( complex types ? )  not supported yet");
                    throw new RuntimeException("Unknown data type  ( complex types ? ) not supported in Kudu schema yet");
                }
            }
            LOG.error("unknown type/default  ( complex types ? )  not supported yet");
            throw new RuntimeException("Unknown type/default  ( complex types ? ) not supported in Kudu schema yet");
        }
        return setterMap;
    }

    public void activate(Context.OperatorContext context) {
    }

    public void deactivate() {
    }

    public void beforeCheckpoint(long windowId) {
    }

    public void checkpointed(long windowId) {
    }

    public void committed(long windowId) {
    }

    public ApexKuduConnection.ApexKuduConnectionBuilder getApexKuduConnectionInfo() {
        return this.apexKuduConnectionInfo;
    }

    public void setApexKuduConnectionInfo(ApexKuduConnection.ApexKuduConnectionBuilder apexKuduConnection) {
        this.apexKuduConnectionInfo = apexKuduConnection;
    }

    public List<KuduPartitionScanAssignmentMeta> getPartitionPieAssignment() {
        return this.partitionPieAssignment;
    }

    public void setPartitionPieAssignment(List<KuduPartitionScanAssignmentMeta> partitionPieAssignment) {
        this.partitionPieAssignment = partitionPieAssignment;
    }

    public KuduPartitionScanStrategy getPartitionScanStrategy() {
        return this.partitionScanStrategy;
    }

    public void setPartitionScanStrategy(KuduPartitionScanStrategy partitionScanStrategy) {
        this.partitionScanStrategy = partitionScanStrategy;
    }

    public String getCurrentQueryBeingProcessed() {
        return this.currentQueryBeingProcessed;
    }

    public void setCurrentQueryBeingProcessed(String currentQueryBeingProcessed) {
        this.currentQueryBeingProcessed = currentQueryBeingProcessed;
    }

    public int getNumberOfPartitions() {
        return this.numberOfPartitions;
    }

    public void setNumberOfPartitions(int numberOfPartitions) {
        this.numberOfPartitions = numberOfPartitions;
    }

    public KuduScanOrderStrategy getScanOrderStrategy() {
        return this.scanOrderStrategy;
    }

    public void setScanOrderStrategy(KuduScanOrderStrategy scanOrderStrategy) {
        this.scanOrderStrategy = scanOrderStrategy;
    }

    public AbstractKuduInputPartitioner getPartitioner() {
        return this.partitioner;
    }

    public void setPartitioner(AbstractKuduInputPartitioner partitioner) {
        this.partitioner = partitioner;
    }

    public AbstractKuduPartitionScanner<T, C> getScanner() {
        return this.scanner;
    }

    public void setScanner(AbstractKuduPartitionScanner<T, C> scanner) {
        this.scanner = scanner;
    }

    public Class<T> getClazzForResultObject() {
        return this.clazzForResultObject;
    }

    public void setClazzForResultObject(Class<T> clazzForResultObject) {
        this.clazzForResultObject = clazzForResultObject;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public SpinPolicy getCpuSpinPolicyForWaitingInBuffer() {
        return this.cpuSpinPolicyForWaitingInBuffer;
    }

    public void setCpuSpinPolicyForWaitingInBuffer(SpinPolicy cpuSpinPolicyForWaitingInBuffer) {
        this.cpuSpinPolicyForWaitingInBuffer = cpuSpinPolicyForWaitingInBuffer;
    }

    public int getBufferCapacity() {
        return this.bufferCapacity;
    }

    public void setBufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    public Map<String, String> getKuduColNameToPOJOFieldNameMap() {
        return this.kuduColNameToPOJOFieldNameMap;
    }

    public void setKuduColNameToPOJOFieldNameMap(Map<String, String> kuduColNameToPOJOFieldNameMap) {
        this.kuduColNameToPOJOFieldNameMap = kuduColNameToPOJOFieldNameMap;
    }

    public Map<String, ColumnSchema> getKuduColNameToSchemaMapping() {
        return this.kuduColNameToSchemaMapping;
    }

    public void setKuduColNameToSchemaMapping(Map<String, ColumnSchema> kuduColNameToSchemaMapping) {
        this.kuduColNameToSchemaMapping = kuduColNameToSchemaMapping;
    }

    public int getMaxTuplesPerWindow() {
        return this.maxTuplesPerWindow;
    }

    public void setMaxTuplesPerWindow(int maxTuplesPerWindow) {
        this.maxTuplesPerWindow = maxTuplesPerWindow;
    }

    public void setBuffer(DisruptorBlockingQueue<KuduRecordWithMeta<T>> buffer) {
        this.buffer = buffer;
    }

    public DisruptorBlockingQueue<KuduRecordWithMeta<T>> getBuffer() {
        return this.buffer;
    }

    public WindowDataManager getWindowDataManager() {
        return this.windowDataManager;
    }

    public void setWindowDataManager(WindowDataManager windowDataManager) {
        this.windowDataManager = windowDataManager;
    }

    public boolean isFaultTolerantScanner() {
        return this.isFaultTolerantScanner;
    }

    public void setFaultTolerantScanner(boolean faultTolerantScanner) {
        this.isFaultTolerantScanner = faultTolerantScanner;
    }

    public Map<String, String> getOptionsEnabledForCurrentQuery() {
        return this.optionsEnabledForCurrentQuery;
    }

    public void setOptionsEnabledForCurrentQuery(Map<String, String> optionsEnabledForCurrentQuery) {
        this.optionsEnabledForCurrentQuery = optionsEnabledForCurrentQuery;
    }

    public boolean isPartitioned() {
        return this.isPartitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.isPartitioned = partitioned;
    }
}

