/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.kafka;

import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.apex.malhar.kafka.KafkaOperatorTestBase;
import org.apache.apex.malhar.kafka.KafkaTestPartitioner;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;

public class KafkaTestProducer
implements Runnable {
    private final Producer<String, String> producer;
    private final Producer<String, String> producer1;
    private final String topic;
    private int sendCount = 20;
    private final Random rand = new Random();
    private boolean hasPartition = false;
    private boolean hasMultiCluster = false;
    private List<String> messages;
    private String ackType = "1";

    public int getSendCount() {
        return this.sendCount;
    }

    public void setSendCount(int sendCount) {
        this.sendCount = sendCount;
    }

    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    private Properties createProducerConfig(int cid) {
        Properties props = new Properties();
        props.setProperty("value.serializer", StringSerializer.class.getName());
        props.setProperty("key.serializer", StringSerializer.class.getName());
        props.setProperty("partitioner.class", KafkaTestPartitioner.class.getName());
        String brokerList = "localhost:" + KafkaOperatorTestBase.TEST_KAFKA_BROKER_PORT[cid][0];
        brokerList = brokerList + (this.hasPartition ? ",localhost:" + KafkaOperatorTestBase.TEST_KAFKA_BROKER_PORT[cid][1] : "");
        props.put("bootstrap.servers", brokerList);
        props.setProperty("metadata.max.age.ms", "20000");
        props.setProperty("acks", this.getAckType());
        return props;
    }

    public KafkaTestProducer(String topic) {
        this(topic, false);
    }

    public KafkaTestProducer(String topic, boolean hasPartition, boolean hasMultiCluster) {
        this.topic = topic;
        this.hasPartition = hasPartition;
        this.hasMultiCluster = hasMultiCluster;
        this.producer = new KafkaProducer(this.createProducerConfig(0));
        this.producer1 = hasMultiCluster ? new KafkaProducer(this.createProducerConfig(1)) : null;
    }

    public KafkaTestProducer(String topic, boolean hasPartition) {
        this(topic, hasPartition, false);
    }

    private void generateMessages() {
        for (int messageNo = 1; messageNo <= this.sendCount; ++messageNo) {
            String messageStr = "Message_" + messageNo;
            int k = this.rand.nextInt(100);
            this.producer.send(new ProducerRecord(this.topic, (Object)("" + k), (Object)("c1" + messageStr)));
            if (!this.hasMultiCluster) continue;
            ++messageNo;
            this.producer1.send(new ProducerRecord(this.topic, (Object)("" + k), (Object)("c2" + messageStr)));
        }
        this.producer.send(new ProducerRecord(this.topic, (Object)"0", (Object)"END_TUPLE"));
        if (this.hasMultiCluster) {
            this.producer1.send(new ProducerRecord(this.topic, (Object)"0", (Object)"END_TUPLE"));
        }
        if (this.hasPartition) {
            this.producer.send(new ProducerRecord(this.topic, (Object)"1", (Object)"END_TUPLE"));
            if (this.hasMultiCluster) {
                this.producer1.send(new ProducerRecord(this.topic, (Object)"1", (Object)"END_TUPLE"));
            }
        }
    }

    @Override
    public void run() {
        if (this.messages == null) {
            this.generateMessages();
        } else {
            for (String msg : this.messages) {
                Future f = this.producer.send(new ProducerRecord(this.topic, (Object)"", (Object)msg));
                try {
                    f.get(30L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.producer.close();
        if (this.producer1 != null) {
            this.producer1.close();
        }
    }

    public void close() {
        this.producer.close();
    }

    public String getAckType() {
        return this.ackType;
    }

    public void setAckType(String ackType) {
        this.ackType = ackType;
    }
}

