/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.flume.storage;

import com.datatorrent.api.StreamCodec;
import com.datatorrent.netlet.util.Slice;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Event;
import org.apache.flume.event.EventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventCodec
implements StreamCodec<Event> {
    private final transient Kryo kryo = new Kryo();
    private static final Logger logger = LoggerFactory.getLogger(EventCodec.class);

    public EventCodec() {
        this.kryo.setClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public Object fromByteArray(Slice fragment) {
        ByteArrayInputStream is = new ByteArrayInputStream(fragment.buffer, fragment.offset, fragment.length);
        Input input = new Input((InputStream)is);
        HashMap headers = (HashMap)this.kryo.readObjectOrNull(input, HashMap.class);
        byte[] body = (byte[])this.kryo.readObjectOrNull(input, byte[].class);
        return EventBuilder.withBody((byte[])body, (Map)headers);
    }

    public Slice toByteArray(Event event) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)os);
        HashMap headers = event.getHeaders();
        if (headers != null && headers.getClass() != HashMap.class) {
            HashMap tmp = new HashMap(headers.size());
            tmp.putAll(headers);
            headers = tmp;
        }
        this.kryo.writeObjectOrNull(output, (Object)headers, HashMap.class);
        this.kryo.writeObjectOrNull(output, (Object)event.getBody(), byte[].class);
        output.flush();
        byte[] bytes = os.toByteArray();
        return new Slice(bytes, 0, bytes.length);
    }

    public int getPartition(Event o) {
        return o.hashCode();
    }
}

