/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.flume.interceptor;

import java.util.Arrays;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFilteringInterceptor
implements Interceptor {
    private final byte srcSeparator;
    private final byte dstSeparator;
    private final int maxIndex;
    private final int maxColumn;
    private final int[] columns;
    private final int[] positions;
    private static final Logger logger = LoggerFactory.getLogger(ColumnFilteringInterceptor.class);

    private ColumnFilteringInterceptor(int[] columns, byte srcSeparator, byte dstSeparator) {
        this.columns = columns;
        int tempMaxColumn = Integer.MIN_VALUE;
        for (int column : columns) {
            if (column <= tempMaxColumn) continue;
            tempMaxColumn = column;
        }
        this.maxIndex = tempMaxColumn;
        this.maxColumn = tempMaxColumn + 1;
        this.positions = new int[this.maxColumn + 1];
        this.srcSeparator = srcSeparator;
        this.dstSeparator = dstSeparator;
    }

    public void initialize() {
    }

    public Event intercept(Event event) {
        boolean separatorTerminated;
        int nextVirginIndex;
        byte[] body = event.getBody();
        if (body == null) {
            return event;
        }
        int length = body.length;
        int i = 0;
        int index = 0;
        while (i < length) {
            if (body[i++] != this.srcSeparator) continue;
            this.positions[++index] = i;
            if (index < this.maxIndex) continue;
        }
        if (i == length && index < this.maxColumn) {
            nextVirginIndex = index + 2;
            this.positions[nextVirginIndex - 1] = length;
            separatorTerminated = length > 0 ? body[length - 1] != this.srcSeparator : false;
        } else {
            nextVirginIndex = index + 1;
            separatorTerminated = true;
        }
        int newArrayLen = 0;
        i = this.columns.length;
        while (i-- > 0) {
            int column = this.columns[i];
            int len = this.positions[column + 1] - this.positions[column];
            if (len <= 0) {
                ++newArrayLen;
                continue;
            }
            if (separatorTerminated && this.positions[column + 1] == length) {
                ++newArrayLen;
            }
            newArrayLen += len;
        }
        byte[] newbody = new byte[newArrayLen];
        int newoffset = 0;
        for (int column : this.columns) {
            int len = this.positions[column + 1] - this.positions[column];
            if (len > 0) {
                System.arraycopy(body, this.positions[column], newbody, newoffset, len);
                if (newbody[(newoffset += len) - 1] == this.srcSeparator) {
                    newbody[newoffset - 1] = this.dstSeparator;
                    continue;
                }
                newbody[newoffset++] = this.dstSeparator;
                continue;
            }
            newbody[newoffset++] = this.dstSeparator;
        }
        event.setBody(newbody);
        Arrays.fill(this.positions, 1, nextVirginIndex, 0);
        return event;
    }

    public List<Event> intercept(List<Event> events) {
        for (Event event : events) {
            this.intercept(event);
        }
        return events;
    }

    public void close() {
    }

    public static class Constants {
        public static final String SRC_SEPARATOR = "srcSeparator";
        public static final byte SRC_SEPARATOR_DFLT = 2;
        public static final String DST_SEPARATOR = "dstSeparator";
        public static final byte DST_SEPARATOR_DFLT = 1;
        public static final String COLUMNS = "columns";
    }

    public static class Builder
    implements Interceptor.Builder {
        private int[] columns;
        private byte srcSeparator;
        private byte dstSeparator;

        public Interceptor build() {
            return new ColumnFilteringInterceptor(this.columns, this.srcSeparator, this.dstSeparator);
        }

        public void configure(Context context) {
            String sColumns = context.getString("columns");
            if (sColumns == null || sColumns.trim().isEmpty()) {
                throw new Error("This interceptor requires filtered columns to be specified!");
            }
            String[] parts = sColumns.split(" ");
            this.columns = new int[parts.length];
            int i = parts.length;
            while (i-- > 0) {
                this.columns[i] = Integer.parseInt(parts[i]);
            }
            this.srcSeparator = context.getInteger("srcSeparator", Integer.valueOf(2)).byteValue();
            this.dstSeparator = context.getInteger("dstSeparator", Integer.valueOf(1)).byteValue();
        }
    }
}

