/*
 * Decompiled with CFR 0.152.
 */
package org.apache.apex.malhar.flume.interceptor;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.apex.malhar.flume.interceptor.ColumnFilteringInterceptor;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnFilteringFormattingInterceptor
implements Interceptor {
    private final byte srcSeparator;
    private final byte[][] dstSeparators;
    private final byte[] prefix;
    private final int maxIndex;
    private final int maxColumn;
    private final int[] columns;
    private final int[] positions;
    private static final Logger logger = LoggerFactory.getLogger(ColumnFilteringFormattingInterceptor.class);

    private ColumnFilteringFormattingInterceptor(int[] columns, byte srcSeparator, byte[][] dstSeparators, byte[] prefix) {
        this.columns = columns;
        int tempMaxColumn = Integer.MIN_VALUE;
        for (int column : columns) {
            if (column <= tempMaxColumn) continue;
            tempMaxColumn = column;
        }
        this.maxIndex = tempMaxColumn;
        this.maxColumn = tempMaxColumn + 1;
        this.positions = new int[this.maxColumn + 1];
        this.srcSeparator = srcSeparator;
        this.dstSeparators = dstSeparators;
        this.prefix = prefix;
    }

    public void initialize() {
    }

    public Event intercept(Event event) {
        int nextVirginIndex;
        byte[] body = event.getBody();
        if (body == null) {
            return event;
        }
        int length = body.length;
        int i = 0;
        int index = 0;
        while (i < length) {
            if (body[i++] != this.srcSeparator) continue;
            this.positions[++index] = i;
            if (index < this.maxIndex) continue;
        }
        boolean separatorAtEnd = true;
        if (i == length && index < this.maxColumn) {
            nextVirginIndex = index + 2;
            this.positions[nextVirginIndex - 1] = length;
            separatorAtEnd = length > 0 ? body[length - 1] == this.srcSeparator : false;
        } else {
            nextVirginIndex = index + 1;
        }
        int newArrayLen = this.prefix.length;
        i = this.columns.length;
        while (i-- > 0) {
            int column = this.columns[i];
            int len = this.positions[column + 1] - this.positions[column];
            if (len > 0) {
                newArrayLen = this.positions[column + 1] == length && !separatorAtEnd ? (newArrayLen += len) : (newArrayLen += len - 1);
            }
            newArrayLen += this.dstSeparators[i].length;
        }
        byte[] newBody = new byte[newArrayLen];
        int newOffset = 0;
        if (this.prefix.length > 0) {
            System.arraycopy(this.prefix, 0, newBody, 0, this.prefix.length);
            newOffset += this.prefix.length;
        }
        int dstSeparatorsIdx = 0;
        for (int column : this.columns) {
            int len = this.positions[column + 1] - this.positions[column];
            byte[] separator = this.dstSeparators[dstSeparatorsIdx++];
            if (len > 0) {
                System.arraycopy(body, this.positions[column], newBody, newOffset, len);
                if (newBody[(newOffset += len) - 1] == this.srcSeparator) {
                    --newOffset;
                }
            }
            System.arraycopy(separator, 0, newBody, newOffset, separator.length);
            newOffset += separator.length;
        }
        event.setBody(newBody);
        Arrays.fill(this.positions, 1, nextVirginIndex, 0);
        return event;
    }

    public List<Event> intercept(List<Event> events) {
        for (Event event : events) {
            this.intercept(event);
        }
        return events;
    }

    public void close() {
    }

    public static class Constants
    extends ColumnFilteringInterceptor.Constants {
        public static final String COLUMNS_FORMATTER = "columnsFormatter";
    }

    public static class Builder
    implements Interceptor.Builder {
        private int[] columns;
        private byte srcSeparator;
        private byte[][] dstSeparators;
        private byte[] prefix;

        public Interceptor build() {
            return new ColumnFilteringFormattingInterceptor(this.columns, this.srcSeparator, this.dstSeparators, this.prefix);
        }

        public void configure(Context context) {
            String formatter = context.getString("columnsFormatter");
            if (Strings.isNullOrEmpty((String)formatter)) {
                throw new IllegalArgumentException("This interceptor requires columns format to be specified!");
            }
            ArrayList lSeparators = Lists.newArrayList();
            ArrayList lColumns = Lists.newArrayList();
            Pattern colPat = Pattern.compile("\\{\\d+?\\}");
            Matcher matcher = colPat.matcher(formatter);
            int separatorStart = 0;
            String lPrefix = "";
            while (matcher.find()) {
                String col = matcher.group();
                lColumns.add(Integer.parseInt(col.substring(1, col.length() - 1)));
                if (separatorStart == 0 && matcher.start() > 0) {
                    lPrefix = formatter.substring(0, matcher.start());
                } else if (separatorStart > 0) {
                    lSeparators.add(formatter.substring(separatorStart, matcher.start()));
                }
                separatorStart = matcher.end();
            }
            if (separatorStart < formatter.length()) {
                lSeparators.add(formatter.substring(separatorStart, formatter.length()));
            }
            this.columns = Ints.toArray((Collection)lColumns);
            byte[] emptyStringBytes = "".getBytes();
            this.dstSeparators = new byte[this.columns.length][];
            for (int i = 0; i < this.columns.length; ++i) {
                this.dstSeparators[i] = i < lSeparators.size() ? ((String)lSeparators.get(i)).getBytes() : emptyStringBytes;
            }
            this.srcSeparator = context.getInteger("srcSeparator", Integer.valueOf(2)).byteValue();
            this.prefix = lPrefix.getBytes();
        }
    }
}

