/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package com.datatorrent.common.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Class copy-pasted from java.util.concurrent.Executors and modified to meet our needs.
 *
 * @since 0.3.2
 */
public class NameableThreadFactory implements ThreadFactory
{
  private static final AtomicInteger poolNumber = new AtomicInteger(1);
  private final ThreadGroup group;
  private final AtomicInteger threadNumber = new AtomicInteger(1);
  private final String namePrefix;
  private final boolean isDaemon;

  public NameableThreadFactory(String groupname)
  {
    this(groupname, false);
  }

  public NameableThreadFactory(String groupname, boolean isDaemon)
  {
    SecurityManager s = java.lang.System.getSecurityManager();
    group = (s != null) ? s.getThreadGroup()
            : Thread.currentThread().getThreadGroup();
    namePrefix = groupname
            + "-"
            + poolNumber.getAndIncrement()
            + "-";
    this.isDaemon = isDaemon;
  }

  @Override
  public Thread newThread(Runnable r)
  {
    Thread t = new Thread(group, r,
                          namePrefix + threadNumber.getAndIncrement(),
                          0);
    if (t.isDaemon() != this.isDaemon) {
      t.setDaemon(isDaemon);
    }
    if (t.getPriority() != Thread.NORM_PRIORITY) {
      t.setPriority(Thread.NORM_PRIORITY);
    }
    return t;
  }
}
