/*
 * Decompiled with CFR 0.152.
 */
package com.datatorrent.api;

import com.datatorrent.netlet.util.DTThrowable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;

public interface StringCodec<T> {
    public T fromString(String var1);

    public String toString(T var1);

    public static class Class2String<T>
    implements StringCodec<Class<? extends T>>,
    Serializable {
        private static final long serialVersionUID = 201312082053L;

        @Override
        public Class<? extends T> fromString(String string) {
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                return clazz;
            }
            catch (Throwable cause) {
                DTThrowable.rethrow((Throwable)cause);
                return null;
            }
        }

        @Override
        public String toString(Class<? extends T> clazz) {
            return clazz.getCanonicalName();
        }
    }

    public static class Enum2String<T extends Enum<T>>
    implements StringCodec<T>,
    Serializable {
        private final Class<T> clazz;
        private static final long serialVersionUID = 201310181757L;

        public Enum2String(Class<T> clazz) {
            this.clazz = clazz;
        }

        @Override
        public T fromString(String string) {
            return Enum.valueOf(this.clazz, string);
        }

        @Override
        public String toString(T pojo) {
            return ((Enum)pojo).name();
        }
    }

    public static class Collection2String<T>
    implements StringCodec<Collection<T>>,
    Serializable {
        private final String separator;
        private final StringCodec<T> codec;
        private static final long serialVersionUID = 201401091806L;

        public Collection2String(String separator, StringCodec<T> codec) {
            this.separator = separator;
            this.codec = codec;
        }

        @Override
        public Collection<T> fromString(String string) {
            if (string == null) {
                return null;
            }
            if (string.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            String[] parts = string.split(this.separator);
            ArrayList<T> arrayList = new ArrayList<T>(parts.length);
            for (String part : parts) {
                arrayList.add(this.codec.fromString(part));
            }
            return arrayList;
        }

        @Override
        public String toString(Collection<T> pojo) {
            if (pojo == null) {
                return null;
            }
            if (pojo.isEmpty()) {
                return "";
            }
            Object[] parts = new String[pojo.size()];
            int i = 0;
            for (T o : pojo) {
                parts[i++] = this.codec.toString(o);
            }
            return StringUtils.join((Object[])parts, (String)this.separator);
        }
    }

    public static class Map2String<K, V>
    implements StringCodec<Map<K, V>>,
    Serializable {
        private final StringCodec<K> keyCodec;
        private final StringCodec<V> valueCodec;
        private final String separator;
        private final String equal;
        private static final long serialVersionUID = 201402272053L;

        public Map2String(String separator, String equal, StringCodec<K> keyCodec, StringCodec<V> valueCodec) {
            this.equal = equal;
            this.separator = separator;
            this.keyCodec = keyCodec;
            this.valueCodec = valueCodec;
        }

        @Override
        public Map<K, V> fromString(String string) {
            if (string == null) {
                return null;
            }
            if (string.isEmpty()) {
                return new HashMap();
            }
            String[] parts = string.split(this.separator);
            HashMap<K, V> map = new HashMap<K, V>();
            for (String part : parts) {
                String[] kvpair = part.split(this.equal, 2);
                map.put(this.keyCodec.fromString(kvpair[0]), this.valueCodec.fromString(kvpair[1]));
            }
            return map;
        }

        @Override
        public String toString(Map<K, V> map) {
            if (map == null) {
                return null;
            }
            if (map.isEmpty()) {
                return "";
            }
            Object[] parts = new String[map.size()];
            int i = 0;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                parts[i++] = this.keyCodec.toString(entry.getKey()) + this.equal + this.valueCodec.toString(entry.getValue());
            }
            return StringUtils.join((Object[])parts, (String)this.separator);
        }
    }

    public static class Object2String<T>
    implements StringCodec<T>,
    Serializable {
        public final String separator;
        public final String propertySeparator;
        private static final long serialVersionUID = 201311141853L;

        public Object2String() {
            this.separator = ":";
            this.propertySeparator = "=";
        }

        public Object2String(String separator) {
            this.separator = separator;
            this.propertySeparator = "=";
        }

        public Object2String(String separator, String propertySeparator) {
            this.separator = separator;
            this.propertySeparator = propertySeparator;
        }

        @Override
        public T fromString(String string) {
            String[] parts = string.split(this.separator);
            try {
                Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(parts[0]);
                if (parts.length == 1) {
                    return (T)clazz.newInstance();
                }
                if (parts.length == 2) {
                    return (T)clazz.getConstructor(String.class).newInstance(parts[1]);
                }
                Object object = clazz.getConstructor(String.class).newInstance(parts[1]);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                for (int i = 2; i < parts.length; ++i) {
                    String[] keyValPair = parts[i].split(this.propertySeparator, 2);
                    hashMap.put(keyValPair[0], keyValPair[1]);
                }
                BeanUtils.populate(object, hashMap);
                return (T)object;
            }
            catch (Throwable cause) {
                DTThrowable.rethrow((Throwable)cause);
                return null;
            }
        }

        @Override
        public String toString(T pojo) {
            String arg = pojo.toString();
            if (arg == null) {
                return pojo.getClass().getCanonicalName();
            }
            return pojo.getClass().getCanonicalName() + this.separator + arg;
        }
    }

    public static class Boolean2String
    implements StringCodec<Boolean>,
    Serializable {
        private static final long serialVersionUID = 201310141159L;

        @Override
        public Boolean fromString(String string) {
            return Boolean.valueOf(string);
        }

        @Override
        public String toString(Boolean pojo) {
            return String.valueOf(pojo);
        }
    }

    public static class Long2String
    implements StringCodec<Long>,
    Serializable {
        private static final long serialVersionUID = 201310141158L;

        @Override
        public Long fromString(String string) {
            return Long.valueOf(string);
        }

        @Override
        public String toString(Long pojo) {
            return String.valueOf(pojo);
        }
    }

    public static class Integer2String
    implements StringCodec<Integer>,
    Serializable {
        private static final long serialVersionUID = 201310141157L;

        @Override
        public Integer fromString(String string) {
            return Integer.valueOf(string);
        }

        @Override
        public String toString(Integer pojo) {
            return String.valueOf(pojo);
        }
    }

    public static class String2String
    implements StringCodec<String>,
    Serializable {
        private static final long serialVersionUID = 201310141156L;

        @Override
        public String fromString(String string) {
            return string;
        }

        @Override
        public String toString(String pojo) {
            return pojo;
        }
    }
}

